/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.valueobject.IntegerValue;
import elgato.infrastructure.valueobject.IpAddressValue;
import elgato.infrastructure.valueobject.LongValue;
import elgato.infrastructure.valueobject.StringValue;
import elgato.infrastructure.valueobject.ValueChangeSupport;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public abstract class Value
implements ValueInterface {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$valueobject$Value == null ? (class$elgato$infrastructure$valueobject$Value = Value.class$("elgato.infrastructure.valueobject.Value")) : class$elgato$infrastructure$valueobject$Value);
    private Palette palette = Palette.createDefault();
    private ValueChangeSupport valueChangeSupport = new ValueChangeSupport(this);
    private String label;
    private String longLabel;
    private Object value;
    static /* synthetic */ Class class$elgato$infrastructure$valueobject$Value;

    protected Object getValueObject() {
        return this.value;
    }

    public static Value createLicenseKeyValue(String string, String string2) {
        StringValue stringValue = new StringValue(string, string2);
        stringValue.setPalette(Palette.createHex());
        return stringValue;
    }

    public static Value createIpAddressValue(String string, String string2) {
        return new IpAddressValue(string, string2);
    }

    public static Value createValue(String string, String string2) {
        return new StringValue(string, string2);
    }

    public static Value createValue(String string, int n) {
        return new IntegerValue(string, n);
    }

    public static Value createValue(String string, String string2, int n) {
        return new IntegerValue(string, string2, n);
    }

    public static Value createValue(String string, boolean bl) {
        return new IntegerValue(string, bl);
    }

    public static Value createValue(String string, long l) {
        return new LongValue(string, l);
    }

    protected Value(String string, Object object) {
        this.label = string;
        this.value = object;
    }

    protected Value(String string, String string2, Object object) {
        this.label = string;
        this.longLabel = string2;
        this.value = object;
    }

    public void fireValueChanged() {
        this.valueChangeSupport.fireValueChanged(this);
    }

    public void addValueListener(ValueListener valueListener) {
        this.valueChangeSupport.addValueListener(valueListener);
    }

    public void removeValueListener(ValueListener valueListener) {
        this.valueChangeSupport.removeValueListener(valueListener);
    }

    public boolean hasListener(ValueListener valueListener) {
        return this.valueChangeSupport.hasListener(valueListener);
    }

    public int getNumListeners() {
        return this.valueChangeSupport.getNumListeners();
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Palette getPalette() {
        return this.palette;
    }

    public void setPalette(Palette palette) {
        this.palette = palette;
    }

    public String getLongLabel() {
        if (this.longLabel == null) {
            return this.label;
        }
        return this.longLabel;
    }

    public void setLongLabel(String string) {
        this.longLabel = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (this.value != null ? !this.value.equals(value.value) : value.value != null) {
            return false;
        }
        if (this.label != null ? !this.label.equals(value.label) : value.label != null) {
            return false;
        }
        return !(this.longLabel != null ? !this.longLabel.equals(value.longLabel) : value.longLabel != null);
    }

    public int hashCode() {
        int n = 29 * (this.label != null ? this.label.hashCode() : 0);
        n = 29 * n + (this.longLabel != null ? this.longLabel.hashCode() : 0);
        n = 29 * n + (this.value != null ? this.value.hashCode() : 0);
        return n;
    }

    public String toString() {
        return this.value.toString();
    }

    public void send() {
    }

    public abstract boolean isValid(String var1);

    public abstract boolean isValid();

    protected void changeValue(Object object) {
        this.value = object;
        this.fireValueChanged();
    }

    public void increment(int n) {
        logger.error("Expected an implementation for increment() in " + this.getClass().getName(), new Exception());
    }

    public void decrement(int n) {
        logger.error("Expected an implementation for decrement() in " + this.getClass().getName(), new Exception());
    }

    public Conversion[] getConversions() {
        return new Conversion[0];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract /* synthetic */ void setValue(int var1);

    public abstract /* synthetic */ void setValue(String var1);

    public abstract /* synthetic */ void setValue(long var1);

    public abstract /* synthetic */ boolean booleanValue();

    public abstract /* synthetic */ int intValue();

    public abstract /* synthetic */ long longValue();
}

