/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.AlphaEditScreen;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ValueButton
extends ActionButton
implements ValueListener {
    private ValueInterface value;
    protected String listenerName;

    public ValueButton(String string, ValueInterface valueInterface, String string2) {
        super(valueInterface.getLabel(), string);
        this.value = valueInterface;
        this.listenerName = string2;
        this.addActionListener(new AlphaEditListener(valueInterface));
    }

    public ValueButton(String string, Value value, Font font, String string2) {
        this(string, value, string2);
        this.listenerName = string2;
        this.setBodyFont(font);
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public String getValue() {
        return ((Object)this.value).toString();
    }

    public void addNotify(MenuPanel menuPanel) {
        super.addNotify(menuPanel);
        this.value.addValueListener(this);
        this.updateBodyText();
    }

    public void removeNotify() {
        this.value.removeValueListener(this);
        super.removeNotify();
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.updateBodyText();
    }

    private void updateBodyText() {
        this.setBodyText(((Object)this.value).toString());
    }

    private static class AlphaEditListener
    implements ActionListener {
        private ValueInterface value;

        AlphaEditListener(ValueInterface valueInterface) {
            this.value = valueInterface;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MeasurementFactory.instance().getScreenManager().pushScreen(new AlphaEditScreen(this.value));
        }
    }
}

