/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.valueobject;

import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.StringActuator;
import elgato.infrastructure.util.Arrays;
import elgato.infrastructure.util.Comparator;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;

public class ValueChangeSupport {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$valueobject$ValueChangeSupport == null ? (class$elgato$infrastructure$valueobject$ValueChangeSupport = ValueChangeSupport.class$("elgato.infrastructure.valueobject.ValueChangeSupport")) : class$elgato$infrastructure$valueobject$ValueChangeSupport);
    private static Vector listenerLog;
    private static boolean recording;
    private static int listenerCountWarningThreshold;
    private Object value;
    private String valueIdString;
    private Vector listeners = new Vector();
    private static final String STRING_NA_VALUE = "N/A";
    private static final String STRING_NULL_VALUE = "NULL VALUE";
    private static final String STRING_NULL_OBJECT = "NULL";
    private static final String STRING_UNKNOWN_VALUE_TYPE = "UNKNOWN VALUE TYPE";
    static /* synthetic */ Class class$elgato$infrastructure$valueobject$ValueChangeSupport;

    public ValueChangeSupport(Object object) {
        this.value = object;
    }

    public void removeAllListeners() {
        this.listeners.removeAllElements();
    }

    public void Dispose() {
        this.listeners.removeAllElements();
        this.listeners = null;
    }

    public void addValueListener(ValueListener valueListener) {
        int n;
        String string;
        String string2 = this.getValueIdString();
        if (valueListener == null) {
            logger.error("null valueListener", new Exception("stack trace"));
        }
        if ((string = valueListener.getListenerName()) == null) {
            String string3 = valueListener.getClass() + "@" + Integer.toHexString(valueListener.hashCode());
            logger.warn(ValueChangeSupport.getValueTopic(this.value) + ":" + ValueChangeSupport.getValuePropertyName(this.value) + "('" + ValueChangeSupport.getValueLabel(this.value) + "')" + "adding listener with name=null " + string3);
            string = "null:" + string3;
        }
        for (n = 0; n < this.listeners.size(); ++n) {
            ValueListener valueListener2 = (ValueListener)this.listeners.elementAt(n);
            String string4 = valueListener2.getListenerName();
            if (string4 == null) {
                string4 = "null:" + valueListener2.getClass() + "@" + Integer.toHexString(valueListener2.hashCode());
            }
            if (!string4.equals(string)) continue;
            logger.warn(string2 + " apparent duplicate listener, existing: " + string4 + "@" + Integer.toHexString(valueListener2.hashCode()) + ", new: " + string + "@" + Integer.toHexString(valueListener.hashCode()));
        }
        this.listeners.addElement(valueListener);
        n = this.listeners.size();
        if (n > listenerCountWarningThreshold) {
            logger.warn("suspiciously high listener count for value '" + ValueChangeSupport.getValueLabel(this.value) + "' (" + n + ")");
        }
        if (recording) {
            ValueChangeSupport.logAdd(this.value, valueListener);
        }
    }

    public void removeValueListener(ValueListener valueListener) {
        if (!this.listeners.removeElement(valueListener) && logger.isDebugEnabled()) {
            logger.warn("removeElement can't find ValuListener " + ValueChangeSupport.getValueLabel(this.value));
        }
        if (recording) {
            ValueChangeSupport.logRemove(this.value, valueListener);
        }
    }

    public boolean hasListener(ValueListener valueListener) {
        return this.listeners.contains(valueListener);
    }

    public int getNumListeners() {
        return this.listeners.size();
    }

    public void fireValueChanged(ValueInterface valueInterface) {
        Object object;
        if (this.listeners.size() > 0 && logger.isDebugEnabled()) {
            String string = "<none>";
            object = "<none>";
            try {
                string = valueInterface.getLabel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                object = this.value.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            logger.debug("fireValueChanged (" + string + "=" + (String)object + ") " + ValueChangeSupport.getValueTopic(this.value) + ":" + ValueChangeSupport.getValuePropertyName(this.value) + " listener count=" + this.listeners.size());
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            object = (ValueListener)this.listeners.elementAt(i);
            object.valueChanged(valueInterface);
        }
    }

    private static synchronized void logAdd(Object object, ValueListener valueListener) {
        listenerLog.addElement(new LogElement(System.currentTimeMillis(), object, new Exception("Stack trace"), valueListener));
    }

    private static synchronized void logRemove(Object object, ValueListener valueListener) {
        boolean bl = false;
        for (int i = 0; i < listenerLog.size(); ++i) {
            LogElement logElement = (LogElement)listenerLog.elementAt(i);
            if (logElement.value != object || logElement.listener != valueListener) continue;
            if (bl) {
                logger.error("Multiple adds of the same listener exist! value=" + object + " listener=" + valueListener);
            }
            listenerLog.removeElement(logElement);
            bl = true;
        }
    }

    public static void startRecording() {
        recording = true;
        listenerLog = new Vector();
    }

    public static void endRecording() {
        recording = false;
    }

    public static int getRecordedTotalLiveListeners() {
        return listenerLog.size();
    }

    public static String getRecordingLog(boolean bl) {
        Object object;
        int n;
        if (listenerLog == null) {
            return "No recorded data.";
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("ValueChangeSupport recorded log report.");
        printWriter.println("Total live listeners: " + ValueChangeSupport.getRecordedTotalLiveListeners());
        printWriter.println();
        printWriter.println("Values with live listeners, grouped by value label, sorted by listener count");
        printWriter.println("Summary.");
        printWriter.println("============================================================================");
        Object[] objectArray = new Vector[listenerLog.size()];
        int n2 = 0;
        for (n = 0; n < listenerLog.size(); ++n) {
            object = (LogElement)listenerLog.elementAt(n);
            int n3 = ValueChangeSupport.searchForValueGroupWithLabel((Vector[])objectArray, n2, ValueChangeSupport.getValueLabel(((LogElement)object).value));
            System.out.println("label='" + ValueChangeSupport.getValueLabel(((LogElement)object).value) + "' j=" + n3);
            if (n3 < 0) {
                n3 = n2;
                objectArray[n2++] = new Vector();
            }
            ((Vector)objectArray[n3]).addElement(object);
        }
        Arrays.sort(objectArray, 0, n2, new VectorCountComparator());
        for (n = 0; n < n2; ++n) {
            object = objectArray[n];
            LogElement logElement = (LogElement)((Vector)object).elementAt(0);
            ValueChangeSupport.printPadded(printWriter, String.valueOf(((Vector)object).size()), 3, true);
            printWriter.print(' ');
            ValueChangeSupport.printPadded(printWriter, ValueChangeSupport.getValueLabel(logElement.value), 34, false);
            printWriter.print(' ');
            ValueChangeSupport.printPadded(printWriter, logElement.listener.getListenerName(), 36, false);
            printWriter.println();
        }
        printWriter.println();
        printWriter.println();
        if (bl) {
            printWriter.println("Detail:");
            printWriter.println("============================================================================");
            printWriter.println("<detail>");
            for (n = 0; n < n2; ++n) {
                object = objectArray[n];
                LogElement logElement = (LogElement)((Vector)object).elementAt(0);
                printWriter.println("  <value name=\"" + ValueChangeSupport.getValueLabel(logElement.value) + "\" listenerCount=\"" + ((Vector)object).size() + "\">");
                for (int i = 0; i < ((Vector)object).size(); ++i) {
                    LogElement logElement2 = (LogElement)((Vector)object).elementAt(i);
                    printWriter.println("    <listener class=\"" + logElement2.listener.getClass().getName() + "\"" + " hashCode=\"" + Integer.toHexString(logElement2.listener.hashCode()) + "\"" + " listenerBaseName=\"" + logElement2.listener.getListenerName() + "\"" + " addTime=\"" + logElement2.addTime + "\">");
                    printWriter.println("      <addStack>");
                    logElement2.addStackTrace.printStackTrace(printWriter);
                    printWriter.println("      </addStack>");
                    printWriter.println("    </listener>");
                }
                printWriter.println("  </value>");
            }
            printWriter.println("</detail>");
            printWriter.println();
            printWriter.println();
        }
        return stringWriter.toString();
    }

    private static int searchForValueGroupWithLabel(Vector[] vectorArray, int n, String string) {
        for (int i = 0; i < n; ++i) {
            Vector vector = vectorArray[i];
            LogElement logElement = (LogElement)vector.elementAt(0);
            if (!ValueChangeSupport.getValueLabel(logElement.value).equals(string)) continue;
            return i;
        }
        return -1;
    }

    private static String getValueLabel(Object object) {
        String string = object instanceof Value ? ((Value)object).getLabel() : (object instanceof ListActuator ? ((ListActuator)object).getLabel() : (object instanceof FrequencyActuator ? ((FrequencyActuator)object).getLabel() : (object instanceof LongActuator ? ((LongActuator)object).getLabel() : (object instanceof StringActuator ? ((StringActuator)object).getLabel() : (object == null ? STRING_NULL_VALUE : "UNKNOWN VALUE TYPE(" + object.getClass() + ")")))));
        return string.replace('\n', '_').replace('\r', '_').replace('\t', ' ');
    }

    private static String getValueTopic(Object object) {
        String string = object == null ? STRING_NULL_VALUE : (object instanceof Value ? STRING_NA_VALUE : (object instanceof ListActuator ? ((ListActuator)object).getTopic() : (object instanceof FrequencyActuator ? ((FrequencyActuator)object).getTopic() : (object instanceof LongActuator ? ((LongActuator)object).getTopic() : (object instanceof StringActuator ? ((StringActuator)object).getTopic() : "UNKNOWN VALUE TYPE(" + object.getClass() + ")")))));
        return string == null ? STRING_NULL_OBJECT : string;
    }

    private static String getValuePropertyName(Object object) {
        String string = object == null ? STRING_NULL_VALUE : (object instanceof Value ? STRING_NA_VALUE : (object instanceof ListActuator ? ((ListActuator)object).getPropertyName() : (object instanceof FrequencyActuator ? ((FrequencyActuator)object).getPropertyName() : (object instanceof LongActuator ? ((LongActuator)object).getPropertyName() : (object instanceof StringActuator ? ((StringActuator)object).getPropertyName() : "UNKNOWN VALUE TYPE(" + object.getClass() + ")")))));
        return string == null ? STRING_NULL_OBJECT : string;
    }

    private static String getValueTopicProperty(Object object) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = ValueChangeSupport.getValueTopic(object);
        String string2 = ValueChangeSupport.getValuePropertyName(object);
        if (string != STRING_NA_VALUE && string != STRING_NULL_OBJECT && string != STRING_NULL_VALUE && !string.startsWith(STRING_UNKNOWN_VALUE_TYPE)) {
            stringBuffer.append(string);
        }
        if (string2 != STRING_NA_VALUE && string2 != STRING_NULL_OBJECT && string2 != STRING_NULL_VALUE && !string2.startsWith(STRING_UNKNOWN_VALUE_TYPE)) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String getValueIdString() {
        if (this.valueIdString == null) {
            String string = ValueChangeSupport.getValueLabel(this.value);
            String string2 = ValueChangeSupport.getValueTopicProperty(this.value);
            String string3 = "";
            if (!string.startsWith(STRING_NULL_OBJECT) && !string.startsWith(STRING_UNKNOWN_VALUE_TYPE)) {
                string3 = string2.length() > 0 ? "('" + string + "')" : "'" + string + "'";
            }
            if (string3.length() == 0 && string2.length() == 0) {
                string2 = this.value.getClass().getName() + Integer.toHexString(this.value.hashCode());
            }
            this.valueIdString = string2 + string3;
        }
        return this.valueIdString;
    }

    private static void printPadded(PrintWriter printWriter, String string, int n, boolean bl) {
        if (!bl) {
            printWriter.print(string);
        }
        for (int i = n - string.length(); i > 0; --i) {
            printWriter.print(' ');
        }
        if (bl) {
            printWriter.print(string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        listenerCountWarningThreshold = 15;
    }

    private static class LogElement {
        final long addTime;
        final Throwable addStackTrace;
        final Object value;
        final ValueListener listener;

        public LogElement(long l, Object object, Throwable throwable, ValueListener valueListener) {
            this.addTime = l;
            this.value = object;
            this.addStackTrace = throwable;
            this.listener = valueListener;
        }
    }

    private static class VectorCountComparator
    implements Comparator {
        private VectorCountComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            Vector vector = (Vector)object;
            Vector vector2 = (Vector)object2;
            int n2 = vector.size();
            return n2 < (n = vector2.size()) ? -1 : (n2 == n ? 0 : 1);
        }
    }
}

