/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.wheel;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.wheel.BumpyRpgWheelAccelerator;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.wheel.SmoothRpgWheelAccelerator;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class RPGManager
extends ScrollWheelManager {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$wheel$RPGManager == null ? (class$elgato$infrastructure$wheel$RPGManager = RPGManager.class$("elgato.infrastructure.wheel.RPGManager")) : class$elgato$infrastructure$wheel$RPGManager);
    public static final String DEVICE = "/dev/rpg";
    private int ticksPerUnit = 1;
    private int rotationMult;
    static /* synthetic */ Class class$elgato$infrastructure$wheel$RPGManager;

    public RPGManager() {
        ListActuator listActuator = SystemMeasurementSettings.instance().getRPGType();
        listActuator.addValueListener(new ValueListener(){
            private final String listenerName = "RPGManager.rpgTypeListener";

            public String getListenerName() {
                return "RPGManager.rpgTypeListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                RPGManager.this.updateRPG(valueInterface.intValue());
            }
        });
        ScrollWheelManager.setAccelerator(new BumpyRpgWheelAccelerator());
        this.updateRPG(listActuator.intValue());
        new RPGReader().start();
    }

    private void updateRPG(int n) {
        if (n == 0) {
            this.setSmoothRpg();
        } else {
            this.setBumpyRpg();
        }
    }

    private synchronized void setSmoothRpg() {
        this.ticksPerUnit = 6;
        this.rotationMult = 1;
        ScrollWheelManager.setAccelerator(new SmoothRpgWheelAccelerator());
        this.reset();
    }

    private synchronized void setBumpyRpg() {
        this.ticksPerUnit = 3;
        this.rotationMult = 3;
        ScrollWheelManager.setAccelerator(new BumpyRpgWheelAccelerator());
        this.reset();
    }

    protected int getTicksPerUnit() {
        return this.ticksPerUnit;
    }

    protected int getMinElapsedTime() {
        return 250;
    }

    private synchronized void processValue(int n) {
        n = -n;
        int n2 = n * this.rotationMult;
        this.processWheelTurn(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class RPGReader
    extends Thread {
        public RPGReader() {
            this.setDaemon(true);
        }

        public void run() {
            long l;
            long l2 = l = System.currentTimeMillis();
            long l3 = 0L;
            long l4 = 0L;
            long l5 = l;
            if (logger.isDebugEnabled()) {
                logger.debug("RPGReader started");
            }
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(RPGManager.DEVICE));
                byte[] byArray = new byte[2];
                RPGManager.this.reset();
                this.setPriority(6);
                while (true) {
                    try {
                        while (true) {
                            dataInputStream.readFully(byArray);
                            ++l4;
                            l = System.currentTimeMillis();
                            l3 += l - l2;
                            l2 = l;
                            int n = byArray[0] & 0xFF | byArray[1] << 8;
                            if (n != 0) {
                                if (logger.isKeyPressEnabled()) {
                                    logger.keyPress("Average loop wait = " + Long.toString(l3 / l4) + ", loop count = " + l4 + ", wait since last value = " + Long.toString(l - l5));
                                }
                                l5 = l;
                                RPGManager.this.processValue(n);
                                l3 = 0L;
                                l4 = 0L;
                            }
                            Thread.sleep(20L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        logger.error("Unexpected interruption", interruptedException);
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                logger.error("/dev/rpg not found, RPG not functional.");
            }
            catch (IOException iOException) {
                logger.error("Error reading from /dev/rpg", iOException);
            }
        }
    }
}

