/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.wheel;

import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.wheel.DefaultWheelAccelerator;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.WheelAccelerator;
import elgato.infrastructure.wheel.WheelRotationConsolidator;

public abstract class ScrollWheelManager {
    private static final int WHEEL_MOVE_COMPLETE_DELAY = 450;
    private static final int WHEEL_MOVE_RESET_DELAY = 3500;
    private final long EVENT_GENERATION_FREQUENCY = 100L;
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$wheel$ScrollWheelManager == null ? (class$elgato$infrastructure$wheel$ScrollWheelManager = ScrollWheelManager.class$("elgato.infrastructure.wheel.ScrollWheelManager")) : class$elgato$infrastructure$wheel$ScrollWheelManager);
    private static ScrollWheelManager instance;
    private static WheelRotationConsolidator consolidator;
    private static boolean wheelMoveInProcess;
    private static WheelAccelerator accelerator;
    private WheelEventGenerator consolidationThread;
    private int firedEventsInProcess = 0;
    private ScrollWheelListener[] listeners = new ScrollWheelListener[0];
    static /* synthetic */ Class class$elgato$infrastructure$wheel$ScrollWheelManager;

    public ScrollWheelManager() {
        consolidator = null;
        this.consolidationThread = new WheelEventGenerator();
        this.consolidationThread.start();
    }

    public static ScrollWheelManager instance() {
        return instance;
    }

    public static void registerInstance(ScrollWheelManager scrollWheelManager) {
        instance = scrollWheelManager;
    }

    public static void deregisterInstance() {
        instance = null;
    }

    public static WheelAccelerator getAccelerator() {
        if (accelerator == null) {
            accelerator = new DefaultWheelAccelerator();
        }
        return accelerator;
    }

    protected static void setAccelerator(WheelAccelerator wheelAccelerator) {
        accelerator = wheelAccelerator;
    }

    public synchronized void addScrollWheelListener(ScrollWheelListener scrollWheelListener) {
        ScrollWheelListener[] scrollWheelListenerArray = new ScrollWheelListener[this.listeners.length + 1];
        System.arraycopy(this.listeners, 0, scrollWheelListenerArray, 0, this.listeners.length);
        scrollWheelListenerArray[this.listeners.length] = scrollWheelListener;
        this.listeners = scrollWheelListenerArray;
    }

    public synchronized void removeScrollWheelListener(ScrollWheelListener scrollWheelListener) {
        int n = -1;
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] != scrollWheelListener) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return;
        }
        ScrollWheelListener[] scrollWheelListenerArray = new ScrollWheelListener[this.listeners.length - 1];
        System.arraycopy(this.listeners, 0, scrollWheelListenerArray, 0, n);
        System.arraycopy(this.listeners, n + 1, scrollWheelListenerArray, n, this.listeners.length - n - 1);
        this.listeners = scrollWheelListenerArray;
    }

    protected final synchronized void fireScrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        ScrollWheelListener[] scrollWheelListenerArray = this.listeners;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("scroll by units/rot " + scrollWheelEvent.getUnitsMoved() + "/" + scrollWheelEvent.getWheelRotation());
        }
        for (int i = scrollWheelListenerArray.length - 1; i >= 0 && !scrollWheelEvent.isConsumed(); --i) {
            ScrollWheelListener scrollWheelListener = scrollWheelListenerArray[i];
            if (logger.isDebugEnabled()) {
                logger.debug(" * listener[" + i + "]=" + scrollWheelListener.getClass().getName());
            }
            scrollWheelListener.scrollWheelMoved(scrollWheelEvent);
        }
        try {
            EventDispatchThread.invokeLater(new Runnable(){

                public void run() {
                    ScrollWheelManager.this.recordFiredEventCompletion();
                }
            }, "ScrollWheelManager.fireScrollWheelMoved");
            ++this.firedEventsInProcess;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Exception trying to record event completion", runtimeException);
        }
    }

    protected final synchronized void fireScrollWheelMoveComplete() {
        ScrollWheelListener[] scrollWheelListenerArray = this.listeners;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("scroll complete");
        }
        for (int i = scrollWheelListenerArray.length - 1; i >= 0; --i) {
            ScrollWheelListener scrollWheelListener = scrollWheelListenerArray[i];
            if (logger.isDebugEnabled()) {
                logger.debug(" * listener[" + i + "]=" + scrollWheelListener.getClass().getName());
            }
            scrollWheelListener.scrollWheelMoveComplete();
        }
    }

    public final void turnTheWheel(ScrollWheelEvent scrollWheelEvent) {
        this.fireScrollWheelMoved(scrollWheelEvent);
        this.fireScrollWheelMoveComplete();
    }

    protected void fireEventInGuiEventThread(final ScrollWheelEvent scrollWheelEvent) {
        try {
            EventDispatchThread.invokeLater(new Runnable(){

                public void run() {
                    ScrollWheelManager.this.fireScrollWheelMoved(scrollWheelEvent);
                }
            }, "ScrollWheelManager.fireEventInGuiEventThread");
        }
        catch (RuntimeException runtimeException) {
            logger.error("Exception while notifying listeners of event", runtimeException);
        }
    }

    protected synchronized void processWheelTurn(int n) {
        if (n == 0) {
            return;
        }
        if (consolidator == null) {
            consolidator = new WheelRotationConsolidator(this.getTicksPerUnit(), this.getMinElapsedTime(), System.currentTimeMillis(), n, 0);
        } else {
            consolidator.addRotation(n);
        }
        if (!wheelMoveInProcess) {
            if (logger.isKeyPressEnabled()) {
                logger.keyPress("interrupting consolidator thread");
            }
            this.consolidationThread.interrupt();
        }
        wheelMoveInProcess = true;
    }

    protected int getTicksPerUnit() {
        return 1;
    }

    protected int getMinElapsedTime() {
        return 100;
    }

    public static boolean isWheelMoveInProcess() {
        return wheelMoveInProcess;
    }

    private synchronized void recordFiredEventCompletion() {
        --this.firedEventsInProcess;
    }

    protected synchronized void reset() {
        consolidator = null;
        wheelMoveInProcess = false;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("reset complete");
        }
    }

    private void checkForReadyWheelEvent() {
        if (consolidator == null) {
            return;
        }
        if (this.firedEventsInProcess > 1) {
            return;
        }
        long l = System.currentTimeMillis();
        if (consolidator.getRotationEventsRecorded() > 0) {
            this.fireEventInGuiEventThread(consolidator.createEvent());
        } else if (consolidator != null && wheelMoveInProcess && l - consolidator.getInitialTimeInMillis() > 450L) {
            try {
                EventDispatchThread.invokeLater(new Runnable(){

                    public void run() {
                        ScrollWheelManager.this.fireScrollWheelMoveComplete();
                    }
                }, "ScrollWheelManager.fireScrollWheelMoveComplete");
            }
            catch (RuntimeException runtimeException) {
                logger.error("Exception while notifying listeners of completion", runtimeException);
            }
            wheelMoveInProcess = false;
        } else if (consolidator != null && l - consolidator.getInitialTimeInMillis() > 3500L) {
            this.reset();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        wheelMoveInProcess = false;
        ScrollWheelManager.deregisterInstance();
    }

    private class WheelEventGenerator
    extends Thread {
        public WheelEventGenerator() {
            this.setDaemon(true);
        }

        public void run() {
            if (logger.isDebugEnabled()) {
                logger.debug("WheelEventGenerator started");
            }
            this.setPriority(6);
            while (true) {
                try {
                    while (true) {
                        ScrollWheelManager.this.checkForReadyWheelEvent();
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    if (!logger.isKeyPressEnabled()) continue;
                    logger.keyPress("waking consolidator for start of new rotation");
                    continue;
                }
                break;
            }
        }
    }
}

