/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.wheel;

import elgato.infrastructure.wheel.WheelAccelerator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class TableDrivenWheelAccelerator
implements WheelAccelerator {
    protected FactorMap[] rotationMap;
    protected FactorMap[] unitMap;

    public int getRotationAccelerationFactor(int n) {
        return this.interpolateTableValues(this.rotationMap, n);
    }

    public int getUnitAccelerationFactor(int n) {
        return this.interpolateTableValues(this.unitMap, n);
    }

    public int getCurrentWeight() {
        return 1;
    }

    public int getHistoryWeight() {
        return 1;
    }

    protected int interpolateTableValues(FactorMap[] factorMapArray, int n) {
        if (factorMapArray.length < 1) {
            return 1000;
        }
        if (n < factorMapArray[0].rate) {
            return factorMapArray[0].factor;
        }
        if (n > factorMapArray[factorMapArray.length - 1].rate) {
            return factorMapArray[factorMapArray.length - 1].factor;
        }
        int n2 = 0;
        int n3 = factorMapArray.length;
        int n4 = 0;
        while (n4 < factorMapArray.length && factorMapArray[n4].rate <= n) {
            n2 = n4++;
        }
        n4 = factorMapArray.length - 1;
        while (n4 >= 0 && factorMapArray[n4].rate >= n) {
            n3 = n4--;
        }
        if (n2 == n3) {
            return factorMapArray[n2].factor;
        }
        int n5 = 1000 * (n - factorMapArray[n2].rate) / (factorMapArray[n3].rate - factorMapArray[n2].rate);
        int n6 = factorMapArray[n3].factor - factorMapArray[n2].factor;
        return factorMapArray[n2].factor + n5 * n6 / 1000;
    }

    protected FactorMap[] readTable(String string) {
        int n;
        Object object;
        FileReader fileReader;
        try {
            fileReader = new FileReader(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        FactorMap[] factorMapArray = new FactorMap[10];
        int n2 = 0;
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n3;
                object = new StringTokenizer(string2, ", \t");
                if (((StringTokenizer)object).countTokens() != 2) continue;
                if (++n2 > factorMapArray.length) {
                    FactorMap[] factorMapArray2 = new FactorMap[factorMapArray.length + 10];
                    for (n3 = 0; n3 < factorMapArray.length; ++n3) {
                        factorMapArray2[n3] = factorMapArray[n3];
                    }
                    factorMapArray = factorMapArray2;
                }
                n = Integer.parseInt(((StringTokenizer)object).nextToken());
                n3 = Integer.parseInt(((StringTokenizer)object).nextToken());
                factorMapArray[n2 - 1] = new FactorMap(n, n3);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        object = new FactorMap[n2];
        for (n = 0; n < n2; ++n) {
            object[n] = factorMapArray[n];
        }
        return object;
    }

    protected class FactorMap {
        public int rate;
        public int factor;

        public FactorMap(int n, int n2) {
            this.rate = n;
            this.factor = n2;
        }
    }
}

