/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.wheel;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.wheel.WheelAccelerator;

public class WheelRotationConsolidator {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$wheel$WheelRotationConsolidator == null ? (class$elgato$infrastructure$wheel$WheelRotationConsolidator = WheelRotationConsolidator.class$("elgato.infrastructure.wheel.WheelRotationConsolidator")) : class$elgato$infrastructure$wheel$WheelRotationConsolidator);
    private int ticksPerUnit;
    private int minElapsedTime;
    private long initialTimeInMillis;
    private int cummulativeRotation;
    private int unitTickRemainder;
    private long lastAddTimeInMillis;
    private int rotationEventsRecorded;
    private int acceleratedUnits;
    private int acceleratedRotation;
    private long createTime;
    private int historicalRotations;
    static /* synthetic */ Class class$elgato$infrastructure$wheel$WheelRotationConsolidator;

    public WheelRotationConsolidator(int n, int n2, long l, int n3, int n4) {
        this.unitTickRemainder = n4;
        this.initialTimeInMillis = l;
        this.minElapsedTime = n2;
        this.createTime = this.initialTimeInMillis;
        this.ticksPerUnit = n;
        this.cummulativeRotation = n3;
        this.historicalRotations = Math.abs(this.cummulativeRotation);
        this.lastAddTimeInMillis = this.initialTimeInMillis;
        this.rotationEventsRecorded = n3 != 0 ? 1 : 0;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("created with ticks/unit=" + n + ", cummulative=" + n3 + ", remainder=" + n4);
        }
    }

    public synchronized void addRotation(int n) {
        this.lastAddTimeInMillis = System.currentTimeMillis();
        ++this.rotationEventsRecorded;
        this.cummulativeRotation += n;
        this.historicalRotations += Math.abs(n);
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("addRotation(" + n + ") " + this.getElapsedTimeInMillis() + " ms" + ", rot=" + this.cummulativeRotation + ", history: " + Long.toString(this.lastAddTimeInMillis - this.createTime) + " ms" + ", rot=" + this.historicalRotations);
        }
    }

    public ScrollWheelEvent createEvent() {
        this.applyAcceleration();
        return new ScrollWheelEvent(this.acceleratedUnits, this.acceleratedRotation);
    }

    public long getInitialTimeInMillis() {
        return this.initialTimeInMillis;
    }

    public void setInitialTimeInMillis(long l) {
        this.initialTimeInMillis = l;
    }

    public int getUnitTickRemainder() {
        return this.unitTickRemainder;
    }

    public int getTicksPerUnit() {
        return this.ticksPerUnit;
    }

    public void setTicksPerUnit(int n) {
        this.ticksPerUnit = n;
    }

    public int getRotationEventsRecorded() {
        return this.rotationEventsRecorded;
    }

    public int getElapsedTimeInMillis() {
        return (int)(this.lastAddTimeInMillis - this.initialTimeInMillis);
    }

    protected synchronized void applyAcceleration() {
        int n = this.unitTickRemainder;
        int n2 = this.unitTickRemainder + this.cummulativeRotation;
        int n3 = n2 / this.ticksPerUnit;
        this.unitTickRemainder = n2 - n3 * this.ticksPerUnit;
        int n4 = 2 * this.ticksPerUnit / 3;
        if (this.unitTickRemainder < -n4) {
            --n3;
            this.unitTickRemainder += this.ticksPerUnit;
        } else if (this.unitTickRemainder > n4) {
            ++n3;
            this.unitTickRemainder -= this.ticksPerUnit;
        }
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("applyAcceleration() rot=" + this.cummulativeRotation + ", rem=" + n + " =>" + " units=" + n3 + ", new rem=" + this.unitTickRemainder);
        }
        this.acceleratedRotation = this.applyRotationAcceleration(this.cummulativeRotation, this.getElapsedTimeInMillis());
        this.acceleratedUnits = this.applyUnitAcceleration(n3, this.getElapsedTimeInMillis());
        this.cummulativeRotation = 0;
        this.initialTimeInMillis = this.lastAddTimeInMillis;
        this.rotationEventsRecorded = 0;
    }

    protected int applyRotationAcceleration(int n, int n2) {
        int n3;
        if (n2 < this.minElapsedTime) {
            n2 = this.minElapsedTime;
        }
        if ((n3 = (int)(this.lastAddTimeInMillis - this.createTime)) < this.minElapsedTime) {
            n3 = this.minElapsedTime;
        }
        WheelAccelerator wheelAccelerator = ScrollWheelManager.getAccelerator();
        int n4 = 1000;
        int n5 = (wheelAccelerator.getCurrentWeight() * wheelAccelerator.getRotationAccelerationFactor(n4 * Math.abs(n) / n2) + wheelAccelerator.getHistoryWeight() * wheelAccelerator.getRotationAccelerationFactor(n4 * this.historicalRotations / n3)) / (wheelAccelerator.getCurrentWeight() + wheelAccelerator.getHistoryWeight());
        int n6 = n5 * n / n4;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("Acceleration:rotation=" + n + ", elapsed=" + n2 + "=> factor=" + Float.toString((float)n5 / (float)n4) + "=> accl value=" + n6);
        }
        return n6;
    }

    protected int applyUnitAcceleration(int n, int n2) {
        int n3;
        if (n2 < this.minElapsedTime) {
            n2 = this.minElapsedTime;
        }
        if ((n3 = (int)(this.lastAddTimeInMillis - this.createTime)) < this.minElapsedTime) {
            n3 = this.minElapsedTime;
        }
        WheelAccelerator wheelAccelerator = ScrollWheelManager.getAccelerator();
        int n4 = 1000;
        int n5 = (wheelAccelerator.getCurrentWeight() * wheelAccelerator.getUnitAccelerationFactor(n4 * Math.abs(n) / n2) + wheelAccelerator.getHistoryWeight() * wheelAccelerator.getUnitAccelerationFactor(n4 * this.historicalRotations / this.ticksPerUnit / n3)) / (wheelAccelerator.getCurrentWeight() + wheelAccelerator.getHistoryWeight());
        int n6 = n5 * n / n4;
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("Acceleration:units=" + n + ", elapsed=" + n2 + "=> factor=" + Float.toString((float)n5 / (float)n4) + "=> accl value=" + n6);
        }
        return n6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

