/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.widgets.EList;
import elgato.infrastructure.widgets.EListCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;

public class DefaultEListCellRenderer
implements EListCellRenderer {
    private static final Font font = new Font("SansSerif", 0, 12);
    private int[] columnWidths;

    public DefaultEListCellRenderer() {
        this(new int[]{100});
    }

    public DefaultEListCellRenderer(int[] nArray) {
        this.columnWidths = nArray;
    }

    public void render(EList eList, Object object, int n, boolean bl, Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color;
        Color color2;
        if (bl) {
            color2 = Color.yellow;
            color = Color.blue;
        } else {
            color2 = Color.black;
            color = Color.white;
        }
        graphics.setColor(color2);
        graphics.fillRect(n2, n3, n4, n5);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(color);
        String[] stringArray = this.columnValues(object);
        if (stringArray.length != this.columnWidths.length) {
            throw new IllegalStateException("columnValues length must equal number of columns");
        }
        int n6 = n2;
        int n7 = n3 + fontMetrics.getAscent();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            graphics.drawString(UIHelper.stripNewlines(string), n6, n7);
            n6 += this.columnWidths[i] * n4 / 100;
        }
    }

    protected String[] columnValues(Object object) {
        return new String[]{this.stringValue(object)};
    }

    protected String stringValue(Object object) {
        return object.toString();
    }

    public Dimension getPreferredSize(EList eList, Object object, int n) {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        return new Dimension(fontMetrics.stringWidth(this.stringValue(object)), fontMetrics.getHeight());
    }
}

