/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.widgets.AbstractEListModel;

public class DefaultEListModel
extends AbstractEListModel {
    private Object[] items;

    public DefaultEListModel(Object[] objectArray) {
        this.items = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, this.items, 0, objectArray.length);
    }

    public int size() {
        return this.items.length;
    }

    public Object getItem(int n) {
        return this.items[n];
    }

    public void insertItem(int n, Object object) {
        if (n < 0 || n > this.items.length) {
            throw new IndexOutOfBoundsException("index " + n + " invalid, size=" + this.size());
        }
        Object[] objectArray = new Object[this.items.length + 1];
        System.arraycopy(this.items, 0, objectArray, 0, n);
        System.arraycopy(this.items, n, objectArray, n + 1, this.items.length - n);
        objectArray[n] = object;
        this.items = objectArray;
        this.fireListDataChanged();
    }

    public void deleteItem(int n) {
        if (n < 0 || n >= this.items.length) {
            throw new IndexOutOfBoundsException("index " + n + " invalid, size=" + this.size());
        }
        Object[] objectArray = new Object[this.items.length - 1];
        int n2 = n;
        System.arraycopy(this.items, 0, objectArray, 0, n2);
        System.arraycopy(this.items, n + 1, objectArray, n, objectArray.length - n2);
        this.items = objectArray;
        this.fireListDataChanged();
    }
}

