/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.widgets.ELabel;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public abstract class DynamicLabel
extends ELabel {
    public DynamicLabel(String string, int n, Color color, Font font) {
        this(n, color, font);
        this.setName(string);
    }

    public DynamicLabel(int n, Color color, Font font) {
        super(1);
        this.setHAlignment(n);
        this.setChunkAttributes(0, color, font);
        this.setTextNoRepaint("");
    }

    public void setMeasurement(Measurement measurement) {
        this.setTextNoRepaint(this.formatValue(measurement));
    }

    protected abstract String formatValue(Measurement var1);

    public static void updateLabelsForMeasurement(Vector vector, Measurement measurement) {
        for (int i = 0; i < vector.size(); ++i) {
            DynamicLabel dynamicLabel = (DynamicLabel)vector.elementAt(i);
            dynamicLabel.setMeasurement(measurement);
        }
    }

    public static DynamicLabel getNamedLabel(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            DynamicLabel dynamicLabel = (DynamicLabel)vector.elementAt(i);
            if (!string.equals(dynamicLabel.getName())) continue;
            return dynamicLabel;
        }
        return null;
    }

    public void setAttributes(Color color, Font font) {
        this.setChunkAttributes(0, color, font);
    }
}

