/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;

public class ELabel
extends JComponent {
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int CENTER = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private Dimension preferredSize;
    private int hAlignment = 3;
    private int vAlignment = 0;
    private int nChunks;
    private String[] textChunks;
    private Color[] colors;
    private Font[] fonts;
    private FontMetrics[] fontMetrics;
    private transient int[] textWidths;
    private transient int totalWidth = -1;
    private transient int maxAscent = -1;
    private transient int maxHeight = -1;
    private boolean validated = false;

    public ELabel(int n) {
        this.textChunks = new String[n];
        this.textWidths = new int[n];
        this.colors = new Color[n];
        this.fonts = new Font[n];
        this.fontMetrics = new FontMetrics[n];
        this.nChunks = 0;
    }

    public ELabel(String string, Color color, Font font) {
        this(1);
        this.setChunk(0, string);
        this.setChunkAttributes(0, color, font);
    }

    public ELabel(String string, Color color, Font font, int n, int n2) {
        this(string, color, font);
        this.setHAlignment(n);
        this.setVAlignment(n2);
    }

    public int getHAlignment() {
        return this.hAlignment;
    }

    public void setHAlignment(int n) {
        this.hAlignment = n;
        this.validated = false;
    }

    public int getVAlignment() {
        return this.vAlignment;
    }

    public void setVAlignment(int n) {
        this.vAlignment = n;
        this.validated = false;
    }

    public void setChunk(int n, String string) {
        if (this.textChunks[n] != null && this.textChunks[n].compareTo(string) == 0) {
            return;
        }
        this.setTextNoRepaint(n, string);
        if (this.preferredSize == null) {
            this.invalidate();
        }
        this.validated = false;
        this.repaint();
    }

    public void setTextNoRepaint(String string) {
        this.setTextNoRepaint(0, string);
    }

    public void setTextNoRepaint(int n, String string) {
        this.textChunks[n] = string;
        this.totalWidth = -1;
        this.textWidths[n] = -1;
        if (n >= this.nChunks) {
            this.nChunks = n + 1;
        }
        this.validated = false;
    }

    public void setChunkAttributes(int n, Color color, Font font) {
        this.setAttributesNoRepaint(n, color, font);
        if (this.preferredSize == null) {
            this.invalidate();
        }
        this.repaint();
    }

    public void setAttributesNoRepaint(int n, Color color, Font font) {
        this.colors[n] = color;
        this.fonts[n] = font;
        this.fontMetrics[n] = ((Component)this).getFontMetrics(font);
        this.maxHeight = -1;
        this.maxAscent = -1;
        this.totalWidth = -1;
        this.textWidths[n] = -1;
        this.validated = false;
    }

    public void setChunkColor(int n, Color color) {
        this.colors[n] = color;
        this.validated = false;
    }

    public Color getChunkColor(int n) {
        return this.colors[n];
    }

    public String getChunk(int n) {
        if (n >= this.nChunks) {
            throw new IndexOutOfBoundsException("Chunk " + n + " >= " + this.nChunks);
        }
        return this.textChunks[n];
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = new Dimension(dimension);
        this.validated = false;
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize != null) {
            return new Dimension(this.preferredSize);
        }
        this.validateMetrics();
        return new Dimension(this.totalWidth, this.maxHeight);
    }

    private void validateMetrics() {
        FontMetrics fontMetrics;
        int n;
        if (this.validated) {
            return;
        }
        if (this.maxHeight < 0 || this.maxAscent < 0) {
            this.maxAscent = 0;
            this.maxHeight = 0;
            for (n = 0; n < this.nChunks; ++n) {
                int n2;
                fontMetrics = this.fontMetrics[n];
                int n3 = fontMetrics.getHeight();
                if (n3 > this.maxHeight) {
                    this.maxHeight = n3;
                }
                if ((n2 = fontMetrics.getAscent()) <= this.maxAscent) continue;
                this.maxAscent = n2;
            }
        }
        this.totalWidth = 0;
        for (n = 0; n < this.nChunks; ++n) {
            fontMetrics = this.fontMetrics[n];
            if (this.textWidths[n] < 0) {
                this.textWidths[n] = fontMetrics.stringWidth(this.textChunks[n]);
            }
            this.totalWidth += this.textWidths[n];
        }
        this.validated = true;
    }

    public void paintComponent(Graphics graphics) {
        this.validateMetrics();
        int n = this.getPaintXPos();
        int n2 = this.getPaintYPos() + this.maxAscent;
        for (int i = 0; i < this.nChunks; ++i) {
            graphics.setFont(this.fonts[i]);
            graphics.setColor(this.colors[i]);
            graphics.drawString(this.textChunks[i], n, n2);
            n += this.textWidths[i];
        }
    }

    private int getPaintXPos() {
        switch (this.hAlignment) {
            case 3: {
                return 0;
            }
            case 2: {
                return (this.getWidth() - this.totalWidth) / 2;
            }
            case 4: {
                return this.getWidth() - this.totalWidth;
            }
        }
        throw new IllegalArgumentException();
    }

    private int getPaintYPos() {
        switch (this.vAlignment) {
            case 0: {
                return 0;
            }
            case 2: {
                return (this.getHeight() - this.maxHeight) / 2;
            }
            case 1: {
                return this.getHeight() - this.maxHeight;
            }
        }
        throw new IllegalArgumentException();
    }

    public String getText() {
        return this.getChunk(0);
    }
}

