/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.widgets.DefaultEListCellRenderer;
import elgato.infrastructure.widgets.EListCellRenderer;
import elgato.infrastructure.widgets.EListDataEvent;
import elgato.infrastructure.widgets.EListDataListener;
import elgato.infrastructure.widgets.EListModel;
import elgato.infrastructure.widgets.EScrollbar;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;

public class EList
extends JComponent
implements EListDataListener {
    public static final int NOTHING_SELECTED = -1;
    private EListModel model;
    private int selectedIndex = -1;
    private EListCellRenderer renderer = new DefaultEListCellRenderer();
    private EScrollbar scrollbar;
    private boolean sizesCalculated = false;
    private int totalHeight;
    private int fixedCellHeight;
    private int maxWidth;

    public EList(EListModel eListModel) {
        this.model = eListModel;
        this.scrollbar = new EScrollbar(this);
        this.updateScrollbarMax();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                EList.this.sizesCalculated = false;
            }
        });
        eListModel.addListDataListener(this);
    }

    private void updateScrollbarMax() {
        this.scrollbar.setMax(this.model.size() - 1);
    }

    public void setCellRenderer(EListCellRenderer eListCellRenderer) {
        this.renderer = eListCellRenderer;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        this.calculateSizes();
        int n2 = this.scrollbar.getVisible();
        int n3 = n = this.selectedIndex - n2 / 2;
        int n4 = n3 + n2;
        int n5 = this.getSize().width;
        int n6 = 0;
        for (int i = n3; i <= n4; ++i) {
            if (i >= 0 & i < this.model.size()) {
                Object object = this.model.getItem(i);
                this.renderer.render(this, object, i, i == this.selectedIndex, graphics, 0, n6, n5, this.fixedCellHeight);
            }
            n6 += this.fixedCellHeight;
        }
        this.scrollbar.paint(graphics, new Rectangle(this.getSize()));
    }

    public Dimension getPreferredSize() {
        this.calculateSizes();
        return new Dimension(this.maxWidth, this.totalHeight);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    void calculateSizes() {
        if (!this.sizesCalculated) {
            this.fixedCellHeight = 0;
            this.totalHeight = 0;
            this.maxWidth = 0;
            for (int i = 0; i < this.model.size(); ++i) {
                Object object = this.model.getItem(i);
                Dimension dimension = this.renderer.getPreferredSize(this, object, i);
                if (dimension.width > this.maxWidth) {
                    this.maxWidth = dimension.width;
                }
                if (dimension.height > this.fixedCellHeight) {
                    this.fixedCellHeight = dimension.height;
                }
                this.totalHeight += dimension.height;
            }
            if (this.fixedCellHeight != 0) {
                this.sizesCalculated = true;
                this.scrollbar.setVisible(this.getVisibleRowCount());
            }
        }
    }

    private int getVisibleRowCount() {
        if (this.fixedCellHeight == 0) {
            return 0;
        }
        return this.getSize().height / this.fixedCellHeight;
    }

    public void select(int n) {
        int n2 = n;
        if (n == -1) {
            n2 = 0;
        } else if (n < 0 || n >= this.model.size()) {
            throw new IllegalArgumentException("index out of range: " + n);
        }
        this.selectedIndex = n;
        this.scrollbar.setPosition(n2);
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getItemCount() {
        return this.model.size();
    }

    public EListModel getModel() {
        return this.model;
    }

    public void contentsChanged(EListDataEvent eListDataEvent) {
        this.updateScrollbarMax();
        this.repaint();
    }
}

