/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Vector;

public class EProgressBar {
    String processName;
    Vector tasks = new Vector();
    int currentTaskIndex = -1;
    int x = 0;
    int y = 0;
    int width = 100;
    int height = 20;
    boolean display = true;
    int[] taskX = null;
    int textX = 0;
    int textY = 0;
    public static final int STATUS_TOP = 0;
    public static final int STATUS_LEFT = 1;
    int statusPosition = 0;

    public EProgressBar(String string, int n, int n2, int n3, int n4) {
        this.processName = string;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    public void setStatusPosition(int n) {
        this.statusPosition = n;
    }

    public void setTextX(int n) {
        this.textX = n;
    }

    public void addTask(EProgressTask eProgressTask) {
        this.taskX = null;
        if (this.currentTaskIndex < 0) {
            this.currentTaskIndex = 0;
        }
        this.tasks.addElement(eProgressTask);
    }

    public void addTask(String string, int n, int n2) {
        this.addTask(new EProgressTask(string, n, n2));
    }

    public void setTaskEstTimeOrSubtasks(String string, int n) {
        try {
            int n2 = this.tasks.size();
            for (int i = 0; i < n2; ++i) {
                EProgressTask eProgressTask = (EProgressTask)this.tasks.elementAt(i);
                if (!eProgressTask.getTaskName().equals(string)) continue;
                eProgressTask.setTaskEstTimeOrSubtasks(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void hide() {
        this.display = false;
    }

    public void show() {
        this.display = true;
    }

    public int getTaskCount() {
        return this.tasks.size();
    }

    public int getCurrentTaskIndex() {
        return this.currentTaskIndex;
    }

    public void nextTask() {
        this.completeCurrentTask();
        this.setCurrentTaskIndex(this.getCurrentTaskIndex() + 1);
    }

    public void setCurrentTaskIndex(int n) {
        if (this.tasks.size() == 0) {
            this.currentTaskIndex = 0;
            return;
        }
        if (n >= this.tasks.size()) {
            n = this.tasks.size() - 1;
        }
        if (n < 0) {
            n = 0;
        }
        this.currentTaskIndex = n;
    }

    public void paint(Graphics graphics) {
        if (!this.display) {
            return;
        }
        if (graphics == null) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(Color.white);
        graphics.fill3DRect(this.x, this.y, this.width, this.height, false);
        graphics.setColor(Color.black);
        graphics.drawRect(this.x, this.y, this.width, this.height);
        this.paintTasks(this.x, this.y, this.width, this.height, graphics);
        graphics.setColor(color);
    }

    public void bumpTaskASubtask() {
        this.bumpTaskASecond();
    }

    public void bumpTaskASecond() {
        EProgressTask eProgressTask = this.getCurrentTask();
        if (eProgressTask == null) {
            return;
        }
        eProgressTask.bumpCompletedPortionASecond();
    }

    private EProgressTask getCurrentTask() {
        try {
            return (EProgressTask)this.tasks.elementAt(this.currentTaskIndex);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void completeCurrentTask() {
        if (this.currentTaskIndex < 0) {
            return;
        }
        EProgressTask eProgressTask = (EProgressTask)this.tasks.elementAt(this.currentTaskIndex);
        eProgressTask.setTaskCompletedPortion(eProgressTask.getTaskEstTimeOrSubtasks());
    }

    private void paintTasks(int n, int n2, int n3, int n4, Graphics graphics) {
        int n5 = this.tasks.size();
        if (n5 == 0) {
            return;
        }
        if (this.currentTaskIndex >= n5) {
            graphics.setColor(Color.red);
            graphics.fill3DRect(n, n2, n3, n4, false);
            return;
        }
        EProgressTask eProgressTask = null;
        int n6 = 0;
        int n7 = 0;
        try {
            int n8;
            if (this.taskX == null) {
                this.taskX = new int[n5];
                for (n8 = 0; n8 < n5; ++n8) {
                    eProgressTask = (EProgressTask)this.tasks.elementAt(n8);
                    n7 = (int)((double)n3 * ((double)eProgressTask.getTaskPortion() * 0.01));
                    this.taskX[n8] = n6 += n7;
                }
            }
            graphics.setColor(Color.black);
            n8 = n2 + 3;
            int n9 = n2 + n4 - 4;
            for (int i = 0; i < n5; ++i) {
                graphics.drawLine(n + this.taskX[i], n8, n + this.taskX[i], n9);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n6 = 0;
        graphics.setColor(Color.green);
        for (int i = 0; i <= this.currentTaskIndex; ++i) {
            eProgressTask = (EProgressTask)this.tasks.elementAt(i);
            n7 = (int)((double)n3 * ((double)eProgressTask.getTaskPortion() * 0.01) * eProgressTask.getTaskCompletedPercent());
            n6 += n7;
        }
        if (eProgressTask != null) {
            graphics.fill3DRect(n, n2, n6, n4, true);
            graphics.setColor(Color.black);
            this.renderTaskName(eProgressTask.getTaskName(), n, n2, n4, graphics);
            graphics.drawRect(n, n2, n6, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderTaskName(String string, int n, int n2, int n3, Graphics graphics) {
        Font font = graphics.getFont();
        graphics.setFont(new Font("SansSerif", 1, 12));
        try {
            if (this.statusPosition == 0) {
                graphics.drawString(string, n, n2 - 5);
                return;
            }
            graphics.drawString(string, 5, n2 + n3);
        }
        catch (Exception exception) {
        }
        finally {
            graphics.setFont(font);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Process: " + this.processName);
        stringBuffer.append("; Current: " + this.currentTaskIndex);
        stringBuffer.append("; Task(s):");
        int n = this.tasks.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("\n\t" + this.tasks.elementAt(i));
        }
        return stringBuffer.toString();
    }

    private class EProgressTask {
        String taskName;
        int taskPortion;
        int taskEstTimeOrSubtasks;
        int taskCompletedPortion = 0;

        public EProgressTask(String string, int n, int n2) {
            this.taskName = string;
            this.taskPortion = n;
            this.taskEstTimeOrSubtasks = n2;
        }

        public void bumpCompletedPortionASubtask() {
            this.bumpCompletedPortionASecond();
        }

        public void bumpCompletedPortionASecond() {
            this.setTaskCompletedPortion(this.getTaskCompletedPortion() + 1);
        }

        public void setTaskCompletedPortion(int n) {
            if (n < 0) {
                this.taskCompletedPortion = 0;
                return;
            }
            if (n > this.taskEstTimeOrSubtasks) {
                this.taskCompletedPortion = this.taskEstTimeOrSubtasks;
                return;
            }
            this.taskCompletedPortion = n;
        }

        public void setTaskEstTimeOrSubtasks(int n) {
            this.taskEstTimeOrSubtasks = n;
        }

        public double getTaskCompletedPercent() {
            return (double)this.taskCompletedPortion / (double)this.taskEstTimeOrSubtasks;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public int getTaskPortion() {
            return this.taskPortion;
        }

        public int getTaskCompletedPortion() {
            return this.taskCompletedPortion;
        }

        public int getTaskEstTimeOrSubtasks() {
            return this.taskEstTimeOrSubtasks;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("task: " + this.taskName);
            stringBuffer.append("; portion: " + this.taskPortion);
            stringBuffer.append("; est time / subtasks: " + this.taskEstTimeOrSubtasks);
            stringBuffer.append("; compl time: " + this.taskCompletedPortion);
            stringBuffer.append("; compl %: " + this.getTaskCompletedPercent());
            return stringBuffer.toString();
        }
    }
}

