/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.util.Resources;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.net.URL;

public class EScrollbar {
    private static final Resources res = Resources.getResources((class$elgato$infrastructure$widgets$EScrollbar == null ? (class$elgato$infrastructure$widgets$EScrollbar = EScrollbar.class$("elgato.infrastructure.widgets.EScrollbar")) : class$elgato$infrastructure$widgets$EScrollbar).getName());
    private static final int barWidth = res.getInt("barWidth");
    private static final int arrowTopOverlap = res.getInt("arrowtop.overlap");
    private static final int arrowBotOverlap = res.getInt("arrowtop.overlap");
    private int position;
    protected int visible;
    private int max;
    private Image arrowTop;
    private Image arrowBot;
    protected Image thumbTop;
    protected Image thumbMid;
    protected Image thumbBot;
    private Image barBg;
    static /* synthetic */ Class class$elgato$infrastructure$widgets$EScrollbar;

    public EScrollbar() {
    }

    public EScrollbar(Component component) {
        this.loadImages(component);
    }

    public boolean isScrollingNecessary() {
        return this.visible <= this.max;
    }

    private void loadImages(Component component) {
        this.thumbTop = this.getImageByKey(component, "thumbtop");
        this.thumbMid = this.getImageByKey(component, "thumbmid");
        this.thumbBot = this.getImageByKey(component, "thumbbot");
        this.barBg = this.getImageByKey(component, "bg");
        this.arrowTop = this.getImageByKey(component, "arrowtop");
        this.arrowBot = this.getImageByKey(component, "arrowbot");
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(this.thumbTop, 0);
        mediaTracker.addImage(this.thumbMid, 0);
        mediaTracker.addImage(this.thumbBot, 0);
        mediaTracker.addImage(this.barBg, 0);
        mediaTracker.addImage(this.arrowTop, 0);
        mediaTracker.addImage(this.arrowBot, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Image getImageByKey(Component component, String string) {
        URL uRL = this.getClass().getResource("/" + res.getString(string));
        if (uRL == null) {
            throw new RuntimeException("Couldn't find image for key " + string);
        }
        return component.getToolkit().getImage(uRL);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        if (!this.isScrollingNecessary()) {
            return;
        }
        int n = rectangle.width - barWidth;
        int n2 = this.arrowTop.getHeight(null);
        int n3 = this.arrowBot.getHeight(null);
        int n4 = rectangle.height - n2 - n3;
        graphics.drawImage(this.arrowTop, n, rectangle.y, barWidth, n2, null);
        graphics.drawImage(this.arrowBot, n, rectangle.y + rectangle.height - n3, barWidth, n3, null);
        this.tileImageVertical(graphics, this.barBg, n, rectangle.y + n2, barWidth, n4);
        int n5 = this.thumbTop.getHeight(null);
        int n6 = this.thumbBot.getHeight(null);
        int n7 = this.getThumbSize(rectangle.height) - n5 - n6;
        int n8 = rectangle.y + this.getTopButtonHeight() + this.getThumbPosition(rectangle.height);
        graphics.drawImage(this.thumbTop, n, n8, barWidth, n5, null);
        n8 += n5;
        if (n7 > 0) {
            graphics.drawImage(this.thumbMid, n, n8, barWidth, n7, null);
            n8 += n7;
        }
        graphics.drawImage(this.thumbBot, n, n8, barWidth, n6, null);
    }

    private void tileImageVertical(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setClip(n, n2, n3, n4);
        int n5 = image.getHeight(null);
        int n6 = n2 + n4;
        while (n2 < n6) {
            graphics.drawImage(image, n, n2, n3, n5, null);
            n2 += n5;
        }
        graphics.setClip(rectangle);
    }

    int getThumbSize(int n) {
        int n2 = this.thumbTop.getHeight(null) + this.thumbBot.getHeight(null);
        int n3 = this.getScrollableHeight(n);
        int n4 = this.visible * n3 / this.boundedMax();
        return Math.min(Math.max(n2, n4), n3);
    }

    int getThumbPosition(int n) {
        return this.boundedPosition() * (this.getScrollableHeight(n) - this.getThumbSize(n)) / this.boundedMax();
    }

    private int boundedMax() {
        return this.max > 0 ? this.max : 1;
    }

    private int boundedPosition() {
        int n = this.position;
        if (n < 0) {
            n = 0;
        } else if (n >= this.max) {
            n = this.max;
        }
        return n;
    }

    protected int getScrollableHeight(int n) {
        return n - this.getTopButtonHeight() - this.getBottomButtonHeight();
    }

    int getTopButtonHeight() {
        return this.arrowTop.getHeight(null) - arrowTopOverlap;
    }

    int getBottomButtonHeight() {
        return this.arrowBot.getHeight(null) - arrowBotOverlap;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getVisible() {
        return this.visible;
    }

    public void setVisible(int n) {
        this.visible = n;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int n) {
        this.max = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

