/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Hashtable;

public class HydroBorderPainter {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$widgets$HydroBorderPainter == null ? (class$elgato$infrastructure$widgets$HydroBorderPainter = HydroBorderPainter.class$("elgato.infrastructure.widgets.HydroBorderPainter")) : class$elgato$infrastructure$widgets$HydroBorderPainter);
    private static final boolean disableBorders = "true".equals(System.getProperty("disableBorders"));
    private static final int MAX_CACHE_SIZE = 200000;
    private static int[] pix;
    private static Hashtable cache;
    private static int cachedImages;
    private static int cacheSize;
    static /* synthetic */ Class class$elgato$infrastructure$widgets$HydroBorderPainter;

    public static void paintBorder(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, HydroBorderPainterConfig hydroBorderPainterConfig) {
        if ((n3 | n4) < 0) {
            throw new IllegalArgumentException("Invalid dimension: " + n3 + "," + n4);
        }
        if (disableBorders) {
            return;
        }
        RenderedBorder renderedBorder = HydroBorderPainter.getBorder(hydroBorderPainterConfig, n3, n4, bl);
        renderedBorder.paint(graphics, n, n2);
    }

    private static RenderedBorder getBorder(HydroBorderPainterConfig hydroBorderPainterConfig, int n, int n2, boolean bl) {
        RenderedBorder renderedBorder;
        Hashtable hashtable = (Hashtable)cache.get(hydroBorderPainterConfig);
        int n3 = bl ? Integer.MIN_VALUE : 0;
        Integer n4 = new Integer((n << 16) + n2 | n3);
        if (hashtable == null) {
            hashtable = new Hashtable(4);
            cache.put(hydroBorderPainterConfig, hashtable);
        }
        if ((renderedBorder = (RenderedBorder)hashtable.get(n4)) == null) {
            renderedBorder = HydroBorderPainter.renderBorder(n, n2, bl, hydroBorderPainterConfig);
            HydroBorderPainter.storeInCache(hashtable, n4, renderedBorder);
        }
        return renderedBorder;
    }

    private static void storeInCache(Hashtable hashtable, Object object, RenderedBorder renderedBorder) {
        HydroBorderPainter.cleanupCache();
        hashtable.put(object, renderedBorder);
        ++cachedImages;
        cacheSize += renderedBorder.estimatedSizeBytes();
        if (logger.isDebugEnabled()) {
            logger.debug("created new image, cachedImages=" + cachedImages + " cacheSize=" + cacheSize);
        }
    }

    private static void cleanupCache() {
        if (cacheSize < HydroBorderPainter.getMaxCacheSizeBytes()) {
            return;
        }
        long l = Long.MAX_VALUE;
        HydroBorderPainterConfig hydroBorderPainterConfig = null;
        Hashtable hashtable = null;
        Object var4_3 = null;
        Object object = cache.keys();
        while (object.hasMoreElements()) {
            HydroBorderPainterConfig hydroBorderPainterConfig2 = (HydroBorderPainterConfig)object.nextElement();
            Hashtable hashtable2 = (Hashtable)cache.get(hydroBorderPainterConfig2);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                RenderedBorder renderedBorder = (RenderedBorder)hashtable2.get(k);
                if (renderedBorder.getLastUsedTime() >= l) continue;
                l = renderedBorder.getLastUsedTime();
                hydroBorderPainterConfig = hydroBorderPainterConfig2;
                hashtable = hashtable2;
                var4_3 = k;
            }
        }
        if (var4_3 != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("cleanupCache() removing oldest border from cache");
            }
            object = (RenderedBorder)hashtable.remove(var4_3);
            ((RenderedBorder)object).flushImages();
            --cachedImages;
            cacheSize -= ((RenderedBorder)object).estimatedSizeBytes();
            if (hashtable.size() == 0) {
                cache.remove(hydroBorderPainterConfig);
            }
        }
    }

    public static void flushCache() {
        cache.clear();
        cachedImages = 0;
        cacheSize = 0;
    }

    public static int getNumberOfImagesInCache() {
        return cachedImages;
    }

    public static int getCacheSizeBytes() {
        return cacheSize;
    }

    public static int getMaxCacheSizeBytes() {
        return 200000;
    }

    private static RenderedBorder renderBorder(int n, int n2, boolean bl, HydroBorderPainterConfig hydroBorderPainterConfig) {
        int n3;
        if (pix == null || pix.length < n * n2) {
            pix = new int[n * n2];
        }
        for (n3 = 0; n3 < pix.length; ++n3) {
            HydroBorderPainter.pix[n3] = hydroBorderPainterConfig.backgroundColor;
        }
        n3 = hydroBorderPainterConfig.borderWidth;
        int n4 = bl ? 1 : 0;
        HydroBorderPainter.shadeH(n2 - n3, n3, hydroBorderPainterConfig.colors[1 ^ n4], 0, 65000, pix, n);
        HydroBorderPainter.shadeV(n - n3, n3, hydroBorderPainterConfig.colors[3 ^ n4], 0, 45000, pix, n, n2);
        HydroBorderPainter.shadeH(0, n3, hydroBorderPainterConfig.colors[0 ^ n4], 65000, 0, pix, n);
        HydroBorderPainter.shadeV(0, n3, hydroBorderPainterConfig.colors[2 ^ n4], 45000, 0, pix, n, n2);
        int n5 = n3 * 2;
        return new RenderedBorder(n, n2, hydroBorderPainterConfig.getBackgroundColor(), n3, HydroBorderPainter.createSubImage(0, 0, n, n3, pix, n), HydroBorderPainter.createSubImage(0, n2 - n3, n, n3, pix, n), HydroBorderPainter.createSubImage(0, n3, n3, n2 - n5, pix, n), HydroBorderPainter.createSubImage(n - n3, n3, n3, n2 - n5, pix, n));
    }

    private static Image createSubImage(int n, int n2, int n3, int n4, int[] nArray, int n5) {
        MemoryImageSource memoryImageSource = new MemoryImageSource(n3, n4, nArray, n2 * n5 + n, n5);
        Image image = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
        return image;
    }

    private static void shadeH(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        int n7 = n * n6;
        int n8 = n2 - 1;
        if (n8 < 1) {
            n8 = 1;
        }
        int n9 = n5 - n4;
        for (int i = 0; i < n2; ++i) {
            int n10 = n4 + n9 * i / n8;
            for (int j = 0; j < n6; ++j) {
                nArray[n7] = HydroBorderPainter.blend(nArray[n7], n3, n10);
                ++n7;
            }
        }
    }

    private static void shadeV(int n, int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        int n8 = n5 - n4;
        int n9 = n2 - 1;
        if (n9 < 1) {
            n9 = 1;
        }
        for (int i = 0; i < n2; ++i) {
            int n10 = n4 + n8 * i / n9;
            int n11 = n + i;
            for (int j = 0; j < n7; ++j) {
                nArray[n11] = HydroBorderPainter.blend(nArray[n11], n3, n10);
                n11 += n6;
            }
        }
    }

    private static int blend(int n, int n2, int n3) {
        return (n & 0xFF) + (((n2 & 0xFF) - (n & 0xFF)) * n3 >> 16) | (n >> 8 & 0xFF) + (((n2 >> 8 & 0xFF) - (n >> 8 & 0xFF)) * n3 >> 16) << 8 | (n >> 16 & 0xFF) + (((n2 >> 16 & 0xFF) - (n >> 16 & 0xFF)) * n3 >> 16) << 16 | 0xFF000000;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        cache = new Hashtable();
        cachedImages = 0;
        cacheSize = 0;
    }

    private static class RenderedBorder {
        private final int width;
        private final int height;
        private final Color background;
        private final int borderWidth;
        private final Image top;
        private final Image bottom;
        private final Image left;
        private final Image right;
        private long lastUsedTime;

        public RenderedBorder(int n, int n2, Color color, int n3, Image image, Image image2, Image image3, Image image4) {
            this.width = n;
            this.height = n2;
            this.background = color;
            this.borderWidth = n3;
            this.top = image;
            this.bottom = image2;
            this.left = image3;
            this.right = image4;
            this.updateTime();
        }

        private void updateTime() {
            this.lastUsedTime = System.currentTimeMillis();
        }

        void paint(Graphics graphics, int n, int n2) {
            int n3 = this.borderWidth * 2;
            graphics.setColor(this.background);
            graphics.fillRect(n + this.borderWidth, n2 + this.borderWidth, this.width - n3, this.height - n3);
            graphics.drawImage(this.top, n, n2, null);
            graphics.drawImage(this.left, n, n2 + this.borderWidth, null);
            graphics.drawImage(this.bottom, n, n2 + this.height - this.borderWidth, null);
            graphics.drawImage(this.right, n + this.width - this.borderWidth, n2 + this.borderWidth, null);
            this.updateTime();
        }

        public void flushImages() {
            this.left.flush();
            this.right.flush();
            this.top.flush();
            this.bottom.flush();
        }

        public int estimatedSizeBytes() {
            int n = this.borderWidth * 2;
            int n2 = this.width * this.height - (this.width - n) * (this.height - n);
            return n2 * 4;
        }

        public long getLastUsedTime() {
            return this.lastUsedTime;
        }
    }
}

