/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import java.awt.Color;

public class HydroBorderPainterConfig {
    public final int backgroundColor;
    public final int borderWidth;
    public final int[] colors;

    public HydroBorderPainterConfig(Color color, int n, Color[] colorArray) {
        this.backgroundColor = color.getRGB();
        this.borderWidth = n;
        if (colorArray.length != 4) {
            throw new IllegalArgumentException();
        }
        this.colors = new int[4];
        for (int i = 0; i < colorArray.length; ++i) {
            this.colors[i] = colorArray[i].getRGB();
        }
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        HydroBorderPainterConfig hydroBorderPainterConfig = (HydroBorderPainterConfig)object;
        return hydroBorderPainterConfig.backgroundColor == this.backgroundColor && hydroBorderPainterConfig.borderWidth == this.borderWidth && HydroBorderPainterConfig.arraysEqual(hydroBorderPainterConfig.colors, this.colors);
    }

    public int hashCode() {
        return this.backgroundColor + this.borderWidth + this.colors[0] + this.colors[1] + this.colors[2] + this.colors[3];
    }

    private static boolean arraysEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Color getBackgroundColor() {
        return new Color(this.backgroundColor);
    }

    public Color[] getBorderColors() {
        Color[] colorArray = new Color[this.colors.length];
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = new Color(this.colors[i]);
        }
        return colorArray;
    }
}

