/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import com.sun.jimi.core.Jimi;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.JComponent;

public class ImageIcon
extends JComponent {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$widgets$ImageIcon == null ? (class$elgato$infrastructure$widgets$ImageIcon = ImageIcon.class$("elgato.infrastructure.widgets.ImageIcon")) : class$elgato$infrastructure$widgets$ImageIcon);
    private final Image image;
    private boolean scaleToFit;
    private boolean center;
    private int xOffset;
    private int yOffset;
    static /* synthetic */ Class class$elgato$infrastructure$widgets$ImageIcon;

    public ImageIcon(String string, boolean bl) {
        this.image = bl ? ImageIcon.loadImageAbsPath(string, this) : ImageIcon.loadImage(string, this);
    }

    public ImageIcon(Image image) {
        this.image = image;
    }

    public static Image loadImage(String string, Component component) {
        URL uRL;
        if (logger.isDebugEnabled()) {
            logger.debug("loading image " + string);
        }
        if ((uRL = component.getClass().getResource("/" + string)) == null) {
            throw new MissingResourceException("Could not load image", string, null);
        }
        Image image = component.getToolkit().getImage(uRL);
        ImageIcon.waitForImage(image, component);
        return image;
    }

    public static Image loadImageAbsPath(String string, Component component) {
        return ImageIcon.loadImageAbsPath(string, component, false);
    }

    public static Image loadImageAbsPath(String string, Component component, boolean bl) {
        if (logger.isDebugEnabled()) {
            logger.debug("abs path loading image " + string);
        }
        Image image = bl ? Jimi.getImage((String)string) : component.getToolkit().getImage(string);
        ImageIcon.waitForImage(image, component);
        return image;
    }

    public static void waitForImage(Image image, Component component) {
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            if (!mediaTracker.waitForID(0, 10000L)) {
                logger.error("Timed out waiting for image to load");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Interrupted while loading image");
        }
        mediaTracker.removeImage(image);
        if (logger.isDebugEnabled()) {
            logger.debug("image loaded.");
        }
    }

    public Dimension getPreferredSize() {
        return this.getImageSize();
    }

    public Dimension getImageSize() {
        return new Dimension(this.image.getWidth(this), this.image.getHeight(this));
    }

    public void paintComponent(Graphics graphics) {
        if (this.scaleToFit) {
            graphics.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), null);
        } else {
            int n;
            int n2;
            if (this.center) {
                Dimension dimension = this.getImageSize();
                n2 = (this.getWidth() - dimension.width) / 2;
                n = (this.getHeight() - dimension.height) / 2;
            } else {
                n = 0;
                n2 = 0;
            }
            graphics.drawImage(this.image, n2 + this.xOffset, n + this.yOffset, null);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isScaleToFit() {
        return this.scaleToFit;
    }

    public void setScaleToFit(boolean bl) {
        this.scaleToFit = bl;
    }

    public boolean isCenter() {
        return this.center;
    }

    public void setCenter(boolean bl) {
        this.center = bl;
    }

    public int getxOffset() {
        return this.xOffset;
    }

    public void setxOffset(int n) {
        this.xOffset = n;
    }

    public int getyOffset() {
        return this.yOffset;
    }

    public void setyOffset(int n) {
        this.yOffset = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

