/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.actuators.EntryField;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.wheel.ScrollWheelEvent;
import elgato.infrastructure.wheel.ScrollWheelListener;
import elgato.infrastructure.wheel.ScrollWheelManager;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ValueField
extends EntryField
implements ScrollWheelListener,
ValueListener {
    private static Logger logger = LogManager.getLogger(class$elgato$infrastructure$widgets$ValueField == null ? (class$elgato$infrastructure$widgets$ValueField = ValueField.class$("elgato.infrastructure.widgets.ValueField")) : class$elgato$infrastructure$widgets$ValueField);
    private ELabel field;
    private ELabel label;
    private boolean adjustMode;
    private final ValueInterface value;
    private TextListener textListener;
    private final String listenerName;
    static /* synthetic */ Class class$elgato$infrastructure$widgets$ValueField;

    public ValueField(ValueInterface valueInterface, String string) {
        this.value = valueInterface;
        this.listenerName = string + ".valueField";
        this.label = this.createLabel();
        this.field = this.createField();
        this.setLayout(new GridLayout(1, 2, 5, 5));
        this.add(this.label);
        this.add(this.addBorderToField(this.field));
        this.setAdjustMode(true);
    }

    public void dispose() {
        this.value.removeValueListener(this);
        super.dispose();
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public void valueChanged(ValueInterface valueInterface) {
        if (!this.inEditMode()) {
            this.setTextFromActuator();
            this.paintLabel();
        }
    }

    private void paintLabel() {
        this.label.setTextNoRepaint(this.getTitle());
        this.label.paintImmediately(new Rectangle(this.label.getSize()));
    }

    protected ValueInterface getValueObject() {
        return this.value;
    }

    private JComponent addBorderToField(Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(null);
        jPanel.add((Component)new BorderWrapper(component, EntryField.BORDER_CONFIG, true), "West");
        return jPanel;
    }

    private ELabel createField() {
        ELabel eLabel = new ELabel(((Object)this.value).toString(), EntryField.VALUE_COLOR, EntryField.VALUE_FONT);
        eLabel.setBackground(EntryField.BORDER_CONFIG.getBackgroundColor());
        eLabel.setPreferredSize(EntryField.VALUE_FIELD_SIZE);
        eLabel.setVAlignment(2);
        int n = EntryField.BORDER_CONFIG.getBorderWidth();
        eLabel.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
        return eLabel;
    }

    private ELabel createLabel() {
        ELabel eLabel = new ELabel(this.getTitle(), EntryField.TITLE_COLOR, EntryField.TITLE_FONT);
        eLabel.setHAlignment(4);
        eLabel.setVAlignment(2);
        return eLabel;
    }

    private String getTitle() {
        return UIHelper.stripNewlines(this.value.getLongLabel());
    }

    public String getText() {
        return this.field.getText();
    }

    public int intValue() {
        int n = this.getText().indexOf(32);
        if (n != -1) {
            return Integer.parseInt(this.getText().substring(0, n));
        }
        return Integer.parseInt(this.getText());
    }

    void setText(String string) {
        this.paint(string);
        this.fireTextChanged();
    }

    private void paint(String string) {
        this.field.setTextNoRepaint(string);
        this.field.paintImmediately(new Rectangle(this.field.getSize()));
    }

    private void fireTextChanged() {
        if (this.textListener == null) {
            return;
        }
        this.textListener.textValueChanged(new TextEvent(this, 0));
    }

    public void setTextListener(TextListener textListener) {
        this.textListener = textListener;
    }

    public void appendChar(char c) {
        if (c != '.' || this.getText().indexOf(46) == -1) {
            this.setText(this.getText() + c);
        }
    }

    public void deleteLastChar() {
        String string = this.getText();
        if (string.length() > 0) {
            String string2 = string.substring(0, string.length() - 1);
            this.setText(string2);
        } else if (this.isValidEntryKey('-')) {
            this.setText("-");
        }
    }

    public boolean isValidEntryKey(char c) {
        return this.value.getPalette().containsCharacter(c);
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        if (this.isValidEntryKey(c)) {
            if (this.inAdjustMode()) {
                this.installMenu();
            }
            if (c == '-') {
                this.handleBackspaceKeyPress();
            } else {
                this.appendChar(c);
            }
            keyEvent.consume();
        } else if (n == 8) {
            this.handleBackspaceKeyPress();
            keyEvent.consume();
        } else if (n == 38) {
            this.adjust(1);
            keyEvent.consume();
        } else if (n == 40) {
            this.adjust(-1);
            keyEvent.consume();
        }
    }

    private void handleBackspaceKeyPress() {
        if (this.inAdjustMode()) {
            this.installMenu();
        }
        this.deleteLastChar();
    }

    public void scrollWheelMoved(ScrollWheelEvent scrollWheelEvent) {
        if (logger.isKeyPressEnabled()) {
            logger.keyPress("scrollWheelMoved() for value " + this.value.getLabel());
        }
        this.adjust(scrollWheelEvent.getUnitsMoved());
    }

    public void scrollWheelMoveComplete() {
        if (this.inAdjustMode()) {
            this.getValueObject().send();
        }
    }

    private void adjust(int n) {
        if (this.inAdjustMode()) {
            if (n < 0) {
                this.value.decrement(-n);
            } else if (n > 0) {
                this.value.increment(n);
            }
            if (!ScrollWheelManager.isWheelMoveInProcess()) {
                this.getValueObject().send();
            }
        }
    }

    private void setAdjustMode(boolean bl) {
        this.adjustMode = bl;
    }

    private boolean inAdjustMode() {
        return this.adjustMode;
    }

    private boolean inEditMode() {
        return !this.inAdjustMode();
    }

    protected void setTextFromActuator() {
        this.paint(((Object)this.value).toString());
    }

    protected ScreenManager getScreenManager() {
        return MeasurementFactory.instance().getScreenManager();
    }

    public void hideField() {
        this.value.removeValueListener(this);
        this.setAdjustMode(true);
        this.setTextFromActuator();
        this.getScreenManager().uninstallField();
    }

    public void showField() {
        this.value.addValueListener(this);
        this.getScreenManager().installField(this);
    }

    protected MenuItem createCancelButton(final MenuPanel menuPanel) {
        final Menu menu = menuPanel.getMenu();
        final MenuItem menuItem = menuPanel.getSelectedItem();
        PushButton pushButton = new PushButton(Text.Cancel, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ValueField.this.uninstallMenu(menu, menuItem, menuPanel);
            }
        });
        return pushButton;
    }

    private String getButtonText(Conversion conversion) {
        if (conversion.getLabel().equals("") || conversion.getLabel().equals(" ")) {
            return Text.Enter;
        }
        return conversion.getLabel();
    }

    protected MenuItem createUnitsButton(final MenuPanel menuPanel, final Conversion conversion) {
        final Menu menu = menuPanel.getMenu();
        final MenuItem menuItem = menuPanel.getSelectedItem();
        PushButton pushButton = new PushButton(this.getButtonText(conversion), "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((LongActuator)ValueField.this.getValueObject()).send(conversion, ValueField.this.getParsedText());
                ValueField.this.uninstallMenu(menu, menuItem, menuPanel);
            }
        });
        return pushButton;
    }

    protected void uninstallMenu(Menu menu, MenuItem menuItem, MenuPanel menuPanel) {
        menuPanel.installMenu(menu);
        menuPanel.focusButton(menuItem);
        this.refreshValue();
    }

    private void installMenu() {
        Menu menu = this.createMenu(this.getScreenManager().getRightMenuPanel());
        this.getScreenManager().installRightMenu(menu);
        this.setText("");
        this.showField();
        this.setAdjustMode(false);
    }

    public Menu createMenu(MenuPanel menuPanel) {
        MenuItem[] menuItemArray = new MenuItem[7];
        Conversion[] conversionArray = this.getValueObject().getConversions();
        for (int i = 0; i < conversionArray.length; ++i) {
            menuItemArray[i] = this.createUnitsButton(menuPanel, conversionArray[i]);
        }
        menuItemArray[6] = this.createCancelButton(menuPanel);
        return new Menu("", menuItemArray);
    }

    String getParsedText() {
        if (this.getText().indexOf(" ") == -1) {
            return this.getText();
        }
        return new StringTokenizer(this.getText(), " ").nextToken();
    }

    public ValueInterface getValue() {
        return this.value;
    }

    public void refreshValue() {
        this.setTextFromActuator();
        this.setAdjustMode(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

