/*
 * Decompiled with CFR 0.152.
 */
package elgato.infrastructure.widgets;

import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.Timer;

public class WrappedTimer {
    private static final Logger logger = LogManager.getLogger(class$elgato$infrastructure$widgets$WrappedTimer == null ? (class$elgato$infrastructure$widgets$WrappedTimer = WrappedTimer.class$("elgato.infrastructure.widgets.WrappedTimer")) : class$elgato$infrastructure$widgets$WrappedTimer);
    private static boolean fullDebug = "true".equals(System.getProperty("WrappedTimer.fullDebug"));
    private static final Vector activeTimers = new Vector();
    private static boolean saveCreationTrace = false;
    private final Timer timer;
    private final Exception creationTrace = saveCreationTrace ? new Exception() : null;
    private final ActionListener listener;
    static /* synthetic */ Class class$elgato$infrastructure$widgets$WrappedTimer;

    public WrappedTimer(int n, ActionListener actionListener) {
        this.listener = actionListener;
        this.timer = new Timer(n, actionListener);
        WrappedTimer.addTimer(this);
    }

    private static void addTimer(WrappedTimer wrappedTimer) {
        activeTimers.addElement(wrappedTimer);
        if (logger.isDebugEnabled() && (fullDebug || activeTimers.size() > 3)) {
            logger.debug("Added timer " + wrappedTimer.toString() + "\n      Number of active timers is " + activeTimers.size());
        }
    }

    private static void removeTimer(WrappedTimer wrappedTimer) {
        activeTimers.removeElement(wrappedTimer);
        if (logger.isDebugEnabled() && (fullDebug || activeTimers.size() > 3)) {
            logger.debug("Removed timer " + wrappedTimer.toString() + "\n      Number of active timers is " + activeTimers.size());
        }
    }

    public static void dumpActiveTimers(PrintWriter printWriter) {
        for (int i = 0; i < activeTimers.size(); ++i) {
            WrappedTimer wrappedTimer = (WrappedTimer)activeTimers.elementAt(i);
            printWriter.print(wrappedTimer);
        }
    }

    public static Vector getActiveTimers() {
        return activeTimers;
    }

    public void start() {
        if (WrappedTimer.useRealTimers()) {
            this.getTimer().start();
        } else {
            this.listener.actionPerformed(new ActionEvent(this.timer, 0, null));
        }
    }

    public void stop() {
        if (WrappedTimer.useRealTimers()) {
            this.getTimer().stop();
        }
        WrappedTimer.removeTimer(this);
    }

    public void setRepeats(boolean bl) {
        this.getTimer().setRepeats(bl);
        if (!bl) {
            WrappedTimer.removeTimer(this);
        }
    }

    public void setInitialDelay(int n) {
        this.getTimer().setInitialDelay(n);
    }

    public void restart() {
        if (WrappedTimer.useRealTimers()) {
            this.getTimer().restart();
        }
    }

    public void setDelay(int n) {
        this.getTimer().setDelay(n);
    }

    private Timer getTimer() {
        return this.timer;
    }

    public String toString() {
        if (this.creationTrace != null) {
            StringWriter stringWriter = new StringWriter();
            this.creationTrace.printStackTrace(new PrintWriter(stringWriter));
            String string = stringWriter.toString();
            int n = string.indexOf(10);
            int n2 = string.indexOf(10, n + 1);
            int n3 = string.indexOf(10, n2 + 1);
            return string.substring(n2 + 1, n3).trim();
        }
        return "WrappedTimer(no trace)";
    }

    private static boolean useRealTimers() {
        return !RuntimeConfiguration.isUnitTestMode();
    }

    public void removeActionListener() {
        this.timer.removeActionListener(this.listener);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

