/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.BasicBarChart;
import elgato.infrastructure.analyzer.PlainLabelPainter;
import elgato.infrastructure.analyzer.TraceAnalyzer;
import elgato.infrastructure.analyzer.TraceChart;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.mainScreens.TraceSaveTabDelimitable;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.SystemMeasurementSettings;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.metrics.MeasurementMetrics;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DynamicLabel;
import elgato.measurement.acp.ACPChartModel;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.acp.ACPMetrics;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class ACPAnalyzer
extends TraceAnalyzer {
    private Component pane;
    private BasicBarChart chart;
    private ACPChartModel chartModel;
    JPanel chartAndTop;
    private final NumberFieldStrategy decibelStrategyTraceSave = new DecibelStrategy(1, false);
    private final FrequencyStrategy freqStrategyTraceSave = new FrequencyStrategy();
    private ACPMetrics metrics = new ACPMetrics(0);
    private ACPMeasurement measurement;
    public ValueListener dbWattsListener = new ValueListener(){
        private final String listenerName = "AcpAn.dbWattsListener";

        public String getListenerName() {
            return "AcpAn.dbWattsListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            ACPAnalyzer.this.setYAxisStratety(ACPAnalyzer.this.chart);
        }
    };
    public ValueListener chartRefreshListener = new ValueListener(){
        private final String listenerName = "AcpAn.chartRefreshListener";

        public String getListenerName() {
            return "AcpAn.chartRefreshListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (ACPAnalyzer.this.chart != null && ACPAnalyzer.this.measurement != null) {
                ACPAnalyzer.this.chart.refresh();
            }
        }
    };
    public ValueListener metricRefreshListener = new ValueListener(){
        private final String listenerName = "AcpAn.metricRefreshListener";

        public String getListenerName() {
            return "AcpAn.metricRefreshListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            for (int i = 0; i < 3; ++i) {
                int n = ACPMeasurementSettings.instance().getAdjChanType(i);
                ACPAnalyzer.this.metrics.updateStandardFormat(i, n);
            }
        }
    };

    public ACPAnalyzer() {
        super("ACPAnalyzer");
        this.listenToActuator(DisplayGlobalMeasurementSettings.instance().getChanFreqUnits());
        this.listenToActuator(DisplayGlobalMeasurementSettings.instance().getChanStd());
        this.listenToActuator(this.getRefLevel());
        this.listenToActuator(this.getScaleDiv());
        this.listenToActuator(ACPMeasurementSettings.instance().getPowerLimitsToggle());
        this.listenToActuator(ACPMeasurementSettings.instance().getAdjChan1HighLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getAdjChan2HighLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getAdjChan3HighLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getCenterChanHighLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getCenterChanLowLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getFrequencyLimitsToggle());
        this.listenToActuator(ACPMeasurementSettings.instance().getFrequencyLowLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getFrequencyHighLimit());
        this.listenToActuator(ACPMeasurementSettings.instance().getdBmWattsUnits());
        ACPMeasurementSettings.instance().getdBmWattsUnits().addValueListener(this.dbWattsListener);
        DisplayGlobalMeasurementSettings.instance().getChanStd().addValueListener(this.chartRefreshListener);
        DisplayGlobalMeasurementSettings.instance().getChanStd().addValueListener(this.metricRefreshListener);
        DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().addValueListener(this.chartRefreshListener);
        JPanel jPanel = new JPanel();
        ((Component)jPanel).setBackground(MenuPanel.BG_COLOR);
        jPanel.setLayout(new BorderLayout(4, 4));
        JPanel jPanel2 = new JPanel(new TableLayout(new float[][]{{0.37f, 0.33f, -1.0f}, {-2.0f, -2.0f}}));
        ((Component)jPanel2).setBackground(null);
        jPanel2.add((Component)this.addLabel(new DynamicLabel(2, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                String string;
                if (measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_FORMAT) == 2) {
                    string = Text.Custom;
                } else {
                    string = DisplayGlobalMeasurementSettings.instance().getChanStd().toString();
                    if (string.startsWith("\n")) {
                        string = string.substring(1);
                    }
                    string = Text.Format + ": " + string;
                }
                return string;
            }
        }), TableLayoutConstraints.newCell(1, 0));
        jPanel2.add((Component)this.addLabel(new DynamicLabel(4, TraceAnalyzer.VALUE_COLOR, TraceAnalyzer.VALUE_FONT){

            protected String formatValue(Measurement measurement) {
                return Text.RF_IN_Loss + " " + new DecibelStrategy(1, false).format(measurement.getIntegerReadingValue(ACPMeasurement.ATTENUATION));
            }
        }), TableLayoutConstraints.newCell(2, 0));
        jPanel.add((Component)jPanel2, "North");
        this.chartModel = new ACPChartModel();
        this.chart = new BasicBarChart(this.chartModel, new PlainLabelPainter());
        this.chart.setSlotSpacing(36);
        this.chart.setDrawYAxisLabels(true);
        this.chart.setWidestYAxisString("-999.9");
        this.setYAxisStratety(this.chart);
        this.chart.setConstantXAxisLabelColor(TraceAnalyzer.VALUE_COLOR);
        this.chart.addDLabel(new TraceAnalyzer.AverageDynamicLabel(ACPMeasurement.AVERAGE_TYPE, ACPMeasurement.NUM_AVERAGES, ACPMeasurement.AVERAGE_COUNT), -22, 20);
        this.chart.addDLabel(new TraceAnalyzer.RangeControlDynamicLabel(ACPMeasurement.RANGE_HOLD, ACPMeasurement.RANGE_SETTING), 50, 20);
        this.updateChartVerticalRange();
        this.chartAndTop = new JPanel(new BorderLayout());
        this.chartAndTop.add((Component)jPanel2, "North");
        this.chartAndTop.add((Component)this.chart, "Center");
        jPanel.add((Component)new BorderWrapper(this.chartAndTop, TraceAnalyzer.getChartBorder(), true), "Center");
        jPanel.add((Component)new BorderWrapper(this.metrics, MeasurementMetrics.BORDER, true), "South");
        this.pane = jPanel;
    }

    public void dispose() {
        super.dispose();
        ACPMeasurementSettings.instance().getdBmWattsUnits().removeValueListener(this.dbWattsListener);
        DisplayGlobalMeasurementSettings.instance().getChanStd().removeValueListener(this.chartRefreshListener);
        DisplayGlobalMeasurementSettings.instance().getChanStd().removeValueListener(this.metricRefreshListener);
        DisplayGlobalMeasurementSettings.instance().getChanFreqUnits().removeValueListener(this.chartRefreshListener);
    }

    private void setYAxisStratety(BasicBarChart basicBarChart) {
        basicBarChart.setyAxisStrategy(new DecibelStrategy(1, true));
    }

    public MeasurementMetrics getMeasurementMetrics() {
        return this.metrics;
    }

    private LongActuator getRefLevel() {
        return ACPMeasurementSettings.instance().getRefLevel();
    }

    private LongActuator getScaleDiv() {
        return ACPMeasurementSettings.instance().getScaleDiv();
    }

    public void updateChartVerticalRange() {
        this.chart.setVerticalRange(this.getRefLevel().intValue(), this.getRefLevel().intValue() - this.getScaleDiv().intValue() * 10);
    }

    protected Component getPane() {
        return this.pane;
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }

    public ACPMetrics getMetrics() {
        return this.metrics;
    }

    protected void setMeasurement(Measurement measurement) {
        if (this.measurement != null) {
            this.measurement.recycle();
        }
        this.measurement = (ACPMeasurement)measurement;
    }

    protected TraceChart getChart() {
        return this.chart;
    }

    protected TraceChart[] getCharts() {
        return new TraceChart[]{this.getChart()};
    }

    public TabDelimitable[] createReadingFields() {
        TabDelimitable[] tabDelimitableArray;
        int n = this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_COUNT);
        int n2 = n * 2 + 1;
        int n3 = 0;
        int n4 = 0;
        TabDelimitable[] tabDelimitableArray2 = this.metrics.getTabDelimitables();
        int n5 = tabDelimitableArray2.length;
        if (SystemMeasurementSettings.instance().getSaveIncludeTraceActuator().intValue() == 1) {
            int n6;
            int n7;
            n3 = 4;
            tabDelimitableArray = new TabDelimitable[n5 + n2 + n3];
            for (int i = 0; i < n5; ++i) {
                tabDelimitableArray[n4++] = tabDelimitableArray2[i];
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace Data");
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Bar Count\t" + String.valueOf(n2));
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("X-AXIS\t\tY-AXIS");
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            int n8 = this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_POWER);
            for (n7 = 0; n7 < n; ++n7) {
                nArray[n7] = n8 + this.measurement.getIntegerArrayReadingValue(ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, n - 1 - n7);
            }
            for (n7 = 0; n7 < n; ++n7) {
                nArray2[n7] = n8 + this.measurement.getIntegerArrayReadingValue(ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, n7);
            }
            int[] nArray3 = new int[n];
            int[] nArray4 = new int[n];
            long l = (long)this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_CENTER_FREQUENCY) * 1000L + (long)this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_CENTER_FREQUENCY_FINE_TUNING_OFFSET);
            for (n6 = 0; n6 < n; ++n6) {
                nArray3[n6] = this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_OFFSET) + this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_STEP_SIZE) * (n - n6 - 1);
            }
            for (n6 = 0; n6 < n; ++n6) {
                nArray4[n6] = this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_OFFSET) + this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_STEP_SIZE) * n6;
            }
            for (n6 = 0; n6 < n; ++n6) {
                tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace", this.freqStrategyTraceSave, nArray3[n6], "-", this.decibelStrategyTraceSave, nArray[n6]);
            }
            tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace", this.freqStrategyTraceSave, l, "", this.decibelStrategyTraceSave, n8);
            for (n6 = 0; n6 < n; ++n6) {
                tabDelimitableArray[n4++] = new TraceSaveTabDelimitable("Trace", this.freqStrategyTraceSave, nArray4[n6], "+", this.decibelStrategyTraceSave, nArray2[n6]);
            }
        } else {
            tabDelimitableArray = new TabDelimitable[n5];
            for (int i = 0; i < n5; ++i) {
                tabDelimitableArray[n4++] = tabDelimitableArray2[i];
            }
        }
        return tabDelimitableArray;
    }

    public NumberFieldStrategy getYAxisNormalStrategy() {
        return null;
    }

    public NumberFieldStrategy getYAxisDeltaStrategy() {
        return null;
    }

    public NumberFieldStrategy getXAxisStrategy() {
        return null;
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        rectangle = this.chartAndTop.getBounds();
        rectangle.x += n;
        rectangle.y += n2;
        return super.filterPrintImage(image, rectangle);
    }
}

