/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.analyzer.BasicBarChartLimitsMask;
import elgato.infrastructure.analyzer.BasicBarChartModel;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.FrequencyToChannelStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.widgets.ImageIcon;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPMeasurementSettings;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;

public class ACPChartModel
implements BasicBarChartModel,
BasicBarChartLimitsMask {
    private static final int ADJ_CHANNELS = 3;
    private final Image passIcon = ImageIcon.loadImage("images/LimitsMask_P.png", new Canvas());
    private final Image failIcon = ImageIcon.loadImage("images/LimitsMask_F.png", new Canvas());
    final Color barColorInvalid = new Color(16719920);
    final Color barColorValid = new Color(63488);
    final Color barColorNoLimits = new Color(1057016);
    private final FrequencyStrategy frequencyStrategy = new FrequencyStrategy();
    private final FrequencyToChannelStrategy channelStrategy = new FrequencyToChannelStrategy(DisplayGlobalMeasurementSettings.instance().getChannelStep(), BandSelector.getGlobalBandSelector());
    private ACPMeasurement measurement;

    public int getNumBars() {
        return 7;
    }

    private int calcChannel(int n) {
        if (n < 3) {
            return -3 + n;
        }
        if ((n -= 3) > 3) {
            throw new IllegalArgumentException("Invalid bar " + (n + 3));
        }
        return n;
    }

    public int getValue(int n) {
        if (!this.isActive(n)) {
            return Integer.MIN_VALUE;
        }
        int n2 = this.calcChannel(n);
        int n3 = this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_POWER);
        if (n2 < 0) {
            if (this.measurement.getChannelType(-n2 - 1) == 0) {
                return n3 + this.measurement.getIntegerArrayReadingValue(ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, -n2 - 1);
            }
            return this.measurement.getIntegerArrayReadingValue(ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, -n2 - 1);
        }
        if (n2 == 0) {
            return n3;
        }
        if (this.measurement.getChannelType(n2 - 1) == 0) {
            return n3 + this.measurement.getIntegerArrayReadingValue(ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, n2 - 1);
        }
        return this.measurement.getIntegerArrayReadingValue(ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, n2 - 1);
    }

    public boolean isActive(int n) {
        int n2 = this.calcChannel(n);
        int n3 = this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_COUNT);
        return Math.abs(n2) <= n3;
    }

    public Color getColor(int n) {
        if (this.isMaskEnabled()) {
            return this.isBarValueValid(n) ? this.barColorValid : this.barColorInvalid;
        }
        return this.barColorNoLimits;
    }

    private boolean isBarValueValid(int n) {
        int n2 = this.getValue(n);
        int n3 = this.getLowLimit(n);
        int n4 = this.getHighLimit(n);
        return (n3 == Integer.MIN_VALUE || n2 >= n3) && (n4 == Integer.MIN_VALUE || n2 <= n4);
    }

    public String getLabel(int n) {
        if (!this.isActive(n)) {
            return "";
        }
        int n2 = this.calcChannel(n);
        if (n2 == 0) {
            long l = (long)this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_CENTER_FREQUENCY) * 1000L + (long)this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_CENTER_FREQUENCY_FINE_TUNING_OFFSET);
            return this.getFreqChanStrategy().format(l);
        }
        int n3 = Math.abs(n2);
        long l = this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_OFFSET) + this.measurement.getIntegerReadingValue(ACPMeasurement.ADJACENT_CHANNEL_STEP_SIZE) * (n3 - 1);
        String string = n2 < 0 ? "-" : "+";
        return string + this.frequencyStrategy.format(l);
    }

    public Image getBottomOfBarImage(int n) {
        if (!this.isActive(n)) {
            return null;
        }
        if (!this.isMaskEnabled()) {
            return null;
        }
        if (this.isBarValueValid(n)) {
            return this.passIcon;
        }
        return this.failIcon;
    }

    private NumberFieldStrategy getFreqChanStrategy() {
        ListActuator listActuator = DisplayGlobalMeasurementSettings.instance().getChanFreqUnits();
        if (listActuator.intValue() == 0) {
            return this.frequencyStrategy;
        }
        return this.channelStrategy;
    }

    public String getValueUnits() {
        return "";
    }

    public void setMeasurement(TraceMeasurement traceMeasurement) {
        this.measurement = (ACPMeasurement)traceMeasurement;
    }

    public boolean isMaskEnabled() {
        return ACPMeasurementSettings.instance().getPowerLimitsToggle().booleanValue();
    }

    public int getLowLimit(int n) {
        int n2 = this.calcChannel(n);
        if (n2 == 0) {
            return ACPMeasurementSettings.instance().getCenterChanLowLimit().intValue();
        }
        return Integer.MIN_VALUE;
    }

    public int getHighLimit(int n) {
        LongActuator longActuator;
        int n2 = this.calcChannel(n);
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        if (n2 == 0) {
            return aCPMeasurementSettings.getCenterChanHighLimit().intValue();
        }
        int n3 = Math.abs(n2);
        switch (n3) {
            case 1: {
                longActuator = aCPMeasurementSettings.getAdjChan1HighLimit();
                break;
            }
            case 2: {
                longActuator = aCPMeasurementSettings.getAdjChan2HighLimit();
                break;
            }
            case 3: {
                longActuator = aCPMeasurementSettings.getAdjChan3HighLimit();
                break;
            }
            default: {
                return Integer.MIN_VALUE;
            }
        }
        if (aCPMeasurementSettings.getAdjChanType(n3 - 1) == 0) {
            return this.measurement.getIntegerReadingValue(ACPMeasurement.PRIMARY_CHANNEL_POWER) + longActuator.intValue();
        }
        return longActuator.intValue();
    }
}

