/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.measurement.TraceMeasurement;
import elgato.infrastructure.readings.IntegerArrayReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import java.io.DataInput;
import java.io.IOException;

public class ACPMeasurement
extends TraceMeasurement {
    private static final long serialVersionUID = -8610219437680691168L;
    private static final Queue pool = new Queue(3);
    private static final int MAXADJCHANS = 5;
    private IntegerReading primaryChannelPower = new IntegerReading();
    private IntegerReading primaryChannelFrequencyError = new IntegerReading();
    private final IntegerArrayReading lowAdjacentChannelPowers = new IntegerArrayReading(5);
    private final IntegerArrayReading highAdjacentChannelPowers = new IntegerArrayReading(5);
    private IntegerReading primaryChannelCenterFrequency = new IntegerReading();
    private IntegerReading primaryChannelCenterFrequencyFineTuningOffset = new IntegerReading();
    private IntegerReading primaryChannelWidth = new IntegerReading();
    private IntegerReading primaryChannelMeasurementTime = new IntegerReading();
    private IntegerReading adjacentChannelWidth = new IntegerReading();
    private IntegerReading adjacentChannelOffset = new IntegerReading();
    private IntegerReading adjacentChannelStepSize = new IntegerReading();
    private IntegerReading adjacentChannelCount = new IntegerReading();
    private IntegerReading adjacentChannelMeasurementTime = new IntegerReading();
    private IntegerReading attenuation = new IntegerReading();
    private IntegerReading averageType = new IntegerReading();
    private IntegerReading numAverages = new IntegerReading();
    private IntegerReading sensitivity = new IntegerReading();
    private IntegerReading peakPowerMode = new IntegerReading();
    private IntegerReading rangeHold = new IntegerReading();
    private IntegerReading noiseCorrection = new IntegerReading();
    private IntegerReading rangeSetting = new IntegerReading();
    private IntegerReading averageCount = new IntegerReading();
    private IntegerReading rangeUpDown = new IntegerReading();
    private IntegerReading adjacentChannelWidth2 = new IntegerReading();
    private IntegerReading adjacentChannelWidth3 = new IntegerReading();
    private IntegerReading adjacentChannelStepSize2 = new IntegerReading();
    private IntegerReading adjacentChannelStepSize3 = new IntegerReading();
    private IntegerReading adjacentChannelFormat = new IntegerReading();
    private long[] adjacentChanUpperFreqs = new long[5];
    private int[] adjacentChanTypes = new int[5];
    private static int readingCount = 0;
    public static final int PRIMARY_CHANNEL_POWER = readingCount++;
    public static final int PRIMARY_CHANNEL_FREQUENCY_ERROR = readingCount++;
    public static final int LOW_ADJACENT_CHANNEL_POWERS = readingCount++;
    public static final int HIGH_ADJACENT_CHANNEL_POWERS = readingCount++;
    public static final int PRIMARY_CHANNEL_CENTER_FREQUENCY = readingCount++;
    public static final int PRIMARY_CHANNEL_CENTER_FREQUENCY_FINE_TUNING_OFFSET = readingCount++;
    public static final int PRIMARY_CHANNEL_WIDTH = readingCount++;
    public static final int PRIMARY_CHANNEL_MEASUREMENT_TIME = readingCount++;
    public static final int ADJACENT_CHANNEL_WIDTH = readingCount++;
    public static final int ADJACENT_CHANNEL_OFFSET = readingCount++;
    public static final int ADJACENT_CHANNEL_STEP_SIZE = readingCount++;
    public static final int ADJACENT_CHANNEL_COUNT = readingCount++;
    public static final int ADJACENT_CHANNEL_MEASUREMENT_TIME = readingCount++;
    public static final int ATTENUATION = readingCount++;
    public static final int AVERAGE_TYPE = readingCount++;
    public static final int NUM_AVERAGES = readingCount++;
    public static final int SENSITIVITY = readingCount++;
    public static final int PEAK_POWER_MODE = readingCount++;
    public static final int RANGE_HOLD = readingCount++;
    public static final int NOISE_CORRECTION = readingCount++;
    public static final int RANGE_SETTING = readingCount++;
    public static final int AVERAGE_COUNT = readingCount++;
    public static final int RANGE_UPDOWN = readingCount++;
    public static final int ADJACENT_CHANNEL_OFFSET2 = readingCount++;
    public static final int ADJACENT_CHANNEL_OFFSET3 = readingCount++;
    public static final int ADJACENT_CHANNEL_STEP_SIZE2 = readingCount++;
    public static final int ADJACENT_CHANNEL_STEP_SIZE3 = readingCount++;
    public static final int ADJACENT_CHANNEL_FORMAT = readingCount++;
    private Reading[] readings = new Reading[]{this.primaryChannelPower, this.primaryChannelFrequencyError, this.lowAdjacentChannelPowers, this.highAdjacentChannelPowers, this.primaryChannelCenterFrequency, this.primaryChannelCenterFrequencyFineTuningOffset, this.primaryChannelWidth, this.primaryChannelMeasurementTime, this.adjacentChannelWidth, this.adjacentChannelOffset, this.adjacentChannelStepSize, this.adjacentChannelCount, this.adjacentChannelMeasurementTime, this.attenuation, this.averageType, this.numAverages, this.sensitivity, this.peakPowerMode, this.rangeHold, this.noiseCorrection, this.rangeSetting, this.averageCount, this.rangeUpDown, this.adjacentChannelWidth2, this.adjacentChannelWidth3, this.adjacentChannelStepSize2, this.adjacentChannelStepSize3, this.adjacentChannelFormat};

    public static ACPMeasurement unpack(DataInput dataInput) throws IOException {
        ACPMeasurement aCPMeasurement = ACPMeasurement.create();
        Reading[] readingArray = aCPMeasurement.getReadings();
        for (int i = 0; i < readingArray.length; ++i) {
            readingArray[i].unpack(dataInput);
        }
        aCPMeasurement.decodeChannelFreqs();
        aCPMeasurement.decodeChannelTypes();
        return aCPMeasurement;
    }

    private Reading[] getReadings() {
        return this.readings;
    }

    private static ACPMeasurement create() {
        ACPMeasurement aCPMeasurement = (ACPMeasurement)pool.dequeue();
        if (aCPMeasurement == null) {
            return new ACPMeasurement();
        }
        return aCPMeasurement;
    }

    private void decodeChannelFreqs() {
        int n = 0;
        if (this.adjacentChannelStepSize2.longValue() > 0L) {
            this.adjacentChanUpperFreqs[0] = this.adjacentChannelOffset.longValue();
            this.adjacentChanUpperFreqs[1] = this.adjacentChanUpperFreqs[0] + this.adjacentChannelStepSize.longValue();
            this.adjacentChanUpperFreqs[2] = this.adjacentChanUpperFreqs[1] + this.adjacentChannelStepSize2.longValue();
            this.adjacentChanUpperFreqs[3] = this.adjacentChanUpperFreqs[2] + this.adjacentChannelStepSize3.longValue();
        } else {
            for (n = 0; n < 5; ++n) {
                this.adjacentChanUpperFreqs[n] = this.adjacentChannelOffset.longValue() * (long)(n + 1);
            }
        }
    }

    private void decodeChannelTypes() {
        int n = 1;
        for (int i = 0; i < 5; ++i) {
            int n2 = this.adjacentChannelFormat.intValue() & n;
            this.adjacentChanTypes[i] = n2 != 0 ? 1 : 0;
            n <<= 1;
        }
    }

    public void recycle() {
        pool.enqueue(this);
    }

    public int[] getTrace() {
        int n;
        int n2 = this.adjacentChannelCount.intValue();
        int n3 = 2 * n2 + 1;
        int[] nArray = new int[n3];
        int n4 = this.primaryChannelPower.intValue();
        int n5 = 0;
        int[] nArray2 = this.lowAdjacentChannelPowers.getTrace();
        for (n = n2 - 1; n >= 0; --n) {
            nArray[n5++] = this.adjacentChanTypes[n] == 0 ? n4 + nArray2[n] : nArray2[n];
        }
        nArray[n5++] = n4;
        nArray2 = this.highAdjacentChannelPowers.getTrace();
        for (n = 0; n < n2; ++n) {
            nArray[n5++] = this.adjacentChanTypes[n] == 0 ? n4 + nArray2[n] : nArray2[n];
        }
        return nArray;
    }

    public long getChannelFreq(int n) {
        return this.adjacentChanUpperFreqs[n];
    }

    public int getChannelType(int n) {
        return this.adjacentChanTypes[n];
    }

    public long getTraceStartValue() {
        return 0L;
    }

    public long getTraceStopValue() {
        return 0L;
    }

    public int getIntegerReadingValue(int n) {
        return this.readings[n].intValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        return ((IntegerArrayReading)this.getReadings()[n]).getTrace()[n2];
    }

    public long getLongReadingValue(int n) {
        return this.readings[n].longValue();
    }

    public double getDoubleReadingValue(int n) {
        return 0.0;
    }

    public float getFloatReadingValue(int n) {
        return 0.0f;
    }

    public String getMeasurementTitle() {
        return Text.Chan_Pwr_slash_ACP;
    }
}

