/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementGenerator;
import elgato.measurement.acp.ACPMeasurement;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ACPMeasurementGenerator
extends MeasurementGenerator {
    public int priChanPower = 1;
    public int priChanFreqErr = 2;
    public int priChanCF = 3;
    public int priChanCFOffset = 4;
    public int priChanWidth = 5;
    public int adjChanWidth = 7;
    public int adjChanOffset = 8;
    public int adjChanStep = 9;
    public int adjChCount = 10;
    public int peakPower = 16;

    protected void writePayload(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.priChanPower);
        dataOutput.writeInt(this.priChanFreqErr);
        this.writeAdjacentChannelPowers(dataOutput, 1000);
        this.writeAdjacentChannelPowers(dataOutput, 6000);
        dataOutput.writeInt(this.priChanCF);
        dataOutput.writeInt(this.priChanCFOffset);
        dataOutput.writeInt(this.priChanWidth);
        dataOutput.writeInt(6);
        dataOutput.writeInt(this.adjChanWidth);
        dataOutput.writeInt(this.adjChanOffset);
        dataOutput.writeInt(this.adjChanStep);
        dataOutput.writeInt(this.adjChCount);
        dataOutput.writeInt(11);
        dataOutput.writeInt(12);
        dataOutput.writeInt(13);
        dataOutput.writeInt(14);
        dataOutput.writeInt(15);
        dataOutput.writeInt(this.peakPower);
        dataOutput.writeInt(17);
        dataOutput.writeInt(18);
        dataOutput.writeInt(-20000);
        dataOutput.writeInt(19);
        dataOutput.writeInt(0);
    }

    private void writeAdjacentChannelPowers(DataOutput dataOutput, int n) throws IOException {
        for (int i = 0; i < 5; ++i) {
            if (i < this.adjChCount) {
                dataOutput.writeInt(n + 1000 * i);
                continue;
            }
            dataOutput.writeInt(Integer.MIN_VALUE);
        }
    }

    protected Measurement unpack(DataInput dataInput) throws IOException {
        return ACPMeasurement.unpack(dataInput);
    }
}

