/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.Actuator;
import elgato.infrastructure.actuators.CenterFrequencyActuator;
import elgato.infrastructure.actuators.FreqChanActuatorConfigurator;
import elgato.infrastructure.actuators.FrequencyActuator;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.ScaleDivActuator;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.Palette;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.units.Conversion;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.units.FactorConversion;
import elgato.infrastructure.units.FrequencyUnits;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.BandSelector;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.acp.ACPFormat;
import elgato.measurement.acp.ACPFormats;
import java.util.Vector;

public class ACPMeasurementSettings
extends MeasurementSettings {
    public static final String TOPIC_ACP = "adjChan";
    public static final String DISPLAY_TOPIC = "display.adjChan";
    public static final int LEVEL_DBM_UNIT = 0;
    public static final int LEVEL_WATTS_UNIT = 1;
    public static final int MAXADJCHANS = 5;
    public static final String KEY_ACP_LEVELUNITS = "levelUnits";
    public static final String KEY_ACP_PRI_CHAN_BW = "priChanWidth";
    public static final String KEY_ACP_CUST_PRI_CHAN_BW = "custPriChanWidth";
    public static final String KEY_ACP_ADJ_CHAN_BW = "adjChanWidth";
    public static final String KEY_ACP_ADJ_CHAN_BW2 = "adjChanWidth2";
    public static final String KEY_ACP_ADJ_CHAN_BW3 = "adjChanWidth3";
    public static final String KEY_ACP_CUST_ADJ_CHAN_BW = "custAdjChanWidth";
    public static final String KEY_ACP_ADJ_CHAN_OFFSET = "adjChOffset";
    public static final String KEY_ACP_CUST_ADJ_CHAN_OFFSET = "custAdjChOffset";
    public static final String KEY_ACP_ADJ_CHAN_STEP = "adjChStep";
    public static final String KEY_ACP_ADJ_CHAN_STEP2 = "adjChStep2";
    public static final String KEY_ACP_ADJ_CHAN_STEP3 = "adjChStep3";
    public static final String KEY_ACP_ADJ_FORMAT = "adjFormat";
    public static final String KEY_ACP_CUST_ADJ_CHAN_STEP = "custAdjChStep";
    public static final String KEY_ACP_ADJ_CHAN_COUNT = "adjChCount";
    public static final String KEY_ACP_CUST_ADJ_CHAN_COUNT = "custAdjChCount";
    public static final String KEY_ACP_FORMATTYPE = "formatType";
    public static final String KEY_ACP_PRI_MEASTIME = "priMeasTime";
    public static final String KEY_ACP_CUST_PRI_MEASTIME = "custPriMeasTime";
    public static final String KEY_ACP_ADJ_MEASTIME = "adjMeasTime";
    public static final String KEY_ACP_CUST_ADJ_MEASTIME = "custAdjMeasTime";
    public static final String KEY_ACP_SELECTED_FORMAT = "selectedFormat";
    public static final String KEY_ACP_CHANSTD = "chanScanChanStd";
    public static final String KEY_ACP_UNITS = "csUnits";
    protected static final String KEY_FREQ_ERROR = "freqError";
    protected static final String KEY_CUST_FREQ_ERROR = "custFreqError";
    public static final int VALUE_POWER_AVERAGE = 0;
    public static final int VALUE_POWER_PEAK = 1;
    private static ACPMeasurementSettings instance;
    private ACPFormat gsmFormat = ACPFormats.GSM;
    private long[] adjacentChanUpperFreqs = new long[5];
    private int[] adjacentChanTypes = new int[5];
    private FrequencyActuator centerFreq = CenterFrequencyActuator.createCenterFrequencyActuator("adjChan", "cf");
    private LongActuator priChanWidth = new LongActuator("adjChan", "priChanWidth", Text.Center_Chan_n_Meas_BW);
    private LongActuator custPriChanWidth = new LongActuator("display.adjChan", "custPriChanWidth", "", this.gsmFormat.getCenterChanBandwidth());
    private Conversion microsecondToMillisecondConversion = FactorConversion.createFixedPoint("ms", 1000);
    private LongActuator priMeasTime = new LongActuator("adjChan", "priMeasTime", Text.Center_Chan_n_Meas_Time, this.microsecondToMillisecondConversion);
    private LongActuator custPriMeasTime = new LongActuator("display.adjChan", "custPriMeasTime", "", this.gsmFormat.getCenterChanMeasTime());
    private LongActuator adjChanWidth = new LongActuator("adjChan", "adjChanWidth", Text.Adj_Chan_n_Meas_BW);
    private LongActuator adjChanWidth2 = new LongActuator("adjChan", "adjChanWidth2", Text.Adj_Chan_n_Meas_BW);
    private LongActuator adjChanWidth3 = new LongActuator("adjChan", "adjChanWidth3", Text.Adj_Chan_n_Meas_BW);
    private LongActuator custAdjChanWidth = new LongActuator("display.adjChan", "custAdjChanWidth", "", this.gsmFormat.getAdjChanBandwidth());
    private LongActuator adjChanStep = new FrequencyActuator("adjChan", "adjChStep", Text.Adj_to_Adj_n_Step_Size);
    private LongActuator adjChanStep2 = new FrequencyActuator("adjChan", "adjChStep2", Text.Adj_to_Adj_n_Step_Size);
    private LongActuator adjChanStep3 = new FrequencyActuator("adjChan", "adjChStep3", Text.Adj_to_Adj_n_Step_Size);
    private LongActuator adjChanFormat = new LongActuator("adjChan", "adjFormat", Text.Adj_Power_Format);
    private LongActuator custAdjChanStep = new LongActuator("display.adjChan", "custAdjChStep", "", this.gsmFormat.getAdjacentToAdjacentStepSize());
    private LongActuator adjChanCount = new LongActuator("adjChan", "adjChCount", Text.Num_Adj_n_Chans);
    private LongActuator custAdjChanCount = new LongActuator("display.adjChan", "custAdjChCount", "", this.gsmFormat.getNumAdjacentChannels());
    private LongActuator adjMeasTime = new LongActuator("adjChan", "adjMeasTime", Text.Adj_Chan_n_Meas_Time, this.microsecondToMillisecondConversion);
    private LongActuator custAdjMeasTime = new LongActuator("display.adjChan", "custAdjMeasTime", "", this.gsmFormat.getAdjChanMeasTime());
    private ListActuator averaging = ListActuator.createStandardAveraging("adjChan");
    private LongActuator numAverages = LongActuator.createNumAverages("adjChan", 100);
    private ListActuator sensitivity = ListActuator.createSensitivity("adjChan");
    private ListActuator powerDetector = ListActuator.createpowerDetector("adjChan");
    private ListActuator rangeHold = ListActuator.createRangeHold("adjChan");
    private final LongActuator rangeUpDown = new LongActuator("adjChan", "rangeUpDown", "RangeUpDown");
    private ScaleDivActuator scaleDiv = new ScaleDivActuator("display.adjChan", 15000);
    private LongActuator refLevel = LongActuator.createRefLevelActuator("display.adjChan", 20000, "dBm", -100000, 100000, this.scaleDiv);
    private ListActuator dBmWattsUnits = new ListActuator("display.adjChan", "levelUnits", Text.Units, new Value[]{Value.createValue(Text.dBm, 0), Value.createValue(Text.Watts, 1)});
    private ListActuator formatType = ListActuator.createFormatType("display.adjChan");
    private ListActuator formatList = ListActuator.createFormatList("display.adjChan", ACPMeasurementSettings.loadFormatList());
    private ListActuator powerLimitsToggle = new ListActuator("display.adjChan", "powerLimitsToggle", Text.Power_n_Limits, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private LongActuator centerChanLowLimit = LongActuator.createPower("display.adjChan", "centerChanLowLimit", Text.Center_Chan_n_Low_Limit);
    private LongActuator centerChanHighLimit = LongActuator.createPower("display.adjChan", "centerChanHighLimit", Text.Center_Chan_n_High_Limit);
    private LongActuator adjChan1HighLimit = LongActuator.createPower("display.adjChan", "adjChan1HighLimit", Text.Adj_Chan_1_n_High_Limit);
    private LongActuator adjChan2HighLimit = LongActuator.createPower("display.adjChan", "adjChan2HighLimit", Text.Adj_Chan_2_n_High_Limit);
    private LongActuator adjChan3HighLimit = LongActuator.createPower("display.adjChan", "adjChan3HighLimit", Text.Adj_Chan_3_n_High_Limit);
    private ListActuator frequencyLimitsToggle = new ListActuator("display.adjChan", "frequencyLimitsToggle", Text.Freq_Error_n_Limits, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private FrequencyActuator frequencyLowLimit = new FrequencyActuator("display.adjChan", "frequencyLowLimit", Text.Frequency_n_Low_Limit);
    private FrequencyActuator frequencyHighLimit = new FrequencyActuator("display.adjChan", "frequencyHighLimit", Text.Frequency_n_High_Limit);
    private FrequencyActuator adjChannelOffset = new FrequencyActuator(this.getTopic(), "adjChOffset", Text.Ctr_to_Adj_n_Step_Size);
    private LongActuator custAdjChannelOffset = new LongActuator("display.adjChan", "custAdjChOffset", "", this.gsmFormat.getCenterToAdjacentStepSize());
    private ListActuator freqError = new ListActuator("display.adjChan", "freqError", Text.Freq_Err, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    private LongActuator custFreqError = new LongActuator("display.adjChan", "custFreqError", "");
    private ListActuator noiseCorrection = ListActuator.createNoiseCorrection("adjChan");
    public static final String testLimits = "adjChan.frequencyLimitsToggle=1\nadjChan.powerLimitsToggle=1\nadjChan.adjChan1HighLimit=-45000\nadjChan.centerChanHighLimit=50000\nadjChan.centerChanLowLimit=20000\n";

    public LongActuator[] getStorableActuators() {
        return new LongActuator[]{this.frequencyLowLimit, this.frequencyHighLimit, this.centerChanLowLimit, this.centerChanHighLimit, this.adjChan1HighLimit, this.adjChan2HighLimit, this.adjChan3HighLimit};
    }

    private ACPMeasurementSettings() {
        super(TOPIC_ACP);
        this.add(this.centerFreq);
        this.add(this.priChanWidth);
        this.add(this.priMeasTime);
        this.add(this.adjChanWidth);
        this.add(this.adjChanWidth2);
        this.add(this.adjChanWidth3);
        this.add(this.adjMeasTime);
        this.add(this.adjChanStep);
        this.add(this.adjChanStep2);
        this.add(this.adjChanStep3);
        this.add(this.adjChanFormat);
        this.add(this.adjChannelOffset);
        this.add(this.adjChanCount);
        this.add(this.averaging);
        this.add(this.numAverages);
        this.add(this.sensitivity);
        this.add(this.powerDetector);
        this.add(this.noiseCorrection);
        this.add(this.rangeHold);
        this.add(this.rangeUpDown);
        this.add(this.scaleDiv);
        this.add(this.refLevel);
        this.add(this.dBmWattsUnits);
        this.add(this.formatType);
        this.add(this.formatList);
        this.add(this.powerLimitsToggle);
        this.add(this.centerChanLowLimit);
        this.add(this.centerChanHighLimit);
        this.add(this.adjChan1HighLimit);
        this.add(this.adjChan2HighLimit);
        this.add(this.adjChan3HighLimit);
        this.add(this.frequencyLimitsToggle);
        this.add(this.frequencyLowLimit);
        this.add(this.frequencyHighLimit);
        this.add(this.custAdjChanCount);
        this.add(this.custAdjChannelOffset);
        this.add(this.custAdjChanStep);
        this.add(this.custAdjChanWidth);
        this.add(this.custAdjMeasTime);
        this.add(this.custPriChanWidth);
        this.add(this.custPriMeasTime);
        this.add(this.custFreqError);
        this.frequencyLimitsToggle.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.frequencyLimitsToggle";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.frequencyLimitsToggle";
            }
        });
        this.powerLimitsToggle.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.powerLimitsToggle";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.powerLimitsToggle";
            }
        });
        this.centerChanLowLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.centerChanLowLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.centerChanLowLimit";
            }
        });
        this.centerChanHighLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.centerChanHighLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.centerChanHighLimit";
            }
        });
        this.adjChan1HighLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.adjChan1HighLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.adjChan1HighLimit";
            }
        });
        this.adjChan2HighLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.adjChan2HighLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.adjChan2HighLimit";
            }
        });
        this.adjChan3HighLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.adjChan3HighLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.adjChan3HighLimit";
            }
        });
        this.frequencyLowLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.frequencyLowLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.frequencyLowLimit";
            }
        });
        this.frequencyHighLimit.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.frequencyHighLimit";

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.setAllLimits();
            }

            public String getListenerName() {
                return "ACP.frequencyHighLimit";
            }
        });
        this.custAdjMeasTime.setConversion(this.microsecondToMillisecondConversion);
        this.custPriMeasTime.setConversion(this.microsecondToMillisecondConversion);
        this.adjChannelOffset.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custAdjChannelOffset, this.formatType, "ACP.adjChannelOffset"));
        this.adjChanStep.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custAdjChanStep, this.formatType, "ACP.adjChanStep"));
        this.adjChanCount.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custAdjChanCount, this.formatType, "ACP.adjChanCount"));
        this.priChanWidth.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custPriChanWidth, this.formatType, "ACP.priChanWidth"));
        this.priMeasTime.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custPriMeasTime, this.formatType, "ACP.priMeasTime"));
        this.adjChanWidth.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custAdjChanWidth, this.formatType, "ACP.adjChanWidth"));
        this.adjMeasTime.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custAdjMeasTime, this.formatType, "ACP.adjMeasTime"));
        this.freqError.addValueListener(ACPMeasurementSettings.createCustomUpdaterValueListener(this.custFreqError, this.formatType, "ACP.freqError"));
        this.setValidatorToFreqExtLimits(this.centerFreq);
        new FreqChanActuatorConfigurator(this.centerFreq, DisplayGlobalMeasurementSettings.instance().getChanFreqUnits(), DisplayGlobalMeasurementSettings.instance().getChanStd(), DisplayGlobalMeasurementSettings.instance().getChannelStep(), DisplayGlobalMeasurementSettings.instance().getFrequencyStep(), BandSelector.getGlobalBandSelector(), "ACP.cf");
        this.sensitivity.setValue(1);
        DbmUnitsFactory dbmUnitsFactory = new DbmUnitsFactory();
        this.refLevel.setUnitsFactory(dbmUnitsFactory);
        this.centerChanHighLimit.setUnitsFactory(dbmUnitsFactory);
        this.centerChanLowLimit.setUnitsFactory(dbmUnitsFactory);
        this.refLevel.setIncrement(this.scaleDiv.intValue() / 10);
        this.addDBmWattsUnitsValueListeners();
        this.configureActuatorWithKHzIncrement(this.priChanWidth, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.custPriChanWidth, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.adjChanWidth, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.custAdjChanWidth, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.adjChannelOffset, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.custAdjChannelOffset, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.adjChanStep, Palette.createUnsignedDecimal());
        this.configureActuatorWithKHzIncrement(this.custAdjChanStep, Palette.createUnsignedDecimal());
        this.configureMeasTimeActuator(this.priMeasTime);
        this.configureMeasTimeActuator(this.custPriMeasTime);
        this.configureMeasTimeActuator(this.adjMeasTime);
        this.configureMeasTimeActuator(this.custAdjMeasTime);
        this.adjChanCount.setValidator(new RangeValidator(0L, 3L));
        this.frequencyLowLimit.setValidator(new RangeValidator(-1000000000L, 0L));
        this.frequencyHighLimit.setValidator(new RangeValidator(0L, 1000000000L));
        this.frequencyLowLimit.setPalette(Palette.createSignedDecimal());
        this.frequencyHighLimit.setPalette(Palette.createUnsignedDecimal());
        this.scaleDiv.addValueListener(new ValueListener(){
            private final String listenerName = "ACP.scaleDivListener";

            public String getListenerName() {
                return "ACP.scaleDivListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                ACPMeasurementSettings.this.refLevel.setIncrement(ACPMeasurementSettings.this.scaleDiv.intValue() / 10);
            }
        });
        this.refresh();
    }

    private void configureMeasTimeActuator(LongActuator longActuator) {
        longActuator.setValidator(new RangeValidator(1000L, Integer.MAX_VALUE));
        longActuator.setIncrement(1000);
        longActuator.setPalette(Palette.createUnsignedDecimal());
    }

    private void configureActuatorWithKHzIncrement(LongActuator longActuator, Palette palette) {
        RangeValidator rangeValidator = new RangeValidator(0L, Integer.MAX_VALUE);
        longActuator.setUnitsFactory(new FrequencyUnits());
        longActuator.setPalette(palette);
        longActuator.setValidator(rangeValidator);
        longActuator.setIncrement(1000);
    }

    public static ValueListener createCustomUpdaterValueListener(final Actuator actuator, final Actuator actuator2, final String string) {
        return new ValueListener(){
            private boolean initialResponseReceived;
            private final String listenerName;
            {
                this.listenerName = string + ".custom";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (actuator2.intValue() == 2 && this.initialResponseReceived) {
                    actuator.setValue(valueInterface.longValue());
                }
                this.initialResponseReceived = true;
            }
        };
    }

    public void decodeChannelFreqs() {
        int n = 0;
        if (this.adjChanStep2.longValue() > 0L) {
            this.adjacentChanUpperFreqs[0] = this.adjChannelOffset.longValue();
            this.adjacentChanUpperFreqs[1] = this.adjacentChanUpperFreqs[0] + this.adjChanStep.longValue();
            this.adjacentChanUpperFreqs[2] = this.adjacentChanUpperFreqs[1] + this.adjChanStep2.longValue();
            this.adjacentChanUpperFreqs[3] = this.adjacentChanUpperFreqs[2] + this.adjChanStep3.longValue();
        } else {
            for (n = 0; n < 5; ++n) {
                this.adjacentChanUpperFreqs[n] = this.adjChannelOffset.longValue() * (long)(n + 1);
            }
        }
    }

    public void setLimitType() {
        if (this.adjacentChanTypes[0] == 0) {
            this.adjChan1HighLimit.setConversion(FactorConversion.createFixedPoint("dBc", 1000));
        } else {
            this.adjChan1HighLimit.setConversion(FactorConversion.createFixedPoint("dBm", 1000));
        }
        if (this.adjacentChanTypes[1] == 0) {
            this.adjChan2HighLimit.setConversion(FactorConversion.createFixedPoint("dBc", 1000));
        } else {
            this.adjChan2HighLimit.setConversion(FactorConversion.createFixedPoint("dBm", 1000));
        }
        if (this.adjacentChanTypes[2] == 0) {
            this.adjChan3HighLimit.setConversion(FactorConversion.createFixedPoint("dBc", 1000));
        } else {
            this.adjChan3HighLimit.setConversion(FactorConversion.createFixedPoint("dBm", 1000));
        }
    }

    public void decodeChannelTypes() {
        int n = 1;
        for (int i = 0; i < 5; ++i) {
            int n2 = this.adjChanFormat.intValue() & n;
            this.adjacentChanTypes[i] = n2 != 0 ? 1 : 0;
            n <<= 1;
        }
    }

    private void addDBmWattsUnitsValueListeners() {
        ValueListener valueListener = new ValueListener(){
            private final String listenerName = "ACP.dBmWattsUnitsListener";

            public String getListenerName() {
                return "ACP.dBmWattsUnitsListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                Conversion conversion = valueInterface.intValue() == 1 ? DbmUnitsFactory.getWattsConversion() : DbmUnitsFactory.getDbmConversion();
                LongActuator[] longActuatorArray = new LongActuator[]{ACPMeasurementSettings.this.refLevel, ACPMeasurementSettings.this.centerChanLowLimit, ACPMeasurementSettings.this.centerChanHighLimit};
                for (int i = 0; i < longActuatorArray.length; ++i) {
                    LongActuator longActuator = longActuatorArray[i];
                    longActuator.setConversion(conversion);
                    longActuator.fireValueChanged();
                }
            }
        };
        this.dBmWattsUnits.addValueListener(valueListener);
        valueListener.valueChanged(this.dBmWattsUnits);
    }

    public static ACPMeasurementSettings instance() {
        if (instance == null) {
            instance = new ACPMeasurementSettings();
            MeasurementSettings.logger.instanceTrack(instance, "create");
        }
        return instance;
    }

    public static void clearInstance() {
        if (instance != null) {
            MeasurementSettings.logger.instanceTrack(instance, "clear");
        }
        instance = null;
    }

    public LongActuator getScaleDiv() {
        return this.scaleDiv;
    }

    public LongActuator getRefLevel() {
        return this.refLevel;
    }

    public ListActuator getdBmWattsUnits() {
        return this.dBmWattsUnits;
    }

    public LongActuator getNumAverages() {
        return this.numAverages;
    }

    public LongActuator getPriChanWidth() {
        return this.priChanWidth;
    }

    public LongActuator getPriMeasTime() {
        return this.priMeasTime;
    }

    public ListActuator getAveraging() {
        return this.averaging;
    }

    public ListActuator getFormatType() {
        return this.formatType;
    }

    public ListActuator getFormatList() {
        return this.formatList;
    }

    public ListActuator getSensitivity() {
        return this.sensitivity;
    }

    public ListActuator getPowerDetector() {
        return this.powerDetector;
    }

    public ListActuator getRangeHold() {
        return this.rangeHold;
    }

    public LongActuator getRangeUpDown() {
        return this.rangeUpDown;
    }

    public LongActuator getAdjChanWidth() {
        return this.adjChanWidth;
    }

    public LongActuator getAdjChanWidth2() {
        return this.adjChanWidth2;
    }

    public LongActuator getAdjChanWidth3() {
        return this.adjChanWidth3;
    }

    public LongActuator getAdjMeasTime() {
        return this.adjMeasTime;
    }

    public FrequencyActuator getCenterFreq() {
        return this.centerFreq;
    }

    public LongActuator getAdjChanStep() {
        return this.adjChanStep;
    }

    public LongActuator getAdjChanStep2() {
        return this.adjChanStep2;
    }

    public LongActuator getAdjChanStep3() {
        return this.adjChanStep3;
    }

    public LongActuator getAdjChanFormat() {
        return this.adjChanFormat;
    }

    public LongActuator getAdjChanCount() {
        return this.adjChanCount;
    }

    public long getAdjChanFreq(int n) {
        return this.adjacentChanUpperFreqs[n];
    }

    public int getAdjChanType(int n) {
        return this.adjacentChanTypes[n];
    }

    public ListActuator getPowerLimitsToggle() {
        return this.powerLimitsToggle;
    }

    public LongActuator getCenterChanLowLimit() {
        return this.centerChanLowLimit;
    }

    public LongActuator getCenterChanHighLimit() {
        return this.centerChanHighLimit;
    }

    public LongActuator getAdjChan1HighLimit() {
        return this.adjChan1HighLimit;
    }

    public LongActuator getAdjChan2HighLimit() {
        return this.adjChan2HighLimit;
    }

    public LongActuator getAdjChan3HighLimit() {
        return this.adjChan3HighLimit;
    }

    public ListActuator getFrequencyLimitsToggle() {
        return this.frequencyLimitsToggle;
    }

    public LongActuator getFrequencyLowLimit() {
        return this.frequencyLowLimit;
    }

    public LongActuator getFrequencyHighLimit() {
        return this.frequencyHighLimit;
    }

    public FrequencyActuator getAdjChannelOffset() {
        return this.adjChannelOffset;
    }

    private static Value[] loadFormatList() {
        Vector vector = ACPFormats.getFormats();
        Object[] objectArray = new Value[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public LongActuator getCustFreqError() {
        return this.custFreqError;
    }

    public Actuator getCustAdjChannelOffset() {
        return this.custAdjChannelOffset;
    }

    public LongActuator getCustPriChanWidth() {
        return this.custPriChanWidth;
    }

    public LongActuator getCustPriMeasTime() {
        return this.custPriMeasTime;
    }

    public LongActuator getCustAdjChanWidth() {
        return this.custAdjChanWidth;
    }

    public LongActuator getCustAdjChanStep() {
        return this.custAdjChanStep;
    }

    public LongActuator getCustAdjChanCount() {
        return this.custAdjChanCount;
    }

    public LongActuator getCustAdjMeasTime() {
        return this.custAdjMeasTime;
    }

    public ListActuator getFrequencyError() {
        return this.freqError;
    }

    public ListActuator getNoiseCorrection() {
        return this.noiseCorrection;
    }
}

