/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.measurement.DisplayGlobalMeasurementSettings;
import elgato.infrastructure.menu.FrequencyChannelButtonFactory;
import elgato.infrastructure.menu.ItemSelectionEvent;
import elgato.infrastructure.menu.ItemSelectionListener;
import elgato.infrastructure.menu.LevelButtonFactory;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.chanstd.Band;
import elgato.infrastructure.util.chanstd.BandNotFoundException;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.acp.ACPAnalyzer;
import elgato.measurement.acp.ACPFormat;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.spectrum.SpectrumMeasurementSettings;

public abstract class ACPMenuMgr
extends MeasurementMenuMgr {
    private final Logger logger = LogManager.getLogger(class$elgato$measurement$acp$ACPScreen == null ? (class$elgato$measurement$acp$ACPScreen = ACPMenuMgr.class$("elgato.measurement.acp.ACPScreen")) : class$elgato$measurement$acp$ACPScreen);
    protected final ACPAnalyzer analyzer;
    protected final ACPMeasurementSettings settings;
    private Menu freqChanMenu;
    private MenuButton averageSweepMenu;
    protected MenuItem chanStdButton;
    protected MenuItem channelBWTimeButton;
    protected ListActuatorButton formatListButton;
    protected MenuItem ctrToAdjStepSizeButton;
    protected MenuItem adjToAdjStepSizeButton;
    protected MenuItem numAdjChanButton;
    private MenuItem adjChanMeasTimeButton;
    private MenuItem centerChanMeasTimeButton;
    private MenuItem adjChanBandWidthButton;
    private MenuItem centerChanBandwidthButton;
    private MenuItem freqErrButton;
    private ValueListener chanStdListener;
    private ValueListener formatTypeValueListener = new ValueListener(){
        private final String listenerName = "ACPScreen.formatTypeValueListener";

        public String getListenerName() {
            return "ACPScreen.formatTypeValueListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            ACPMenuMgr.this.configureFormatButtons(valueInterface);
        }
    };
    private ValueListener averagingLimitListener = new ValueListener(){
        private final String listenerName = "ACPScreen.averagingLimitListener";

        public String getListenerName() {
            return "ACPScreen.averagingLimitListener";
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (valueInterface.intValue() == 0) {
                ACPMenuMgr.this.setAveragingAvailabe(true);
            } else {
                ACPMenuMgr.this.setAveragingAvailabe(false);
            }
        }
    };
    static /* synthetic */ Class class$elgato$measurement$acp$ACPScreen;

    public ACPMenuMgr(MeasurementScreen measurementScreen, ACPMeasurementSettings aCPMeasurementSettings, ACPAnalyzer aCPAnalyzer) {
        super(measurementScreen);
        this.settings = aCPMeasurementSettings;
        this.analyzer = aCPAnalyzer;
        this.createMiscButtons();
    }

    protected abstract MenuItem createSetupButton();

    protected abstract MenuButton createACPFormatButton();

    protected abstract MenuButton createFreqChanMenuButton();

    protected Menu buildLeftMenu() {
        this.averageSweepMenu = this.createAverageSweepButton(ACPMeasurementSettings.instance().getNumAverages(), ACPMeasurementSettings.instance().getAveraging());
        Menu menu = new Menu(Text.Chan_Pwr_slash_ACP, new MenuItem[]{this.createFreqChanMenuButton(), this.createLevelMenuButton(), this.createACPFormatButton(), null, this.averageSweepMenu, this.createSetupButton()});
        this.configureFormatButtons(ACPMeasurementSettings.instance().getFormatType());
        return menu;
    }

    private void createMiscButtons() {
        this.chanStdButton = this.createChanStandButton();
        this.formatListButton = this.createFormatListButton();
        this.channelBWTimeButton = this.createChannelBWTimeButton();
        this.ctrToAdjStepSizeButton = this.createCtrToAdjStepSizeButton();
        this.adjToAdjStepSizeButton = this.createAdjToAdjStepSizeButton();
        this.numAdjChanButton = this.createNumAdjacentChannelsButton();
    }

    protected MultiStateActuatorButton createFormatTypeButton() {
        return new MultiStateActuatorButton(ACPMeasurementSettings.instance().getFormatType(), this.getContextString("formatBW.formatType"), "ACPScreen.formatTypeButton");
    }

    private MenuItem createNumAdjacentChannelsButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getAdjChanCount(), this.getContextString("adjacent.channel.count"), "ACPScreen.adjChanCount");
    }

    private MenuItem createCtrToAdjStepSizeButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getAdjChannelOffset(), this.getContextString("center.adjacent.step.size"), "ACPScreen.ctrToAdjStepSize");
    }

    private MenuItem createAdjToAdjStepSizeButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getAdjChanStep(), this.getContextString("center.adjacent.step.size"), "ACPScreen.adjToAdjStepSize");
    }

    private MenuItem createChannelBWTimeButton() {
        this.adjChanMeasTimeButton = this.createAdjChanMeasTimeButton();
        this.centerChanMeasTimeButton = this.createCenterChanMeasTimeButton();
        this.adjChanBandWidthButton = this.createAdjChanMeasBWButton();
        this.centerChanBandwidthButton = this.createCenterChanMeasBWButton();
        this.freqErrButton = new MultiStateActuatorButton(ACPMeasurementSettings.instance().getFrequencyError(), this.getContextString("acp.freqErr"), "ACPScreen.freqErrButton");
        SubMenuButton subMenuButton = new SubMenuButton(Text.Channel_n_BW_slash_Time_slash_Freq_Err, this.getContextString("channel.bw.time"), new Menu(Text.BW_slash_Time, new MenuItem[]{this.centerChanBandwidthButton, this.centerChanMeasTimeButton, this.adjChanBandWidthButton, this.adjChanMeasTimeButton, null, this.freqErrButton}), true);
        subMenuButton.getMenu().getItems()[6].setText(Text.Back);
        return subMenuButton;
    }

    private MenuItem createAdjChanMeasTimeButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getAdjMeasTime(), this.getContextString("adjacent.channel.meastime"), "ACPScreen.adjChanMeasTime");
    }

    private MenuItem createAdjChanMeasBWButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getAdjChanWidth(), this.getContextString("adjacent.channel.bandwidth"), "ACPScreen.adjChanMeasBW");
    }

    private MenuItem createCenterChanMeasTimeButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getPriMeasTime(), this.getContextString("center.channel.meastime"), "ACPScreen.ctrChanMeasTime");
    }

    private MenuItem createCenterChanMeasBWButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getPriChanWidth(), this.getContextString("center.channel.bandwidth"), "ACPScreen.ctrChanMeasBW");
    }

    ListActuatorButton createFormatListButton() {
        ListActuatorButton listActuatorButton = new ListActuatorButton(ACPMeasurementSettings.instance().getFormatList(), this.getContextString("formatBW.formatType.list"), "ACPScreen.formatListButton");
        listActuatorButton.addItemSelectionListener(this.createFormatButtonListener());
        return listActuatorButton;
    }

    ItemSelectionListener createFormatButtonListener() {
        return new ItemSelectionListener(){

            public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
                ACPFormat aCPFormat = (ACPFormat)itemSelectionEvent.getValue();
                ACPMenuMgr.this.setChannelStandard(aCPFormat);
            }
        };
    }

    private void configureFormatButtons(ValueInterface valueInterface) {
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        if (valueInterface.intValue() == 0) {
            this.chanStdButton.setEnabled(true);
            this.formatListButton.setEnabled(false);
            this.ctrToAdjStepSizeButton.setEnabled(false);
            this.adjToAdjStepSizeButton.setEnabled(false);
            this.numAdjChanButton.setEnabled(false);
            this.adjChanMeasTimeButton.setEnabled(false);
            this.centerChanMeasTimeButton.setEnabled(false);
            this.adjChanBandWidthButton.setEnabled(false);
            this.centerChanBandwidthButton.setEnabled(false);
            this.freqErrButton.setEnabled(false);
            this.resetFormat();
        } else if (valueInterface.intValue() == 1) {
            this.chanStdButton.setEnabled(false);
            this.formatListButton.setEnabled(true);
            this.ctrToAdjStepSizeButton.setEnabled(false);
            this.adjToAdjStepSizeButton.setEnabled(false);
            this.numAdjChanButton.setEnabled(false);
            this.adjChanMeasTimeButton.setEnabled(false);
            this.centerChanMeasTimeButton.setEnabled(false);
            this.adjChanBandWidthButton.setEnabled(false);
            this.centerChanBandwidthButton.setEnabled(false);
            this.freqErrButton.setEnabled(false);
            ACPFormat aCPFormat = (ACPFormat)aCPMeasurementSettings.getFormatList().getSelectedValue();
            this.setChannelStandard(aCPFormat);
        } else if (valueInterface.intValue() == 2) {
            this.chanStdButton.setEnabled(false);
            this.formatListButton.setEnabled(false);
            this.ctrToAdjStepSizeButton.setEnabled(true);
            this.adjToAdjStepSizeButton.setEnabled(true);
            this.numAdjChanButton.setEnabled(true);
            this.adjChanMeasTimeButton.setEnabled(true);
            this.centerChanMeasTimeButton.setEnabled(true);
            this.adjChanBandWidthButton.setEnabled(true);
            this.centerChanBandwidthButton.setEnabled(true);
            this.freqErrButton.setEnabled(true);
            aCPMeasurementSettings.getPriChanWidth().send(aCPMeasurementSettings.getCustPriChanWidth().longValue());
            aCPMeasurementSettings.getPriMeasTime().send(aCPMeasurementSettings.getCustPriMeasTime().intValue());
            aCPMeasurementSettings.getAdjChanWidth().send(aCPMeasurementSettings.getCustAdjChanWidth().longValue());
            aCPMeasurementSettings.getAdjMeasTime().send(aCPMeasurementSettings.getCustAdjMeasTime().intValue());
            aCPMeasurementSettings.getAdjChannelOffset().send(aCPMeasurementSettings.getCustAdjChannelOffset().longValue());
            aCPMeasurementSettings.getAdjChanStep().send(aCPMeasurementSettings.getCustAdjChanStep().longValue());
            aCPMeasurementSettings.getAdjChanCount().send(aCPMeasurementSettings.getCustAdjChanCount().intValue());
            aCPMeasurementSettings.getFrequencyError().send(aCPMeasurementSettings.getCustFreqError().intValue());
        }
    }

    void setAveragingAvailabe(boolean bl) {
        ActuatorSubMenuButton actuatorSubMenuButton = (ActuatorSubMenuButton)this.averageSweepMenu.getMenu().getItems()[3];
        if (bl) {
            actuatorSubMenuButton.getMenu().getItems()[1].setEnabled(true);
            actuatorSubMenuButton.getMenu().getItems()[2].setEnabled(true);
        } else {
            actuatorSubMenuButton.getMenu().getItems()[1].setEnabled(false);
            actuatorSubMenuButton.getMenu().getItems()[2].setEnabled(false);
        }
    }

    private void resetFormat() {
        int n = DisplayGlobalMeasurementSettings.instance().getChanStd().intValue();
        try {
            ACPFormat aCPFormat = Band.getBandByIndex(n).getACPFormat();
            this.setChannelStandard(aCPFormat);
            ACPMeasurementSettings.instance().getFormatList().setValue(aCPFormat.intValue());
        }
        catch (BandNotFoundException bandNotFoundException) {
            this.logger.error("Could not find band for: " + n);
        }
    }

    private void setChannelStandard(ACPFormat aCPFormat) {
        ACPMeasurementSettings.instance().getPriChanWidth().send(aCPFormat.getCenterChanBandwidth());
        ACPMeasurementSettings.instance().getPriMeasTime().send(aCPFormat.getCenterChanMeasTime());
        ACPMeasurementSettings.instance().getAdjChanWidth().send(aCPFormat.getAdjChanBandwidth());
        ACPMeasurementSettings.instance().getAdjChanWidth2().send(aCPFormat.getAdjChanBandwidth2());
        ACPMeasurementSettings.instance().getAdjChanWidth3().send(aCPFormat.getAdjChanBandwidth3());
        ACPMeasurementSettings.instance().getAdjMeasTime().send(aCPFormat.getAdjChanMeasTime());
        ACPMeasurementSettings.instance().getAdjChannelOffset().send(aCPFormat.getCenterToAdjacentStepSize());
        ACPMeasurementSettings.instance().getAdjChanStep().send(aCPFormat.getAdjacentToAdjacentStepSize());
        ACPMeasurementSettings.instance().getAdjChanStep2().send(aCPFormat.getAdjacentToAdjacentStepSize2());
        ACPMeasurementSettings.instance().getAdjChanStep3().send(aCPFormat.getAdjacentToAdjacentStepSize3());
        ACPMeasurementSettings.instance().getAdjChanFormat().send(aCPFormat.getAdjChanFormats());
        ACPMeasurementSettings.instance().getAdjChanCount().send(aCPFormat.getNumAdjacentChannels());
        ACPMeasurementSettings.instance().getFrequencyError().send(aCPFormat.isFreqError() ? 1 : 0);
        ACPMeasurementSettings.instance().decodeChannelFreqs();
        ACPMeasurementSettings.instance().decodeChannelTypes();
        ACPMeasurementSettings.instance().setLimitType();
        this.analyzer.metricRefreshListener.valueChanged(null);
        this.analyzer.chartRefreshListener.valueChanged(null);
        this.analyzer.dbWattsListener.valueChanged(null);
    }

    protected Menu createFreqChanMenu() {
        this.freqChanMenu = new Menu(Text.Freq_slash_Chan, new MenuItem[]{this.createFrequencyButton(), null, null, null, null, this.createChanStandButton(), MeasurementMenuMgr.createFreqChanUnitsButton("ACPScreen.FreqChanButton")}, 0);
        return this.freqChanMenu;
    }

    private MenuItem createChanStandButton() {
        return FrequencyChannelButtonFactory.createChanStdSelectButton(this.getContextString("chan.std"), this.getListenerBaseName());
    }

    private MenuButton createLevelMenuButton() {
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        MenuButton menuButton = new LevelButtonFactory(this.scn, this.analyzer, aCPMeasurementSettings.getRefLevel(), ACPMeasurementSettings.instance().getScaleDiv(), true).createMinimalLevelMenu();
        menuButton.addMenuItem(5, new MultiStateActuatorButton(ACPMeasurementSettings.instance().getdBmWattsUnits(), this.getContextString("units"), "ACPScreen.dBmWattsUnits"));
        menuButton.addMenuItem(6, MeasurementMenuMgr.createLossButton(DisplayGlobalMeasurementSettings.instance().getStashingInLoss(), SpectrumMeasurementSettings.instance().getRfInLoss(), DisplayGlobalMeasurementSettings.instance().getInLossToggle(), this.getContextString("rf.in.loss"), "ACPScreen.RfInLossButton"));
        return menuButton;
    }

    protected MenuItem createLimitsButton() {
        SubMenuButton subMenuButton = new SubMenuButton(Text.Limits, this.getContextString("Limits"), new Menu(Text.Limits, new MenuItem[]{this.createPowerLimitsButton(), this.createFrequencyLimitsButton(), null, null, null, null, null}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createPowerLimitsButton() {
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        SubMenuButton subMenuButton = new SubMenuButton(Text.Power_n_Limits, this.getContextString("powerLimits"), new Menu(Text.Power_n_Limits, new MenuItem[]{new MultiStateActuatorButton(aCPMeasurementSettings.getPowerLimitsToggle(), this.getContextString("powerLimits"), "ACPScreen.pwrLimToggle"), new ActuatorEditor(aCPMeasurementSettings.getCenterChanHighLimit(), this.getContextString("powerLimits"), "ACPScreen.pwrLimCtrHigh"), new ActuatorEditor(aCPMeasurementSettings.getCenterChanLowLimit(), this.getContextString("powerLimits"), "ACPScreen.pwrLimCtrLow"), new ActuatorEditor(aCPMeasurementSettings.getAdjChan1HighLimit(), this.getContextString("powerLimits"), "ACPScreen.pwrLimAdj1High"), new ActuatorEditor(aCPMeasurementSettings.getAdjChan2HighLimit(), this.getContextString("powerLimits"), "ACPScreen.pwrLimAdj2High"), new ActuatorEditor(aCPMeasurementSettings.getAdjChan3HighLimit(), this.getContextString("powerLimits"), "ACPScreen.pwrLimAdj3High")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private MenuItem createFrequencyLimitsButton() {
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        SubMenuButton subMenuButton = new SubMenuButton(Text.Freq_Error_n_Limits, this.getContextString("frequencyLimits"), new Menu(Text.Freq_Limits, new MenuItem[]{new MultiStateActuatorButton(aCPMeasurementSettings.getFrequencyLimitsToggle(), this.getContextString("frequencyLimits"), "ACPScreen.freqLimToggle"), new ActuatorEditor(aCPMeasurementSettings.getFrequencyHighLimit(), this.getContextString("frequencyLimits"), "ACPScreen.freqLimHigh"), new ActuatorEditor(aCPMeasurementSettings.getFrequencyLowLimit(), this.getContextString("frequencyLimits"), "ACPScreen.freqLimLow")}), true);
        subMenuButton.setCancelButtonTitle(Text.Back);
        return subMenuButton;
    }

    private ActuatorEditor createFrequencyButton() {
        return new ActuatorEditor(ACPMeasurementSettings.instance().getCenterFreq(), this.getContextString("frequencyChannel.cf"), "ACPScreen.cf");
    }

    protected void addValueListeners() {
        ACPMeasurementSettings.instance().getFormatType().addValueListener(this.formatTypeValueListener);
        ACPMeasurementSettings.instance().getAdjChanStep2().addValueListener(this.averagingLimitListener);
        this.chanStdListener = new ValueListener(){
            private final String listenerName = "ACPScreen.chanStdListener";

            public String getListenerName() {
                return "ACPScreen.chanStdListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                ACPMenuMgr.this.resetFormat();
            }
        };
        DisplayGlobalMeasurementSettings.instance().getChanStd().addValueListener(this.chanStdListener);
    }

    public void prolog() {
        this.setupFreqChanUnitsListener();
        this.addValueListeners();
    }

    public void cleanup() {
        this.removeValueListeners();
        super.cleanup();
    }

    protected void removeValueListeners() {
        ACPMeasurementSettings.instance().getFormatType().removeValueListener(this.formatTypeValueListener);
        ACPMeasurementSettings.instance().getAdjChanStep2().removeValueListener(this.averagingLimitListener);
        DisplayGlobalMeasurementSettings.instance().getChanStd().removeValueListener(this.chanStdListener);
    }

    protected void setupFreqChanUnitsListener() {
        this.setupFreqChanUnitsListener(this.freqChanMenu, 1);
    }

    protected String getMeasurementName() {
        return "adjChan";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

