/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.metrics.BasicMeasurementMetrics;
import elgato.infrastructure.metrics.MetricsTable;
import elgato.infrastructure.metrics.ValueSource;
import elgato.infrastructure.strategies.DecibelStrategy;
import elgato.infrastructure.strategies.FixedPointNumberFieldStrategy;
import elgato.infrastructure.strategies.FrequencyStrategy;
import elgato.infrastructure.strategies.NumberFieldStrategy;
import elgato.infrastructure.units.DbmUnitsFactory;
import elgato.infrastructure.util.Text;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.acp.Limits;
import java.awt.Color;
import java.awt.Font;

class ACPMetrics
extends BasicMeasurementMetrics {
    int adjChanType;

    public ACPMetrics(int n) {
        this.adjChanType = n;
        Font font = new Font("SansSerif", 1, 12);
        MetricsTable[] metricsTableArray = this.getMetricsTables();
        for (int i = 0; i < metricsTableArray.length; ++i) {
            MetricsTable metricsTable = metricsTableArray[i];
            metricsTable.setMetricsFont(font);
        }
    }

    protected ValueSource[][] createValueSources() {
        DecibelStrategy decibelStrategy = new DecibelStrategy(1, true);
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = new FixedPointNumberFieldStrategy(1, "dBc");
        NumberFieldStrategy numberFieldStrategy = DbmUnitsFactory.getDBToWattStrategy();
        ACPMeasurementSettings aCPMeasurementSettings = ACPMeasurementSettings.instance();
        ListActuator listActuator = aCPMeasurementSettings.getPowerLimitsToggle();
        Limits limits = new Limits(this, listActuator, aCPMeasurementSettings.getCenterChanLowLimit(), aCPMeasurementSettings.getCenterChanHighLimit());
        Limits limits2 = new Limits(this, listActuator, null, aCPMeasurementSettings.getAdjChan1HighLimit());
        Limits limits3 = new Limits(this, listActuator, null, aCPMeasurementSettings.getAdjChan2HighLimit());
        Limits limits4 = new Limits(this, listActuator, null, aCPMeasurementSettings.getAdjChan3HighLimit());
        FrequencyStrategy frequencyStrategy = FrequencyStrategy.createMillihertzFrequencyStrategy();
        ListActuator listActuator2 = aCPMeasurementSettings.getFrequencyLimitsToggle();
        Limits limits5 = new Limits(this, listActuator2, aCPMeasurementSettings.getFrequencyLowLimit(), aCPMeasurementSettings.getFrequencyHighLimit());
        limits5.setLimitMultiplier(1000);
        return new ValueSource[][]{{new LimitedArrayReadingValueSource(Text.ACP_1_Low, fixedPointNumberFieldStrategy, ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, 0, limits2), new LimitedArrayReadingValueSource(Text.ACP_2_Low, fixedPointNumberFieldStrategy, ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, 1, limits3), new LimitedArrayReadingValueSource(Text.ACP_3_Low, fixedPointNumberFieldStrategy, ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, 2, limits4)}, {new PeakOrAverageChannelPowerValueSource(decibelStrategy, false, ACPMeasurement.PRIMARY_CHANNEL_POWER, limits), new PeakOrAverageChannelPowerValueSource(numberFieldStrategy, false, ACPMeasurement.PRIMARY_CHANNEL_POWER, limits), new LimitedReadingValueSource(Text.Freq_Error, frequencyStrategy, false, ACPMeasurement.PRIMARY_CHANNEL_FREQUENCY_ERROR, limits5)}, {new LimitedArrayReadingValueSource(Text.ACP_1_High, fixedPointNumberFieldStrategy, ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, 0, limits2), new LimitedArrayReadingValueSource(Text.ACP_2_High, fixedPointNumberFieldStrategy, ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, 1, limits3), new LimitedArrayReadingValueSource(Text.ACP_3_High, fixedPointNumberFieldStrategy, ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, 2, limits4)}};
    }

    public void updateStandardFormat(int n, int n2) {
        FixedPointNumberFieldStrategy fixedPointNumberFieldStrategy = n2 == 0 ? new FixedPointNumberFieldStrategy(1, "dBc") : new DecibelStrategy(1, true);
        this.getValueSource()[0][n].setResultFormat(fixedPointNumberFieldStrategy);
        this.getValueSource()[2][n].setResultFormat(fixedPointNumberFieldStrategy);
    }

    protected int getBarLeftMargin() {
        return 3;
    }

    protected int getBarRightMargin() {
        return 2;
    }

    private class PeakOrAverageChannelPowerValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        private Limits limits;

        public PeakOrAverageChannelPowerValueSource(NumberFieldStrategy numberFieldStrategy, boolean bl, int n, Limits limits) {
            super(ACPMetrics.this, null, numberFieldStrategy, bl, n);
            this.limits = limits;
        }

        public String getLabel() {
            int n = ACPMetrics.this.getMeasurement().getIntegerReadingValue(ACPMeasurement.PEAK_POWER_MODE);
            if (n != 0) {
                return Text.Pk_Ch_Pwr;
            }
            return Text.Avg_Ch_Pwr;
        }

        public Color getValueColor() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                return this.limits.getValueColor(this.getRawValue());
            }
            return super.getValueColor();
        }

        public Color getInvalidColor() {
            return Limits.gray;
        }

        public String toTabDelimitedString() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append(this.getLabel()).append(" in ").append(this.getFormattedUnits()).append('\t').append(this.getFormattedValue()).append('\t').append(this.getFormattedUnits());
                return stringBuffer.toString() + this.limits.getPassFailString(this.getRawValue());
            }
            return super.toTabDelimitedString();
        }
    }

    public class LimitedArrayReadingValueSource
    extends ArrayReadingValueSource {
        private Limits limits;

        public LimitedArrayReadingValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n, int n2, Limits limits) {
            super(string, numberFieldStrategy, n, n2);
            this.limits = limits;
        }

        public Color getValueColor() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                return this.limits.getValueColor(this.getRawValue());
            }
            return super.getValueColor();
        }

        public Color getInvalidColor() {
            return Limits.gray;
        }

        public String toTabDelimitedString() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                return super.toTabDelimitedString() + this.limits.getPassFailString(this.getRawValue());
            }
            return super.toTabDelimitedString();
        }

        public Limits getLimits() {
            return this.limits;
        }
    }

    public class LimitedReadingValueSource
    extends BasicMeasurementMetrics.ReadingValueSource {
        private Limits limits;

        public LimitedReadingValueSource(String string, NumberFieldStrategy numberFieldStrategy, boolean bl, int n, Limits limits) {
            super(ACPMetrics.this, string, numberFieldStrategy, bl, n);
            this.limits = limits;
        }

        public Color getValueColor() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                return this.limits.getValueColor(this.getRawValue());
            }
            return super.getValueColor();
        }

        public Color getInvalidColor() {
            return Limits.gray;
        }

        public String toTabDelimitedString() {
            if (this.isMeasurementValid() && this.isValueValid()) {
                return super.toTabDelimitedString() + this.limits.getPassFailString(this.getRawValue());
            }
            return "";
        }

        public boolean isValueValid() {
            if (ACPMeasurementSettings.instance().getFrequencyError().intValue() == 0) {
                return false;
            }
            return super.isValueValid();
        }

        protected String getFormattedUnits() {
            if (this.isValueValid()) {
                return super.getFormattedUnits();
            }
            return "";
        }

        protected String getFormattedValue() {
            if (this.isValueValid()) {
                return super.getFormattedValue();
            }
            return "";
        }

        public String getLabel() {
            if (this.isValueValid()) {
                return super.getLabel();
            }
            return "";
        }
    }

    public class ArrayReadingValueSource
    extends ValueSource {
        private final int arrayReadingId;
        private final int arrayIndex;

        public ArrayReadingValueSource(String string, NumberFieldStrategy numberFieldStrategy, int n, int n2) {
            super(string, numberFieldStrategy, false);
            this.arrayReadingId = n;
            this.arrayIndex = n2;
        }

        protected long getRawValue() {
            return ACPMetrics.this.getMeasurement().getIntegerArrayReadingValue(this.arrayReadingId, this.arrayIndex);
        }
    }
}

