/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.mainScreens.MeasurementScreen;
import elgato.infrastructure.mainScreens.ProductFactory;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.measurement.acp.ACPAnalyzer;
import elgato.measurement.acp.ACPMeasurement;
import elgato.measurement.acp.ACPMeasurementSettings;
import elgato.measurement.acp.ACPMenuMgr;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;

public class ACPScreen
extends MeasurementScreen {
    private final Logger logger = LogManager.getLogger(class$elgato$measurement$acp$ACPScreen == null ? (class$elgato$measurement$acp$ACPScreen = ACPScreen.class$("elgato.measurement.acp.ACPScreen")) : class$elgato$measurement$acp$ACPScreen);
    ACPAnalyzer analyzer;
    ACPMenuMgr menuMgr;
    private final ACPMeasurementSettings settings = ACPMeasurementSettings.instance();
    static /* synthetic */ Class class$elgato$measurement$acp$ACPScreen;
    static /* synthetic */ Class class$elgato$measurement$acp$ACPMeasurement;

    protected Menu buildLeftMenu() {
        return this.menuMgr.buildLeftMenu();
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        this.menuMgr.prolog();
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        this.analyzer = null;
        this.menuMgr.cleanup();
    }

    protected ACPMenuMgr createMenuMgr() {
        this.menuMgr = ProductFactory.getInstance().createACPMenuMgr(this, this.settings, this.analyzer);
        return this.menuMgr;
    }

    protected Command[] getInitialGetCommands() {
        return new Command[0];
    }

    protected String getMeasurementName() {
        return "adjChan";
    }

    protected void setupAnalyzer() {
        this.analyzer = new ACPAnalyzer();
        this.createMenuMgr();
    }

    protected Component getAnalyzerPanel() {
        return this.analyzer;
    }

    protected Class getMeasurementClass() {
        return class$elgato$measurement$acp$ACPMeasurement == null ? (class$elgato$measurement$acp$ACPMeasurement = ACPScreen.class$("elgato.measurement.acp.ACPMeasurement")) : class$elgato$measurement$acp$ACPMeasurement;
    }

    protected void refreshMeasurementSettings() {
        ACPMeasurementSettings.instance().refresh();
    }

    public Image filterPrintImage(Image image, Rectangle rectangle) {
        return this.analyzer.filterPrintImage(image, rectangle);
    }

    public String getTestResults(ScreenManager screenManager, String string) {
        ACPMeasurement aCPMeasurement = (ACPMeasurement)this.getAnalyzer().getMeasurement();
        if (aCPMeasurement == null) {
            this.displayErrorMessageScreen(screenManager);
            return "";
        }
        double d = aCPMeasurement.getIntegerArrayReadingValue(ACPMeasurement.LOW_ADJACENT_CHANNEL_POWERS, 0);
        double d2 = (double)ACPMeasurementSettings.instance().getAdjChan1HighLimit().intValue() / 1000.0;
        int n = ACPMeasurementSettings.instance().getAdjChannelOffset().intValue() / 1000;
        string = "TX ACP Lower at -" + n + " kHz";
        String string2 = MeasurementScreen.createResultLine(d, d2, Double.NEGATIVE_INFINITY, string, "dBc");
        d = aCPMeasurement.getIntegerArrayReadingValue(ACPMeasurement.HIGH_ADJACENT_CHANNEL_POWERS, 0);
        string = "TX ACP Upper at +" + n + " kHz";
        string2 = string2 + MeasurementScreen.createResultLine(d, d2, Double.NEGATIVE_INFINITY, string, "dBc");
        return string2;
    }

    protected String limitValues() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

