/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.acp;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.measurement.acp.ACPMetrics;
import java.awt.Color;

class Limits {
    static final Color darkGreen = new Color(0, 160, 0);
    static final Color darkRed = new Color(255, 40, 32);
    static final Color darkBlue = new Color(20, 20, 160);
    static final Color gray = new Color(160, 160, 160);
    private final ListActuator limitsEnabled;
    private final LongActuator lowLimit;
    private final LongActuator highLimit;
    private final ACPMetrics acpMetrics;
    private int readingIdLimitsAreRelativeTo = -1;
    private int limitMultiplier = 1;

    public Limits(ACPMetrics aCPMetrics, ListActuator listActuator, LongActuator longActuator, LongActuator longActuator2) {
        this.acpMetrics = aCPMetrics;
        this.limitsEnabled = listActuator;
        this.lowLimit = longActuator;
        this.highLimit = longActuator2;
    }

    public void setReadingIdLimitsAreRelativeTo(int n) {
        this.readingIdLimitsAreRelativeTo = n;
    }

    public void setLimitMultiplier(int n) {
        this.limitMultiplier = n;
    }

    public Color getValueColor(long l) {
        if (this.isLimitsEnabled()) {
            if (this.passes(l)) {
                return darkGreen;
            }
            return darkRed;
        }
        return darkBlue;
    }

    public String getPassFailString(long l) {
        if (this.isLimitsEnabled()) {
            if (this.passes(l)) {
                return "\tP";
            }
            return "\tF";
        }
        return "";
    }

    private boolean passes(long l) {
        if (this.lowLimit != null && l < this.convertLimit(this.lowLimit.longValue())) {
            return false;
        }
        return this.highLimit == null || l <= this.convertLimit(this.highLimit.longValue());
    }

    private long convertLimit(long l) {
        long l2 = l;
        l2 *= (long)this.limitMultiplier;
        if (this.readingIdLimitsAreRelativeTo >= 0) {
            l2 += (long)this.acpMetrics.getMeasurement().getIntegerReadingValue(this.readingIdLimitsAreRelativeTo);
        }
        return l2;
    }

    public boolean isLimitsEnabled() {
        return this.limitsEnabled.booleanValue();
    }
}

