/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.measurement.backhaul.AutoConfSettingsModel;
import elgato.measurement.backhaul.PanelProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class AutoConfPanel
extends JPanel
implements AutoConfSettingsModel.ModelChangeListener {
    private ELabel[] values;
    AutoConfSettingsModel autoConfSettingsModel;

    public AutoConfPanel(AutoConfSettingsModel autoConfSettingsModel) {
        super(new BorderLayout());
        this.autoConfSettingsModel = autoConfSettingsModel;
        ListActuator[] listActuatorArray = autoConfSettingsModel.getSettings();
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridLayout(5, 2));
        jPanel2.setBackground(null);
        ELabel eLabel = new ELabel("Auto Configuration Results", Color.white, PanelProperties.TITLE_FONT, 2, 0);
        jPanel.add((Component)eLabel, "North");
        jPanel.add((Component)new Glue(1, PanelProperties.RULE_SIZE, PanelProperties.RULE_COLOR), "Center");
        jPanel2.add(new Glue(0, 5, null));
        jPanel2.add(new Glue(0, 5, null));
        this.values = new ELabel[listActuatorArray.length];
        for (int i = 0; i < listActuatorArray.length; ++i) {
            ListActuator listActuator = listActuatorArray[i];
            this.values[i] = new ELabel("--------", Color.white, PanelProperties.SUMMARY_FONT);
            jPanel2.add(new ELabel(listActuator.getLabel(), Color.white, PanelProperties.SUMMARY_FONT));
            jPanel2.add(this.values[i]);
        }
        jPanel2.add(new Glue(0, 35, null));
        jPanel2.add(new Glue(0, 35, null));
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)new BorderWrapper(jPanel, PanelProperties.MEASUREMENT_PANEL_BORDER, true), "Center");
    }

    protected ELabel[] getValues() {
        return this.values;
    }

    public void addNotify() {
        this.autoConfSettingsModel.addListener(this);
        super.addNotify();
    }

    public void removeNotify() {
        this.autoConfSettingsModel.removeListener();
        super.removeNotify();
    }

    public void modelChanged(AutoConfSettingsModel autoConfSettingsModel) {
        String[] stringArray = autoConfSettingsModel.getStringValues();
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setChunk(0, UIHelper.stripNewlines(autoConfSettingsModel.getSettings()[i].toString()));
        }
    }
}

