/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.CommandListener;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.KeyValuePair;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;

public class AutoConfSettingsModel
implements CommandListener {
    static String NOT_CHANGED = "--------";
    private ListActuator codingFormat;
    private ListActuator framingFormat;
    private ListActuator testPattern;
    protected ListActuator autoConfig;
    private ListActuator[] actuators;
    private String[] values = new String[4];
    private ModelChangeListener listener;
    private CommonBackhaulMeasurementSettings settings;

    public AutoConfSettingsModel(CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        this.codingFormat = commonBackhaulMeasurementSettings.getLineCode();
        this.framingFormat = commonBackhaulMeasurementSettings.getFraming();
        this.testPattern = commonBackhaulMeasurementSettings.getTestPattern();
        this.autoConfig = commonBackhaulMeasurementSettings.getAutoConfig();
        this.settings = commonBackhaulMeasurementSettings;
        this.actuators = new ListActuator[]{this.codingFormat, this.framingFormat, this.testPattern, this.autoConfig};
        this.copySettingsToValuesArray();
    }

    public void startAutoConfig() {
        MeasurementFactory.instance().getCommandProcessor().addSetCommandListener(this.settings.getTopic(), this);
        this.autoConfig.send(1);
    }

    public String[] getStringValues() {
        return this.values;
    }

    public void commandReceived(final Command command) {
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                boolean bl = false;
                KeyValuePair[] keyValuePairArray = command.getProperties();
                for (int i = 0; i < keyValuePairArray.length; ++i) {
                    KeyValuePair keyValuePair = keyValuePairArray[i];
                    if (!AutoConfSettingsModel.this.isPropertyForModel(keyValuePair)) continue;
                    AutoConfSettingsModel.this.getSetting(keyValuePair.getKey()).setValue(Integer.parseInt(keyValuePair.getValue()));
                    bl = true;
                }
                if (bl) {
                    MeasurementFactory.instance().getCommandProcessor().removeSetCommandListener(AutoConfSettingsModel.this.settings.getTopic(), AutoConfSettingsModel.this);
                    AutoConfSettingsModel.this.copySettingsToValuesArray();
                    if (command.getProperty("topic").equals("t1Analyzer")) {
                        AutoConfSettingsModel.this.handleT1quirks();
                    }
                    AutoConfSettingsModel.this.fireModelChangedEvent();
                }
            }
        }, this.getClass().getName());
    }

    private void handleT1quirks() {
        if (this.testPattern.intValue() == 12 && this.codingFormat.intValue() != 1) {
            this.values[0] = this.codingFormat.getValueList()[2].getLabel();
        }
    }

    private void copySettingsToValuesArray() {
        for (int i = 0; i < this.actuators.length; ++i) {
            this.values[i] = this.settings.pulses() ? UIHelper.stripNewlines(this.actuators[i].toString()) : NOT_CHANGED;
        }
    }

    private boolean isPropertyForModel(KeyValuePair keyValuePair) {
        return keyValuePair.getKey().equals(this.codingFormat.getPropertyName()) || keyValuePair.getKey().equals(this.framingFormat.getPropertyName()) || keyValuePair.getKey().equals(this.testPattern.getPropertyName()) || keyValuePair.getKey().equals(this.autoConfig.getPropertyName());
    }

    private ListActuator getSetting(String string) {
        for (int i = 0; i < this.actuators.length; ++i) {
            if (!this.actuators[i].getPropertyName().equals(string)) continue;
            return this.actuators[i];
        }
        throw new IllegalStateException("setting not found for key: " + string);
    }

    public void addListener(ModelChangeListener modelChangeListener) {
        this.listener = modelChangeListener;
    }

    public void removeListener() {
        this.listener = null;
    }

    private void fireModelChangedEvent() {
        if (this.listener != null) {
            this.listener.modelChanged(this);
        }
    }

    public String getCodingFormat() {
        return this.values[0];
    }

    public String getFramingFormat() {
        return this.values[1];
    }

    public String getTestPattern() {
        return this.values[2];
    }

    public ListActuator[] getSettings() {
        return new ListActuator[]{this.codingFormat, this.framingFormat, this.testPattern};
    }

    public static interface ModelChangeListener {
        public void modelChanged(AutoConfSettingsModel var1);
    }
}

