/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.mainScreens.DefaultProgressIndicator;
import elgato.infrastructure.mainScreens.SaveDataUnsupportedException;
import elgato.infrastructure.mainScreens.Saveable;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.readings.DoubleReadingField;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.ProgressIndicator;
import elgato.measurement.backhaul.AlarmsPanel;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.DelayPanel;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.ResultPanel;
import elgato.measurement.backhaul.StatusPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class BackhaulAnalyzer
extends JPanel
implements MeasurementListener,
Analyzer,
Saveable {
    static String INVALID_STATE = "----------";
    protected Container alarmsAndResultsPanel;
    protected Container alarmsFrame;
    private final JPanel t1ModeTitle;
    private Container statusFrame;
    protected Component resultsPanelComponent;
    private ProgressIndicator progressIndicator;
    private CardLayout cardLayout;
    static final String MAIN_PANEL = "main";
    static final String PROGRESS_PANEL = "progress";
    private ResultPanel currentResultsPanel;
    private Vector resultPanels;
    protected ELabel[] frameELabels;
    protected IntegerReadingField delayUnitIntervals;
    protected DoubleReadingField delayMicroseconds;
    protected DoubleReadingField delayKiloFeet;
    protected DoubleReadingField delayMiles;
    protected DoubleReadingField delayKilometers;
    protected IntegerReadingField primaryRecieverLevelDbdsx;
    protected IntegerReadingField primaryReceiverLevelVpp;
    protected IntegerReadingField primaryFrequency;
    protected ReadingField primaryElapsedTime;
    protected CommonBackhaulMeasurementSettings settings;
    protected ReadingField[] primaryFrequencyFields;
    protected String listenerBaseName;
    private ValueListener slipRefListener = new ValueListener(){
        private String listenerName = ".slipRefListener";
        private String backhaulClass = null;

        public String getListenerName() {
            if (this.backhaulClass == null) {
                this.backhaulClass = BackhaulAnalyzer.this.getListenerBaseName();
                this.listenerName = this.backhaulClass + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            for (int i = 0; i < BackhaulAnalyzer.this.frameELabels.length; ++i) {
                BackhaulAnalyzer.this.frameELabels[i].setChunkColor(0, this.getColor(valueInterface));
            }
        }

        private Color getColor(ValueInterface valueInterface) {
            if (valueInterface.intValue() == 0) {
                return Color.gray;
            }
            return Color.white;
        }
    };
    private StatusPanel currentStatusPanel;
    protected DelayPanel delayModePanel;

    public BackhaulAnalyzer(CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        this.init();
        this.settings = commonBackhaulMeasurementSettings;
        this.setBackground(PanelProperties.BG_COLOR);
        this.cardLayout = this.createCardLayout();
        this.setLayout(this.cardLayout);
        JPanel jPanel = new JPanel();
        TableLayout tableLayout = new TableLayout(new float[][]{{-1.0f}, {-2.0f, -1.0f, 200.0f}});
        jPanel.setLayout(tableLayout);
        this.t1ModeTitle = this.getModeTitle();
        jPanel.add((Component)this.t1ModeTitle, "0, 0");
        this.statusFrame = new JPanel(new BorderLayout());
        this.statusFrame.setBackground(null);
        this.setStatusPrimaryLine();
        jPanel.add((Component)this.statusFrame, "0, 1");
        this.alarmsAndResultsPanel = this.createAlarmsAndResultsPanel();
        ResultPanel[] resultPanelArray = this.getResultPanels();
        this.resultPanels = new Vector(resultPanelArray.length);
        for (int i = 0; i < resultPanelArray.length; ++i) {
            ResultPanel resultPanel = resultPanelArray[i];
            this.resultPanels.addElement(resultPanel);
        }
        this.updateResultsSubPanel();
        jPanel.add((Component)this.alarmsAndResultsPanel, "0, 2");
        this.add((Component)jPanel, MAIN_PANEL);
        this.progressIndicator = new DefaultProgressIndicator(Text.MEASUREMENT_LOADING);
        this.add((Component)((Object)this.progressIndicator), PROGRESS_PANEL);
        this.progressIndicator.start();
        this.cardLayout.show(this, PROGRESS_PANEL);
        commonBackhaulMeasurementSettings.getSlipRef().addValueListener(this.slipRefListener);
        this.slipRefListener.valueChanged(commonBackhaulMeasurementSettings.getSlipRef());
    }

    public void dispose() {
        this.settings.getSlipRef().removeValueListener(this.slipRefListener);
        this.slipRefListener = null;
        if (this.progressIndicator != null) {
            ((DefaultProgressIndicator)this.progressIndicator).stop();
            ((DefaultProgressIndicator)this.progressIndicator).removeAllListeners();
            this.progressIndicator = null;
        }
    }

    public String getListenerBaseName() {
        if (this.listenerBaseName == null) {
            this.listenerBaseName = this.getClass().getName();
            int n = this.listenerBaseName.lastIndexOf(".");
            if (n > -1) {
                try {
                    this.listenerBaseName = this.listenerBaseName.substring(n + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.listenerBaseName;
    }

    protected CardLayout createCardLayout() {
        return new CardLayout();
    }

    public void setResultAndAlarmsPanel(Component component) {
        this.alarmsAndResultsPanel.removeAll();
        this.alarmsAndResultsPanel.add(component);
        this.validate();
        this.repaint();
    }

    private JComponent createAlarmsAndResultsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(null);
        this.alarmsFrame = new JPanel(new BorderLayout());
        this.alarmsFrame.setBackground(null);
        this.setAlarmsPrimaryLine();
        jPanel.add((Component)this.alarmsFrame, "West");
        return jPanel;
    }

    public void restoreAlarmsAndResultsPanel() {
        this.alarmsAndResultsPanel.removeAll();
        this.alarmsAndResultsPanel.add((Component)this.alarmsFrame, "West");
        this.alarmsAndResultsPanel.add(this.resultsPanelComponent, "Center");
        this.validate();
        this.repaint();
    }

    void setAlarmsPrimaryLine() {
        this.swapOutComponent(this.getPrimaryAlarmsPanel().createComponent(), this.alarmsFrame);
    }

    void setAlarmsSecondaryLine() {
        this.swapOutComponent(this.getSecondaryAlarmsPanel().createComponent(), this.alarmsFrame);
    }

    void setStatusPrimaryLine() {
        this.setStatusPanel(this.createStatusPanel(true, false));
    }

    void setStatusSecondaryLine() {
        this.setStatusPanel(this.createStatusPanel(false, true));
    }

    void setStatusLineBoth() {
        this.setStatusPanel(this.createStatusPanel(true, true));
    }

    public void addNotify() {
        super.addNotify();
        this.updateResultsSubPanel();
    }

    private void setStatusPanel(StatusPanel statusPanel) {
        this.swapOutComponent(statusPanel.createComponent(), this.statusFrame);
        this.currentStatusPanel = statusPanel;
    }

    private void swapOutComponent(Component component, Container container) {
        if (container.getComponentCount() > 0) {
            container.remove(0);
        }
        container.add(component);
        container.validate();
        this.repaint();
    }

    private void updateResultsSubPanel() {
        this.setResultsPanel(this.getCurrentResultPanel());
    }

    protected ResultPanel getCurrentResultPanel() {
        return this.getResultsPanel(this.getCommonSettings().getResultPanel().intValue());
    }

    protected abstract CommonBackhaulMeasurementSettings getCommonSettings();

    public void setResultsPanel(int n) {
        this.setResultsPanel(this.getResultsPanel(n));
    }

    public ResultPanel getResultsPanel(int n) {
        for (int i = 0; i < this.resultPanels.size(); ++i) {
            ResultPanel resultPanel = (ResultPanel)this.resultPanels.elementAt(i);
            if (resultPanel.getResultKey() != n) continue;
            return resultPanel;
        }
        throw new RuntimeException("Unknown result panel key: " + n);
    }

    public void setResultsPanel(ResultPanel resultPanel) {
        this.currentResultsPanel = resultPanel;
        Component component = this.getResultSubPanelComponent(resultPanel);
        if (this.resultsPanelComponent != null) {
            this.alarmsAndResultsPanel.remove(this.resultsPanelComponent);
        }
        this.alarmsAndResultsPanel.add(component, "Center");
        this.resultsPanelComponent = component;
        this.validate();
        this.repaint();
    }

    ResultPanel getResultPanel(String string) {
        return this.getResultPanels()[this.getIndexOfResultPanel(string)];
    }

    int getIndexOfResultPanel(String string) {
        for (int i = 0; i < this.getResultPanels().length; ++i) {
            if (!this.getResultPanels()[i].getPanelName().equals(string)) continue;
            return i;
        }
        throw new IllegalStateException("Panel title not found with title " + string);
    }

    public JPanel getT1ModeTitle() {
        return this.t1ModeTitle;
    }

    ReadingField[] getCurrentReadingFields() {
        return this.currentResultsPanel.getReadingFields();
    }

    protected TabDelimitable[] getSavableFields() {
        AlarmsPanel alarmsPanel = this.settings.getAlarms().getSelectedValue().intValue() == 0 ? this.getPrimaryAlarmsPanel() : this.getSecondaryAlarmsPanel();
        TabDelimitable[] tabDelimitableArray = alarmsPanel.getTabDelimitedFields();
        TabDelimitable[] tabDelimitableArray2 = this.currentStatusPanel.getTabDelimitedFields();
        TabDelimitable[] tabDelimitableArray3 = this.currentResultsPanel.getTabDelimitedFields();
        TabDelimitable[] tabDelimitableArray4 = new TabDelimitable[tabDelimitableArray2.length + tabDelimitableArray.length + tabDelimitableArray3.length];
        System.arraycopy(tabDelimitableArray2, 0, tabDelimitableArray4, 0, tabDelimitableArray2.length);
        System.arraycopy(tabDelimitableArray, 0, tabDelimitableArray4, tabDelimitableArray2.length, tabDelimitableArray.length);
        System.arraycopy(tabDelimitableArray3, 0, tabDelimitableArray4, tabDelimitableArray2.length + tabDelimitableArray.length, tabDelimitableArray3.length);
        return tabDelimitableArray4;
    }

    protected void showMainPanel() {
        this.cardLayout.show(this, MAIN_PANEL);
    }

    public ReadingField[] createDelayModeReadingFields() {
        ReadingField[] readingFieldArray = new ReadingField[]{this.delayUnitIntervals, this.delayMicroseconds, this.delayKiloFeet, this.delayMiles, this.delayKilometers};
        return readingFieldArray;
    }

    private void init() {
        this.initReadingFields();
        this.initAlarmsPanels();
        this.initBitRows();
        this.initResultPanels();
    }

    protected void initResultPanels() {
        this.primaryFrequencyFields = new ReadingField[]{this.primaryFrequency, this.primaryElapsedTime};
    }

    protected abstract AlarmsPanel getPrimaryAlarmsPanel();

    protected abstract AlarmsPanel getSecondaryAlarmsPanel();

    protected abstract ResultPanel[] getResultPanels();

    protected abstract Component getResultSubPanelComponent(ResultPanel var1);

    protected abstract void initAlarmsPanels();

    protected abstract void initBitRows();

    protected abstract void initReadingFields();

    protected abstract ReadingBitRow[] getStatusTextRows();

    protected abstract ReadingBitRow[] getStatusLedRows();

    public abstract Measurement getMeasurement();

    protected abstract StatusPanel createStatusPanel(boolean var1, boolean var2);

    protected abstract JPanel getModeTitle();

    public void setDelayPanel(DelayPanel delayPanel) {
        this.delayModePanel = delayPanel;
    }

    public abstract /* synthetic */ void measurementReceived(Measurement var1);

    public abstract /* synthetic */ void saveData(PrintWriter var1) throws SaveDataUnsupportedException;
}

