/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.measurement.backhaul.BackhaulAnalyzer;
import elgato.measurement.backhaul.BackhaulMeasurement;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.StatusProvider;

public class BackhaulBitRow
extends ReadingBitRow {
    private BackhaulAnalyzer backhaulAnalyzer;
    private String longLabel;
    private String setText;
    private String notSetText;

    public BackhaulBitRow(BackhaulAnalyzer backhaulAnalyzer, String string, int n, int n2, String string2, String string3) {
        super(string, n, new int[]{n2});
        this.backhaulAnalyzer = backhaulAnalyzer;
        this.setText = string2;
        this.notSetText = string3;
        this.longLabel = string;
    }

    public BackhaulBitRow(BackhaulAnalyzer backhaulAnalyzer, String string, int n, int n2, int n3, String string2, String string3) {
        super(string, n, new int[]{n2, n3});
        this.longLabel = string;
        this.setText = string2;
        this.notSetText = string3;
        this.backhaulAnalyzer = backhaulAnalyzer;
    }

    private StatusProvider createStatusProvider(final int n) {
        return new StatusProvider(){

            public boolean isEnabled() {
                return BackhaulBitRow.this.getValue(n);
            }
        };
    }

    protected boolean getValue(int n) {
        if (this.backhaulAnalyzer.getMeasurement() == null) {
            return false;
        }
        return ((BackhaulMeasurement)this.backhaulAnalyzer.getMeasurement()).getBitReadingValue(this.getReading(), n);
    }

    public StatusProvider[] getStatusProviders() {
        int[] nArray = this.getIndices();
        StatusProvider[] statusProviderArray = new StatusProvider[nArray.length];
        for (int i = 0; i < statusProviderArray.length; ++i) {
            statusProviderArray[i] = this.createStatusProvider(nArray[i]);
        }
        return statusProviderArray;
    }

    public boolean[] getValues() {
        int[] nArray = this.getIndices();
        boolean[] blArray = new boolean[nArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = this.getValue(nArray[i]);
        }
        return blArray;
    }

    public String toTabDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.longLabel).append('\t').append(this.getTextForCurrentBit());
        return stringBuffer.toString();
    }

    String getTextForCurrentBit() {
        return this.getValue(this.getIndices()[0]) ? this.setText : this.notSetText;
    }

    String getTextForHistoryBit() {
        return this.getValue(this.getIndices()[1]) ? this.setText : this.notSetText;
    }

    public void setLongLabel(String string) {
        this.longLabel = string;
    }
}

