/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.readings.BitFieldReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Text;

public abstract class BackhaulMeasurement
implements Measurement {
    public abstract Reading[] getReadings();

    public boolean getBitReadingValue(int n, int n2) {
        return ((BitFieldReading)this.getReadings()[n]).bitValue(n2);
    }

    public int getIntegerReadingValue(int n) {
        return this.getReadings()[n].intValue();
    }

    public double getDoubleReadingValue(int n) {
        return this.getReadings()[n].doubleValue();
    }

    public float getFloatReadingValue(int n) {
        return this.getReadings()[n].floatValue();
    }

    public int getIntegerArrayReadingValue(int n, int n2) {
        throw new RuntimeException("Method not implemented yet");
    }

    public long getLongReadingValue(int n) {
        throw new RuntimeException("Method not implemented yet");
    }

    public String getRomTestResult() {
        return this.getMiscellaneousIndicators().bitValue(this.getRomTestBit()) ? Text.Fail : Text.Pass;
    }

    public String getRamTestResult() {
        return this.getMiscellaneousIndicators().bitValue(this.getRamTestBit()) ? Text.Fail : Text.Pass;
    }

    public String getSelfTestResult() {
        return this.getMiscellaneousIndicators().bitValue(this.getSelfTestBit()) ? Text.Fail : Text.Pass;
    }

    public boolean hasCurrentSettings() {
        return true;
    }

    abstract BitFieldReading getMiscellaneousIndicators();

    protected abstract int getRomTestBit();

    protected abstract int getRamTestBit();

    protected abstract int getSelfTestBit();

    public abstract /* synthetic */ String getMeasurementTitle();

    public abstract /* synthetic */ void recycle();
}

