/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.commChannel.WebplugConversions;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.measurement.MeasurementSettings;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;

public abstract class CommonBackhaulMeasurementSettings
extends MeasurementSettings
implements MeasurementListener {
    public static final int VALUE_ALARM_MODE_SINGLE = 0;
    public static final int VALUE_ERROR_MODE_SINGLE = 0;
    public static final int VALUE_ALARM_MODE_CONTINUOUS = 1;
    public static final int VALUE_INJECT_STATE_ON = 1;
    public static final int VALUE_INJECT_STATE_OFF = 0;
    public static final int VALUE_LOOP_DOWN = 0;
    public static final int VALUE_LOOP_UP = 1;
    public static final int INJECT_STATE_ON = 1;
    public static final int INJECT_STATE_OFF = 0;
    public static final int STATUS_BOTH = 2;
    public static final int VALUE_RXINPUT_TERMINATE = 0;
    public static final int VALUE_RXINPUT_MONITOR = 2;
    public static final int VALUE_RXINPUT_BRIDGE = 1;
    public static final int VALUE_TX_CLOCK_INTERNAL = 0;
    public static final int VALUE_T1_TX_CLOCK_PRIMARY_RX = 1;
    public static final int VALUE_T1_TX_CLOCK_SECONDARY_RX = 2;
    public static final int DO_AUTO_CONFIG = 1;
    public static final String KEY_RESTART = "measState";
    public static final String KEY_RX_INPUT = "rxInput";
    public static final String KEY_LINE_CODE = "lineCoding";
    public static final String KEY_FRAMING = "frameFormat";
    public static final String KEY_PATTERN = "testPattern";
    public static final String KEY_TX_CLOCK = "txClockSrc";
    public static final String KEY_TX_LBO = "txOutput";
    public static final String KEY_ESF_CODE = "esfLoopCode";
    public static final String KEY_SECOND_TX = "line2TxSrc";
    public static final String KEY_SLIP_REF = "refClockSrc";
    public static final String KEY_FILL_DATA = "fillData";
    public static final String KEY_STATUS = "status";
    public static final String KEY_ALARMS = "alarms";
    public static final String KEY_RESULTS = "results";
    public static final String KEY_SETUP_MODE = "setupMode";
    public static final String KEY_ALARM_MODE = "alarmMode";
    public static final String KEY_ERROR_MODE = "errorMode";
    public static final String KEY_INJECT_STATE = "injectState";
    public static final String KEY_CHANNEL = "chanNum";
    public static final String KEY_LOOP_STATE = "loopState";
    public static final String KEY_AUTO_CONFIG = "autoConfig";
    public static final String KEY_INJECT_TYPE = "injectType";
    protected ListActuator controlMode;
    protected ListActuator testPattern;
    protected ListActuator lineCode;
    protected ListActuator framing;
    protected ListActuator injectType;
    protected ListActuator rxInput = new ListActuator(this.getTopic(), "rxInput", Text.RX_Input, new Value[]{Value.createValue(Text.Terminate, 0), Value.createValue(Text.Monitor, 2), Value.createValue(Text.Bridge, 1)});
    protected ListActuator txClock = new ListActuator(this.getTopic(), "txClockSrc", Text.TX_Clock, new Value[]{Value.createValue(Text.Internal, 0), Value.createValue(Text.Primary_RX, 1), Value.createValue(Text.Second_RX, 2)});
    protected ListActuator fillData = new ListActuator(this.getTopic(), "fillData", Text.Fill_Data, new Value[]{Value.createValue(Text.All_1s, 0), Value.createValue(Text.Idle, 1), Value.createValue(Text.Primary_RX, 2), Value.createValue(Text.Second_RX, 3)});
    protected ListActuator injectState = new ListActuator(this.getTopic(), "injectState", Text.Inject, new Value[]{Value.createValue(Text.On, 1), Value.createValue(Text.Off, 0)});
    protected ListActuator loopState;
    protected ListActuator slipRef = new ListActuator(this.getTopic(), "refClockSrc", Text.Slip_Ref, new Value[]{Value.createValue(Text.None, 0), Value.createValue(Text.Internal, 1), Value.createValue(Text.Second_RX, 2)});
    protected ListActuator secondaryTx = new ListActuator(this.getTopic(), "line2TxSrc", Text.Second_TX, new Value[]{Value.createValue(Text.AIS, 0), Value.createValue(Text.Second_RX, 2), Value.createValue(Text.Primary_RX, 1)});
    protected ListActuator autoConfig = new ListActuator(this.getTopic(), "autoConfig", "", new Value[]{Value.createValue("", 1), Value.createValue("", 0)});
    private boolean pulses = false;
    protected ListActuator resultPanel = new ListActuator(this.getTopic(), "results", Text.Results, this.getResultValues());
    public static final int VALUE_SLIP_REF_INTERNAL = 1;
    public static final int VALUE_SLIP_REF_SECONDARY = 2;
    public static final int VALUE_SLIP_REF_NONE = 0;
    private ListActuator status = new ListActuator(this.getDisplayTopic(), "status", Text.Status, new Value[]{Value.createValue("Pri", 0), Value.createValue("Sec", 1), Value.createValue("Both", 2)});
    private ListActuator alarms = new ListActuator(this.getDisplayTopic(), "alarms", Text.Alarms, new Value[]{Value.createValue("Pri", 0), Value.createValue("Sec", 1)});
    private static final String KEY_AUDIO_STATE = "audioState";
    private ListActuator audioState = new ListActuator(this.getTopic(), "audioState", Text.Sound, new Value[]{Value.createValue(Text.Off, 0), Value.createValue(Text.On, 1)});
    private LongActuator audioVolume = new LongActuator(this.getTopic(), "audioVolume", Text.Volume, 0L, new RangeValidator(1L, 10L));
    public static final int VALUE_ROM_TEST = 2;
    public static final int VALUE_RAM_TEST = 3;
    public static final int VALUE_LOOP_TEST = 4;
    public static final int STATUS_PRIMARY = 0;
    public static final int STATUS_SECONDARY = 1;

    protected CommonBackhaulMeasurementSettings(final String string) {
        super(string);
        this.add(this.fillData);
        this.add(this.rxInput);
        this.add(this.txClock);
        this.add(this.slipRef);
        this.add(this.secondaryTx);
        this.add(this.status);
        this.add(this.alarms);
        this.add(this.resultPanel);
        this.injectState.setValue(0);
        this.injectState.setWebPlugConversion(WebplugConversions.createInject(this.injectState));
        this.add(this.injectState);
        this.add(this.autoConfig);
        this.addAdditionalActuators();
        this.injectType.setWebPlugConversion(WebplugConversions.createAlarmError(this.injectType));
        this.add(this.injectType);
        this.add(this.audioState);
        this.add(this.audioVolume);
        this.controlMode.addValueListener(new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = string + ".controlModeListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                if (!CommonBackhaulMeasurementSettings.this.isChannelMode()) {
                    CommonBackhaulMeasurementSettings.this.audioState.send(0);
                }
            }
        });
        this.refresh();
    }

    public boolean newLineCodeNA(Command command, int n) {
        String string;
        return command.propertyExists(this.lineCode.getPropertyName()) && (string = command.getProperty(this.lineCode.getPropertyName())) != null && Integer.parseInt(command.getProperty(this.lineCode.getPropertyName())) == n;
    }

    public ListActuator getResultPanel() {
        return this.resultPanel;
    }

    public ListActuator getFillData() {
        return this.fillData;
    }

    public ListActuator getRxInput() {
        return this.rxInput;
    }

    public ListActuator getTxClock() {
        return this.txClock;
    }

    public ListActuator getSlipRef() {
        return this.slipRef;
    }

    public ListActuator getSecondaryTx() {
        return this.secondaryTx;
    }

    public ListActuator getStatus() {
        return this.status;
    }

    public ListActuator getAlarms() {
        return this.alarms;
    }

    public void setLoopUp() {
        this.loopState.setValue(1);
    }

    public void setLoopDown() {
        this.loopState.setValue(0);
    }

    public void setSlipRefInternal() {
        this.slipRef.setValue(1);
    }

    public void setSlipRefSecondRx() {
        this.slipRef.setValue(2);
    }

    public void setSlipRefNone() {
        this.slipRef.setValue(0);
    }

    public boolean isSlipRefNone() {
        return this.slipRef.intValue() == 0;
    }

    public ListActuator getInjectState() {
        return this.injectState;
    }

    public ListActuator getInjectType() {
        return this.injectType;
    }

    public ListActuator getAutoConfig() {
        return this.autoConfig;
    }

    public void setPulses(boolean bl) {
        this.pulses = bl;
    }

    public boolean pulses() {
        return this.pulses;
    }

    public String getDisplayTopic() {
        return "display." + this.getTopic();
    }

    public ListActuator getControlMode() {
        return this.controlMode;
    }

    public ListActuator getLineCode() {
        return this.lineCode;
    }

    public ListActuator getTestPattern() {
        return this.testPattern;
    }

    public ListActuator getFraming() {
        return this.framing;
    }

    public ListActuator getAudioState() {
        return this.audioState;
    }

    public LongActuator getAudioVolume() {
        return this.audioVolume;
    }

    protected abstract void addAdditionalActuators();

    protected abstract Value[] getResultValues();

    public abstract boolean isChannelMode();

    public abstract boolean isDelayMode();

    public abstract boolean isEmulateMode();

    public abstract boolean isLoopbackMode();

    public abstract boolean isMonitorMode();

    public abstract boolean isAlarmType(int var1);

    public abstract /* synthetic */ void measurementReceived(Measurement var1);
}

