/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.html.HTMLManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.DynamicMenuButton;
import elgato.infrastructure.menu.MeasurementMenuMgr;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuSymbol;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.AutoConfPanel;
import elgato.measurement.backhaul.AutoConfSettingsModel;
import elgato.measurement.backhaul.BackhaulAnalyzer;
import elgato.measurement.backhaul.BackhaulModeDisplay;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.CommonBackhaulScreen;
import elgato.measurement.backhaul.ControlMenuAbstractFactory;
import elgato.measurement.backhaul.DelayPanel;
import elgato.measurement.backhaul.DiagnosticsScreen;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public abstract class CommonBackhaulMenuMgr
extends MeasurementMenuMgr {
    private static final Logger logger = LogManager.getLogger(class$elgato$measurement$backhaul$CommonBackhaulMenuMgr == null ? (class$elgato$measurement$backhaul$CommonBackhaulMenuMgr = CommonBackhaulMenuMgr.class$("elgato.measurement.backhaul.CommonBackhaulMenuMgr")) : class$elgato$measurement$backhaul$CommonBackhaulMenuMgr);
    protected BackhaulAnalyzer analyzer;
    protected CommonBackhaulMeasurementSettings settings;
    protected DelayPanel delayModePanel;
    protected ControlMenuAbstractFactory menuFactory;
    protected MenuItem controlMenuButton;
    protected SimpleMenuButton autoConfigButton;
    protected MultiStateActuatorButton statusButton;
    protected MultiStateActuatorButton alarmsButton;
    protected ActuatorEditor volumeButton;
    protected MultiStateActuatorButton soundButton;
    protected ValueListener alarmLineStateListener = new AlarmsLineChangeListener();
    protected ValueListener statusStateListener = new StatusLineChangeListener();
    protected Menu savedLeftMenu;
    protected ValueListener controlModeSoundListener;
    protected ValueListener resultPanelListener = new ValueListener(){
        private String listenerName = ".resultPanelListener";
        private String backhaulClass = null;

        public String getListenerName() {
            if (this.backhaulClass == null) {
                this.backhaulClass = CommonBackhaulMenuMgr.this.getListenerBaseName();
                this.listenerName = this.backhaulClass + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            ((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getBackhaulAnalyer().setResultsPanel(valueInterface.intValue());
        }
    };
    final Menu blankMenu = new Menu("", new MenuItem[]{null, null, null, null, null, null, null});
    static /* synthetic */ Class class$elgato$measurement$backhaul$CommonBackhaulMenuMgr;

    public CommonBackhaulMenuMgr(CommonBackhaulScreen commonBackhaulScreen, CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings, BackhaulAnalyzer backhaulAnalyzer) {
        super(commonBackhaulScreen);
        this.settings = commonBackhaulMeasurementSettings;
        this.analyzer = backhaulAnalyzer;
        this.statusButton = new MultiStateActuatorButton(commonBackhaulMeasurementSettings.getStatus(), this.getContextString("status"), this.getListenerBaseName() + "statusButton");
        this.alarmsButton = new MultiStateActuatorButton(commonBackhaulMeasurementSettings.getAlarms(), this.getContextString("alarms"), this.getListenerBaseName() + "alarmsButton");
        this.volumeButton = new ActuatorEditor(commonBackhaulMeasurementSettings.getAudioVolume(), this.getContextString("primary_audio_volume"), this.getListenerBaseName() + "volumeButton");
        this.soundButton = new MultiStateActuatorButton(commonBackhaulMeasurementSettings.getAudioState(), this.getContextString("primary_audio_state"), this.getListenerBaseName() + "soundButton");
    }

    protected abstract Menu[] createDisplayMenus();

    protected abstract DynamicMenuButton.MenuSelector createMap();

    protected abstract String getLeftMenuName();

    public void prolog() {
        this.settings.getAlarms().addValueListener(this.alarmLineStateListener);
        this.settings.getStatus().addValueListener(this.statusStateListener);
        this.controlModeSoundListener = new ValueListener(){
            private final String listenerName;
            {
                this.listenerName = CommonBackhaulMenuMgr.this.getListenerBaseName() + ".controlModeSoundListener";
            }

            public String getListenerName() {
                return this.listenerName;
            }

            public void valueChanged(ValueInterface valueInterface) {
                CommonBackhaulMenuMgr.this.setButtonsBasedOnControlMode();
            }
        };
        this.addValueListeners();
        this.setButtonsBasedOnControlMode();
        this.alarmLineStateListener.valueChanged(this.settings.getAlarms());
        this.statusStateListener.valueChanged(this.settings.getStatus());
    }

    public void cleanup() {
        this.settings.getAlarms().removeValueListener(this.alarmLineStateListener);
        this.settings.getStatus().removeValueListener(this.statusStateListener);
        this.removeValueListeners();
        super.cleanup();
    }

    public void createDelayModePanel() {
        this.delayModePanel = new DelayPanel(this.analyzer.createDelayModeReadingFields(), this.settings);
        this.analyzer.setDelayPanel(this.delayModePanel);
    }

    public DelayPanel getDelayModePanel() {
        return this.delayModePanel;
    }

    private void setButtonsBasedOnControlMode() {
        if (this.settings.isChannelMode()) {
            this.soundButton.setEnabled(true);
            this.volumeButton.setEnabled(true);
        } else {
            this.soundButton.setEnabled(false);
            this.volumeButton.setEnabled(false);
        }
    }

    ActionListener createLoadBackhaulAnalyzerActionListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HTMLManager.resetCacheSession();
                CommonBackhaulMenuMgr.this.scn.getScreenManager().installDisplay(((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getAnalyzerPanel());
            }
        };
    }

    protected void addMeasurementListeners() {
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.analyzer, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.delayModePanel, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
        MeasurementFactory.instance().getMeasurementReader().addMeasurementListener(this.settings, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
    }

    protected void removeMeasurementListeners() {
        MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this.analyzer, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
        MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this.settings, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
        MeasurementFactory.instance().getMeasurementReader().removeMeasurementListener(this.delayModePanel, ((CommonBackhaulScreen)this.scn).getMeasurementClass());
    }

    PushButton createModeActionButton(String string, String string2, final int n) {
        return new PushButton(string, this.getContextString(string2), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.setControlMode(n);
                CommonBackhaulMenuMgr.this.pressGetStartedTestModeButton();
            }
        });
    }

    PushButton createT1MonitorModeActionButton(String string, String string2, final int n) {
        return new PushButton(string, this.getContextString(string2), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.setControlMode(n);
                CommonBackhaulMenuMgr.this.settings.getTxClock().send(1);
                CommonBackhaulMenuMgr.this.pressGetStartedTestModeButton();
            }
        });
    }

    private void setControlMode(int n) {
        this.settings.getControlMode().send(n);
    }

    MenuItem createGetStartedButton(String string) {
        SubMenuButtonWithDisplay subMenuButtonWithDisplay = new SubMenuButtonWithDisplay(Text.Get_Started, this.getContextString("get.started"), string, new Menu(Text.Get_Started, new MenuItem[0]));
        subMenuButtonWithDisplay.setCancelButtonTitle(Text.Back);
        return subMenuButtonWithDisplay;
    }

    private void pressGetStartedTestModeButton() {
        this.scn.pressHomeButton();
    }

    private void createAutoConfigButton() {
        SimpleMenuButton simpleMenuButton = new SimpleMenuButton(Text.Auto_Config, this.getContextString("primary_auto_config"), new Menu(Text.Auto_Config, new MenuItem[]{this.createPrimaryAutoConfigButton(), null, null, null, null, null, null}));
        simpleMenuButton.addActionListener(this.createLoadBackhaulAnalyzerActionListener());
        this.enableOrDisableAutoConfigButton(simpleMenuButton);
        this.autoConfigButton = simpleMenuButton;
    }

    protected PushButton createPrimaryAutoConfigButton() {
        final PushButton pushButton = new PushButton(Text.Back, "");
        final PushButton pushButton2 = new PushButton(Text.Restart_n_Primary_n_Auto_Config, this.getContextString("restartAutoConfig"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.loadAutoConfPanel();
            }
        });
        final PushButton pushButton3 = new PushButton(Text.Start_n_Primary_n_Auto_Config, this.getContextString("startAutoConfig"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.loadAutoConfPanel();
                CommonBackhaulMenuMgr.this.saveLeftMenu(CommonBackhaulMenuMgr.this.scn.getScreenManager().getLeftMenuPanel().getMenu());
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getLeftMenuPanel().installMenu(CommonBackhaulMenuMgr.this.blankMenu);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(pushButton2, 0);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(pushButton, 6);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaintNow();
            }
        });
        pushButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.analyzer.restoreAlarmsAndResultsPanel();
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getLeftMenuPanel().installMenu(CommonBackhaulMenuMgr.this.restoreLeftMenu());
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getLeftMenuPanel().focusButton(CommonBackhaulMenuMgr.this.autoConfigButton);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(pushButton3, 0);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().setMenuItem(null, 6);
                CommonBackhaulMenuMgr.this.scn.getScreenManager().getRightMenuPanel().repaintNow();
            }
        });
        return pushButton3;
    }

    private void saveLeftMenu(Menu menu) {
        if (menu != this.blankMenu) {
            this.savedLeftMenu = menu;
        }
    }

    private Menu restoreLeftMenu() {
        return this.savedLeftMenu;
    }

    private void loadAutoConfPanel() {
        AutoConfSettingsModel autoConfSettingsModel = new AutoConfSettingsModel(this.settings);
        ((BackhaulAnalyzer)((CommonBackhaulScreen)this.scn).getAnalyzer()).setResultAndAlarmsPanel(new AutoConfPanel(autoConfSettingsModel));
        autoConfSettingsModel.startAutoConfig();
    }

    public MenuItem createRestartButton() {
        return new PushButton(Text.Restart, this.getContextString("restart"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Command command = Command.makeSetCommand(((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getTopic());
                command.addProperty("measState", 2L);
                MeasurementFactory.instance().getCommandProcessor().send(command);
            }
        });
    }

    protected void enableOrDisableAutoConfigButton(SimpleMenuButton simpleMenuButton) {
        simpleMenuButton.setEnabled(this.autoConfigValid());
    }

    protected boolean autoConfigValid() {
        return true;
    }

    protected SimpleMenuButton getAutoConfigButton() {
        if (this.autoConfigButton == null) {
            this.createAutoConfigButton();
        }
        return this.autoConfigButton;
    }

    MenuButton createDisplayButton() {
        DynamicMenuButton.MenuSelector menuSelector = this.createMap();
        DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(Text.Display_n_Sound, this.getContextString("display"), this.createDisplayMenus(), menuSelector);
        dynamicMenuButton.addActionListener(this.createLoadBackhaulAnalyzerActionListener());
        return dynamicMenuButton;
    }

    MultiStateActuatorButton getStatusButton() {
        return this.statusButton;
    }

    MultiStateActuatorButton getAlarmsButton() {
        return this.alarmsButton;
    }

    MenuItem createSetupButton() {
        return new SetupButton();
    }

    protected void addValueListeners() {
        this.settings.getControlMode().addValueListener(this.controlModeSoundListener);
        this.settings.getResultPanel().addValueListener(this.resultPanelListener);
    }

    public void removeValueListeners() {
        this.settings.getControlMode().removeValueListener(this.controlModeSoundListener);
        this.settings.getResultPanel().removeValueListener(this.resultPanelListener);
    }

    protected MenuItem createTestsButton() {
        return new SimpleMenuButton(Text.Tests, this.getContextString("T1.Tests"), new Menu(Text.Tests, new MenuItem[]{null, this.createVerificationButton()}));
    }

    protected PushButton createVerificationButton() {
        return new PushButton(Text.Verification, this.getContextString("VerificaionTest"), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CommonBackhaulMenuMgr.this.scn.getScreenManager().pushScreen(new DiagnosticsScreen(CommonBackhaulMenuMgr.this.getLeftMenuName(), ((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getMeasurementClass()));
            }
        });
    }

    public MenuItem createResultsButton() {
        return new ListActuatorButton(this.settings.getResultPanel(), this.getContextString("backhaul.results"), this.getListenerBaseName() + ".resultsButton");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ Screen access$2500(CommonBackhaulMenuMgr commonBackhaulMenuMgr) {
        return commonBackhaulMenuMgr.scn;
    }

    static /* synthetic */ Screen access$2600(CommonBackhaulMenuMgr commonBackhaulMenuMgr) {
        return commonBackhaulMenuMgr.scn;
    }

    public class SetupButton
    extends ActionButton {
        public SetupButton() {
            super(Text.Setup, CommonBackhaulMenuMgr.this.getContextString("setup"));
            this.addActionListener(new ActionListener(this, CommonBackhaulMenuMgr.this){
                private final /* synthetic */ CommonBackhaulMenuMgr val$this$0;
                private final /* synthetic */ SetupButton this$1;
                {
                    this.this$1 = setupButton;
                    this.val$this$0 = commonBackhaulMenuMgr;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((CommonBackhaulScreen)CommonBackhaulMenuMgr.access$2600(SetupButton.access$2400(this.this$1))).getSetupScreen().installSetupScreen(CommonBackhaulMenuMgr.access$2500(SetupButton.access$2400(this.this$1)).getScreenManager());
                    this.this$1.getMenuPanel().focusButton(this.this$1);
                    this.this$1.repaintNow();
                }
            });
        }

        public void setFocused(boolean bl) {
            super.setFocused(bl);
            if (!this.isFocused() && ((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getSetupScreen() != null) {
                ((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getSetupScreen().uninstallScreen();
            }
        }

        public void removeNotify() {
            ((CommonBackhaulScreen)CommonBackhaulMenuMgr.this.scn).getSetupScreen().uninstallScreen();
        }

        protected void drawExtras(Graphics graphics, int n, int n2, int n3, int n4) {
            super.drawExtras(graphics, n, n2, n3, n4);
            MenuSymbol.draw(graphics, n, n2, n3, n4);
        }

        static /* synthetic */ CommonBackhaulMenuMgr access$2400(SetupButton setupButton) {
            return setupButton.CommonBackhaulMenuMgr.this;
        }
    }

    private class StatusLineChangeListener
    implements ValueListener {
        private final String listenerName;

        private StatusLineChangeListener() {
            this.listenerName = CommonBackhaulMenuMgr.this.getListenerBaseName() + ".statusLineChangeListener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (valueInterface.intValue() == 0) {
                CommonBackhaulMenuMgr.this.analyzer.setStatusPrimaryLine();
            } else if (valueInterface.intValue() == 1) {
                CommonBackhaulMenuMgr.this.analyzer.setStatusSecondaryLine();
            } else {
                CommonBackhaulMenuMgr.this.analyzer.setStatusLineBoth();
            }
        }
    }

    private class AlarmsLineChangeListener
    implements ValueListener {
        private final String listenerName;

        private AlarmsLineChangeListener() {
            this.listenerName = CommonBackhaulMenuMgr.this.getListenerBaseName() + ".alarmsLineChangeListener";
        }

        public String getListenerName() {
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            if (valueInterface.intValue() == 0) {
                CommonBackhaulMenuMgr.this.analyzer.setAlarmsPrimaryLine();
            } else if (valueInterface.intValue() == 1) {
                CommonBackhaulMenuMgr.this.analyzer.setAlarmsSecondaryLine();
            } else {
                logger.error("Illegal Alarms Line State " + valueInterface);
            }
        }
    }

    protected class SubMenuButtonWithDisplay
    extends SubMenuButton {
        private String fileToDisplay;

        public SubMenuButtonWithDisplay(String string, String string2, String string3, Menu menu) {
            super(string, string2, menu);
            this.setCancelButtonActionListener(CommonBackhaulMenuMgr.this.createLoadBackhaulAnalyzerActionListener());
            this.fileToDisplay = string3;
        }

        public void press() {
            super.press();
            CommonBackhaulMenuMgr.this.scn.getScreenManager().installDisplay(new BackhaulModeDisplay(this.fileToDisplay, CommonBackhaulMenuMgr.this.settings));
        }
    }
}

