/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.readings.DoubleReadingField;
import elgato.infrastructure.readings.IntegerReadingField;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.measurement.backhaul.PerformanceRow;
import elgato.measurement.backhaul.TwoReadingRow;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ComponentFactory {
    public static ReadingField createPrimaryTimeReadingField(final Analyzer analyzer, String string, int n) {
        ReadingField readingField = new ReadingField(string, n){

            public String getValue() {
                if (analyzer.getMeasurement() == null) {
                    return "";
                }
                int n = analyzer.getMeasurement().getIntegerReadingValue(this.getReadingIndex());
                int n2 = n / 3600;
                int n3 = (n - n2 * 3600) / 60;
                int n4 = n - n2 * 3600 - n3 * 60;
                return String.valueOf(n2) + ":" + this.formatTimeInt(n3) + ":" + this.formatTimeInt(n4);
            }

            private String formatTimeInt(int n) {
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(n));
                if (stringBuffer.length() == 1) {
                    stringBuffer.insert(0, '0');
                }
                return stringBuffer.toString();
            }
        };
        readingField.setLongLabel(ComponentFactory.prependPrimary(string));
        return readingField;
    }

    public static IntegerReadingField createPrimaryReadingField(Analyzer analyzer, String string, String string2, int n, double d, int n2) {
        IntegerReadingField integerReadingField = new IntegerReadingField(analyzer, string, string2, n, d, n2);
        integerReadingField.setLongLabel(ComponentFactory.prependPrimary(string));
        return integerReadingField;
    }

    public static IntegerReadingField createPrimaryReadingField(Analyzer analyzer, String string, int n) {
        IntegerReadingField integerReadingField = new IntegerReadingField(analyzer, string, "", n, 1.0, 0);
        integerReadingField.setLongLabel(ComponentFactory.prependPrimary(string));
        return integerReadingField;
    }

    public static IntegerReadingField createPrimaryReadingField(Analyzer analyzer, String string, int n, double d) {
        IntegerReadingField integerReadingField = new IntegerReadingField(analyzer, string, "", n, d, 0);
        integerReadingField.setLongLabel(ComponentFactory.prependPrimary(string));
        return integerReadingField;
    }

    public static IntegerReadingField createSecondaryReadingField(Analyzer analyzer, String string, String string2, int n) {
        IntegerReadingField integerReadingField = new IntegerReadingField(analyzer, string, string2, n, 1.0, 0);
        integerReadingField.setLongLabel(ComponentFactory.prependSecondary(string));
        return integerReadingField;
    }

    public static IntegerReadingField createSecondaryReadingField(Analyzer analyzer, String string, int n) {
        IntegerReadingField integerReadingField = new IntegerReadingField(analyzer, string, "", n, 1.0, 0);
        integerReadingField.setLongLabel(ComponentFactory.prependSecondary(string));
        return integerReadingField;
    }

    public static IntegerReadingField createDelayReadingField(final Analyzer analyzer, String string, int n) {
        return new IntegerReadingField(analyzer, string, "", n, 1.0, 0){
            int invalidReading = -1;
            String INVALID_STATE = "----------";

            public String getValue() {
                if (analyzer.getMeasurement() == null) {
                    return "";
                }
                if (analyzer.getMeasurement().getIntegerReadingValue(this.getReadingIndex()) == this.invalidReading) {
                    return this.INVALID_STATE;
                }
                return super.getValue();
            }
        };
    }

    public static DoubleReadingField createDelayDoubleReadingField(Analyzer analyzer, String string, int n, int n2) {
        DoubleReadingField doubleReadingField = new DoubleReadingField(analyzer, string, "", n, n2){
            double invalidReading = -1.0;
            double precision = 1.0E-5;
            String INVALID_STATE = "----------";
            NumberFormat format = new DecimalFormat();

            public String getValue() {
                if (this.analyzer.getMeasurement() == null) {
                    return "";
                }
                return this.formatValue(this.analyzer.getMeasurement().getDoubleReadingValue(this.getReadingIndex()), 0);
            }

            public String formatValue(double d, int n) {
                double d2 = d - this.invalidReading;
                if (Math.abs(d2) < this.precision) {
                    return this.INVALID_STATE;
                }
                this.format.setMinimumFractionDigits(1);
                return this.format.format(d);
            }
        };
        return doubleReadingField;
    }

    public static DoubleReadingField createDoubleReadingFieldUsingFixedPointNotation(Analyzer analyzer, String string, int n) {
        DoubleReadingField doubleReadingField = new DoubleReadingField(analyzer, string, "", n, 0){
            NumberFormat format = new DecimalFormat();

            public String formatValue(double d, int n) {
                this.format.setMinimumFractionDigits(1);
                return this.format.format(d);
            }
        };
        return doubleReadingField;
    }

    public static DoubleReadingField createDoubleReadingFieldUsingScientificNotation(Analyzer analyzer, String string, String string2, int n, final int n2) {
        DoubleReadingField doubleReadingField = new DoubleReadingField(analyzer, string2, "", n, 0){

            public String formatValue(double d, int n) {
                return UIHelper.formatScientific(d, n2);
            }
        };
        doubleReadingField.setLongLabel(string + " " + string2);
        return doubleReadingField;
    }

    public static DoubleReadingField createPrimaryDoubleReadingField(Analyzer analyzer, String string, int n, final int n2) {
        DoubleReadingField doubleReadingField = new DoubleReadingField(analyzer, string, "", n, 0){

            public String formatValue(double d, int n) {
                return UIHelper.formatScientific(d, n2);
            }
        };
        doubleReadingField.setLongLabel(ComponentFactory.prependPrimary(string));
        return doubleReadingField;
    }

    public static DoubleReadingField createSecondaryDoubleReadingField(Analyzer analyzer, String string, int n, final int n2) {
        DoubleReadingField doubleReadingField = new DoubleReadingField(analyzer, string, "", n, 0){

            public String formatValue(double d, int n) {
                return UIHelper.formatScientific(d, n2);
            }
        };
        doubleReadingField.setLongLabel(ComponentFactory.prependSecondary(string));
        return doubleReadingField;
    }

    public static PerformanceRow createPrimaryPerformanceRow(Analyzer analyzer, String string, int n, int n2) {
        return new PerformanceRow(analyzer, string, ComponentFactory.prependPrimary(string), n, n2);
    }

    public static TwoReadingRow createTwoReadingRow(ReadingField readingField, ReadingField readingField2) {
        return new TwoReadingRow(readingField, readingField2);
    }

    public static PerformanceRow createSecondaryPerformanceRow(Analyzer analyzer, String string, int n, int n2) {
        return new PerformanceRow(analyzer, string, ComponentFactory.prependSecondary(string), n, n2);
    }

    private static String prependPrimary(String string) {
        return Text.Primary + " " + string;
    }

    private static String prependSecondary(String string) {
        return Text.Secondary + " " + string;
    }
}

