/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.actuators.MultiStateActuatorButton;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.measurement.MeasurementFactory;
import elgato.infrastructure.menu.ActionButton;
import elgato.infrastructure.menu.DynamicMenuButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuButton;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.MenuPanel;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.CommonBackhaulScreen;
import elgato.measurement.backhaul.SetupMenuMgr;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

abstract class ControlMenuAbstractFactory {
    private CommonBackhaulScreen screen;
    private CommonBackhaulMeasurementSettings settings;
    protected ActionButton alarmInjectButton;
    protected ActionButton errorInjectButton;
    private final ValueListener injectTypeValueListener = new ValueListener(){
        private String listenerName = ".injectTypeValueListener";
        private String screenBase = null;

        public String getListenerName() {
            if (this.screenBase == null) {
                this.screenBase = ControlMenuAbstractFactory.this.screen.getListenerBaseName();
                this.listenerName = this.screenBase + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            ControlMenuAbstractFactory.this.configureInjectButton();
        }
    };

    ControlMenuAbstractFactory(CommonBackhaulScreen commonBackhaulScreen, CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        this.screen = commonBackhaulScreen;
        this.settings = commonBackhaulMeasurementSettings;
        this.alarmInjectButton = this.createAlarmInjectButton();
        this.errorInjectButton = this.createErrorInjectButton();
    }

    MenuButton createControlMenuButton() {
        Menu[] menuArray = this.createControlMenus();
        DynamicMenuButton dynamicMenuButton = new DynamicMenuButton(this.settings.getControlMode(), this.screen.getContextString("control"), menuArray);
        dynamicMenuButton.addActionListener(this.screen.getMenuMgr().createLoadBackhaulAnalyzerActionListener());
        return dynamicMenuButton;
    }

    Menu createControlHardLoopMenu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(this.settings, this.screen.getListenerBaseName() + ".hardLoop"), null, null, this.createAlarmErrorButton(), null});
    }

    Menu createControlChannelMenu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(this.settings, this.screen.getListenerBaseName() + ".ctrlChan"), this.createChannelButton(), this.createFillDataButton(), this.createAlarmErrorButton(), null});
    }

    Menu createMonitorFullMenu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(this.settings, this.screen.getListenerBaseName() + ".monitorFull")});
    }

    Menu createBlankControlMenu() {
        return new Menu(Text.Control, new MenuItem[0]);
    }

    Menu createMonitorChannelMenu() {
        return new Menu(Text.Control, new MenuItem[]{SetupMenuMgr.createPatternButton(this.settings, this.screen.getListenerBaseName() + ".monitorChan"), this.createChannelButton()});
    }

    MenuItem createAlarmErrorButton() {
        ListActuatorButton listActuatorButton = new ListActuatorButton(this.settings.getInjectType(), this.screen.getContextString("alarm.error"), this.screen.getListenerBaseName() + "alarmErrorButton"){

            public void addNotify(MenuPanel menuPanel) {
                super.addNotify(menuPanel);
                ControlMenuAbstractFactory.this.configureInjectButton();
                ControlMenuAbstractFactory.this.settings.getInjectType().addValueListener(ControlMenuAbstractFactory.this.injectTypeValueListener);
            }

            public void removeNotify() {
                super.removeNotify();
                ControlMenuAbstractFactory.this.settings.getInjectType().removeValueListener(ControlMenuAbstractFactory.this.injectTypeValueListener);
            }
        };
        return listActuatorButton;
    }

    protected void setButtonInPosition4(ActionButton actionButton) {
        MenuPanel menuPanel = MeasurementFactory.instance().getScreenManager().getRightMenuPanel();
        menuPanel.setMenuItem(actionButton, 4);
        menuPanel.repaint();
    }

    ActionButton createAlarmInjectButton() {
        MultiStateActuatorButton multiStateActuatorButton = new MultiStateActuatorButton(this.settings.getInjectState(), this.screen.getContextString("inject"), this.screen.getListenerBaseName() + ".alarmInjectButton");
        multiStateActuatorButton.setBodyText(this.getInjectStateText());
        return multiStateActuatorButton;
    }

    ActionButton createErrorInjectButton() {
        PushButton pushButton = new PushButton(Text.Inject, this.screen.getContextString("inject"));
        pushButton.setBodyText(this.getInjectStateText());
        pushButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Command command = Command.makeSetCommand(ControlMenuAbstractFactory.this.screen.getTopic());
                command.addProperty("errorMode", 0L);
                command.addProperty("injectState", 1L);
                MeasurementFactory.instance().getCommandProcessor().send(command);
            }
        });
        return pushButton;
    }

    protected String getInjectStateText() {
        return this.settings.getInjectType().getSelectedValue().getLabel();
    }

    MenuItem createFillDataButton() {
        return new ActuatorSubMenuButton(this.settings.getFillData(), this.screen.getContextString("filldata"), true, this.screen.getListenerBaseName() + ".fillDataButton");
    }

    protected boolean isAlarmType() {
        int n = this.settings.getInjectType().getSelectedValue().intValue();
        return this.settings.isAlarmType(n);
    }

    protected abstract Menu[] createControlMenus();

    protected abstract MenuItem createChannelButton();

    protected abstract MenuItem createChannelButton(LongActuator var1);

    protected abstract void configureInjectButton();
}

