/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.MeasurementListener;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.ModeTitle;
import elgato.measurement.backhaul.PanelProperties;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import javax.swing.JPanel;

public class DelayPanel
extends JPanel
implements MeasurementListener,
Analyzer {
    private Measurement measurement;
    private ReadingField[] readingFields;

    public DelayPanel(ReadingField[] readingFieldArray, CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        super(new BorderLayout());
        this.readingFields = readingFieldArray;
        this.setBackground(PanelProperties.TEST_MODE_BORDER.getBackgroundColor());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(null);
        jPanel.add((Component)new ModeTitle(commonBackhaulMeasurementSettings), "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBackground(null);
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.setBackground(null);
        jPanel3.add(new ELabel(Text.Delay_Primary_TX_to_Primary_RX, Color.white, new Font("Sans Serif", 1, 16)));
        jPanel2.add((Component)jPanel3, "North");
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBackground(null);
        jPanel4.add((Component)new ELabel(Text.Round_Trip_Delay, Color.cyan, new Font("Sans Serif", 0, 12)), "North");
        JPanel jPanel5 = new JPanel(new GridLayout(2, 3));
        jPanel5.setBackground(null);
        for (int i = 0; i < 2; ++i) {
            this.createDelayFields(jPanel5, i);
        }
        jPanel4.add((Component)new BorderWrapper(jPanel5, PanelProperties.TEST_MODE_BORDER, true), "Center");
        jPanel4.add((Component)new Glue(0, 10, null), "South");
        JPanel jPanel6 = new JPanel(new BorderLayout());
        jPanel6.setBackground(null);
        jPanel6.add((Component)new ELabel(Text.One_Way_Delay, Color.cyan, new Font("Sans Serif", 0, 12)), "North");
        JPanel jPanel7 = new JPanel(new GridLayout(3, 3));
        jPanel7.setBackground(null);
        for (int i = 2; i < 5; ++i) {
            this.createDelayFields(jPanel7, i);
        }
        jPanel6.add((Component)new BorderWrapper(jPanel7, PanelProperties.TEST_MODE_BORDER, true), "Center");
        JPanel jPanel8 = new JPanel(new GridLayout(2, 1));
        jPanel8.setBackground(null);
        jPanel8.add((Component)jPanel4, 0);
        jPanel8.add((Component)jPanel6, 1);
        jPanel2.add((Component)jPanel8, "Center");
        jPanel2.add((Component)new Glue(20, 0, null), "East");
        jPanel2.add((Component)new Glue(20, 0, null), "West");
        jPanel2.add((Component)new Glue(0, 30, null), "South");
        jPanel.add((Component)jPanel2, "Center");
        this.add(new BorderWrapper(jPanel, PanelProperties.TEST_MODE_BORDER, true));
    }

    private void createDelayFields(Container container, int n) {
        container.add(new ELabel(this.readingFields[n].getLabel(), Color.white, PanelProperties.TEST_MODE_FONT));
        container.add(this.readingFields[n].createDynamicLabel(Color.white, PanelProperties.TEST_MODE_FONT));
        container.add(new Glue(0, 0, null));
    }

    public void measurementReceived(Measurement measurement) {
        this.measurement = measurement;
        this.repaint();
    }

    public void dispose() {
    }

    public Measurement getMeasurement() {
        return this.measurement;
    }
}

