/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.FixedPanel;
import elgato.infrastructure.mainScreens.GlobalKeyManager;
import elgato.infrastructure.mainScreens.ModalKeyManager;
import elgato.infrastructure.mainScreens.Screen;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.infrastructure.widgets.ProgressIndicator;
import elgato.measurement.backhaul.DiagnosticsScreen;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.TestListener;
import elgato.measurement.backhaul.VerificationTests;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;

public class DiagnosticsScreen
extends Screen {
    private String measurementName;
    private VerificationTests tests;
    private Class measurementClass;
    private String e1ImageFilename = "images/E1 Verification Drawing.png";
    private String t1ImageFilename = "images/T1 Verification Drawing.png";
    private Component verificationPanel;
    static /* synthetic */ Class class$elgato$measurement$backhaul$E1Measurement;

    public DiagnosticsScreen(String string, Class clazz) {
        this.measurementName = string;
        this.measurementClass = clazz;
        this.verificationPanel = this.createVerificationPanel();
        this.tests = new VerificationTests();
    }

    public void installScreen(ScreenManager screenManager) {
        super.installScreen(screenManager);
        screenManager.installDisplay(this.verificationPanel);
        screenManager.installLeftMenu(new Menu(this.measurementName, new MenuItem[0]));
        screenManager.installRightMenu(this.createContinueOrReturnMenu());
        screenManager.repaintImmediately();
        GlobalKeyManager.registerInstance(new ModalKeyManager(screenManager){

            protected void processKeyPress(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 76) {
                    DiagnosticsScreen.this.handleEscape();
                } else {
                    this.processSoftkeyPress(keyEvent);
                }
            }
        });
    }

    private void handleEscape() {
        this.getScreenManager().getRightMenuPanel().getMenuItems()[6].press();
    }

    private Menu createRestartOrReturnMenu() {
        return new Menu(Text.Verification, new MenuItem[]{this.createRestartButton(), null, null, null, null, null, this.createReturnButton()});
    }

    private Menu createContinueOrReturnMenu() {
        return new Menu(Text.Verification, new MenuItem[]{this.createContinueButton(), null, null, null, null, null, this.createReturnButton()});
    }

    protected PushButton createContinueButton() {
        return new PushButton(Text.Continue, "Verification", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsScreen.this.startTests();
            }
        });
    }

    private Menu createTestMenu() {
        return new Menu(Text.Verification, new MenuItem[]{null, null, null, null, null, null, this.createCancelTestsButton()});
    }

    protected MenuItem createCancelTestsButton() {
        return new PushButton(Text.Cancel, "verification", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsScreen.this.tests.stopTestSuite(new TestListener(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void testsDone() {
                        EventDispatchThread.invokeLater(new Runnable(this){
                            private final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                DiagnosticsScreen.access$302(3.access$200(4.access$100(this.this$2)), new VerificationTests());
                                3.access$200(4.access$100(this.this$2)).getScreenManager().installDisplay(3.access$200(4.access$100(this.this$2)).createResultsPanel());
                                3.access$200(4.access$100(this.this$2)).getScreenManager().getRightMenuPanel().installMenu(DiagnosticsScreen.access$400(3.access$200(4.access$100(this.this$2))));
                            }
                        }, "DiagnosticsScreen.createCancelTestsButton.testsDone");
                    }

                    static /* synthetic */ 3 access$100(4 var0) {
                        return var0.this$1;
                    }
                });
            }

            static /* synthetic */ DiagnosticsScreen access$200(3 var0) {
                return var0.DiagnosticsScreen.this;
            }
        });
    }

    protected void startTests() {
        this.tests = new VerificationTests();
        this.getScreenManager().installDisplay(this.createResultsPanel());
        this.getScreenManager().getRightMenuPanel().installMenu(this.createTestMenu());
        this.tests.startTest(this.measurementClass, new TestListener(){

            public void testsDone() {
                EventDispatchThread.invokeLater(new Runnable(this){
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        6.access$500(this.this$1).getScreenManager().getRightMenuPanel().installMenu(DiagnosticsScreen.access$400(6.access$500(this.this$1)));
                    }
                }, "DiagnosticsScreen.startTests.testsDone");
            }

            static /* synthetic */ DiagnosticsScreen access$500(6 var0) {
                return var0.DiagnosticsScreen.this;
            }
        });
    }

    private PushButton createRestartButton() {
        return new PushButton(Text.Restart_n_Verification, "verification", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsScreen.this.startTests();
            }
        });
    }

    public void uninstallScreen(ScreenManager screenManager) {
        super.uninstallScreen(screenManager);
        GlobalKeyManager.makeInstance(screenManager);
    }

    private Component createVerificationPanel() {
        FixedPanel fixedPanel;
        if (this.measurementClass.equals(class$elgato$measurement$backhaul$E1Measurement == null ? (class$elgato$measurement$backhaul$E1Measurement = DiagnosticsScreen.class$("elgato.measurement.backhaul.E1Measurement")) : class$elgato$measurement$backhaul$E1Measurement)) {
            fixedPanel = new FixedPanel(this.e1ImageFilename, false);
            fixedPanel.addCenteredLabel(10, Text.E1_VERIFICATION_TITLE);
            fixedPanel.addLabel(225, 60, Text.E1_VERIFICATION_TEXT_1);
            fixedPanel.addLabel(70, 250, Text.E1_VERIFICATION_TEXT_2);
            fixedPanel.addLabel(70, 270, Text.E1_VERIFICATION_TEXT_3);
            fixedPanel.addLabel(70, 290, Text.E1_VERIFICATION_TEXT_4);
            fixedPanel.addLabel(70, 310, Text.E1_VERIFICATION_TEXT_5);
            fixedPanel.addLabel(70, 330, Text.E1_VERIFICATION_TEXT_6);
            fixedPanel.addLine(141, 50, 220, 70);
            fixedPanel.addLine(192, 50, 220, 60);
        } else {
            fixedPanel = new FixedPanel(this.t1ImageFilename, false);
            fixedPanel.addCenteredLabel(10, Text.T1_VERIFICATION_TITLE);
            fixedPanel.addLabel(275, 230, Text.T1_VERIFICATION_TEXT_1);
            fixedPanel.addLabel(70, 280, Text.T1_VERIFICATION_TEXT_2);
            fixedPanel.addLabel(70, 300, Text.T1_VERIFICATION_TEXT_3);
            fixedPanel.addLabel(70, 320, Text.T1_VERIFICATION_TEXT_4);
            fixedPanel.addLabel(70, 340, Text.T1_VERIFICATION_TEXT_5);
            fixedPanel.addLabel(70, 360, Text.T1_VERIFICATION_TEXT_6);
            fixedPanel.addLine(237, 210, 270, 230);
            fixedPanel.addLine(209, 210, 270, 235);
        }
        return new BorderWrapper(fixedPanel, ProgressIndicator.BORDER, true);
    }

    protected PushButton createCancelButton() {
        return new PushButton(Text.Cancel, "Verification", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsScreen.this.getScreenManager().popScreen();
            }
        });
    }

    protected PushButton createReturnButton() {
        return new PushButton(Text.Return, "Verification", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DiagnosticsScreen.this.getScreenManager().popScreen();
            }
        });
    }

    protected Component createResultsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        TableLayout tableLayout = new TableLayout(new float[][]{{0.15f, 0.5f, -1.0f}, {25.0f, 25.0f, 25.0f, 25.0f, 30.0f, 40.0f, 40.0f, 40.0f}});
        JPanel jPanel2 = new JPanel(tableLayout);
        jPanel2.setBackground(null);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBackground(null);
        ELabel eLabel = new ELabel(this.measurementName + " " + Text.Verification_Results, Color.white, PanelProperties.TITLE_FONT, 2, 0);
        jPanel3.add((Component)eLabel, "North");
        jPanel3.add((Component)new Glue(1, PanelProperties.RULE_SIZE, PanelProperties.RULE_COLOR), "South");
        jPanel.add((Component)jPanel3, "North");
        for (int i = 0; i < VerificationTests.NUMBER_OF_TESTS; ++i) {
            jPanel2.add((Component)this.tests.getLabels()[i], TableLayoutConstraints.newCell(1, i + 1));
            jPanel2.add((Component)this.tests.getValues()[i], TableLayoutConstraints.newCell(2, i + 1));
        }
        jPanel2.add((Component)this.tests.getWaitMessage(), TableLayoutConstraints.newSpan(1, 7, 2, 7));
        jPanel.add((Component)jPanel2, "Center");
        return new BorderWrapper(jPanel, PanelProperties.MEASUREMENT_PANEL_BORDER, true);
    }

    static /* synthetic */ VerificationTests access$302(DiagnosticsScreen diagnosticsScreen, VerificationTests verificationTests) {
        diagnosticsScreen.tests = verificationTests;
        return diagnosticsScreen.tests;
    }

    static /* synthetic */ Menu access$400(DiagnosticsScreen diagnosticsScreen) {
        return diagnosticsScreen.createRestartOrReturnMenu();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

