/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.SaveData;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.util.EventDispatchThread;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.AlarmsPanel;
import elgato.measurement.backhaul.BackhaulAnalyzer;
import elgato.measurement.backhaul.BackhaulBitRow;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.ComponentFactory;
import elgato.measurement.backhaul.E1Measurement;
import elgato.measurement.backhaul.E1MeasurementSettings;
import elgato.measurement.backhaul.ErrorPanel;
import elgato.measurement.backhaul.LEDResultPanel;
import elgato.measurement.backhaul.ModeTitle;
import elgato.measurement.backhaul.PerformanceResultsPanel;
import elgato.measurement.backhaul.PerformanceRow;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.ResultPanel;
import elgato.measurement.backhaul.StatusPanel;
import elgato.measurement.backhaul.TwoReadingRow;
import java.awt.Component;
import java.awt.Container;
import java.io.PrintWriter;
import javax.swing.JPanel;

public class E1Analyzer
extends BackhaulAnalyzer {
    public static final int ROW_HEIGHT = 14;
    private E1Measurement e1Measurement;
    private AlarmsPanel primaryAlarmsPanel;
    private AlarmsPanel secondaryAlarmsPanel;
    private ReadingBitRow[] primaryErrorSummaryBitRows;
    private E1ErrorBitRow[] secondaryErrorSummaryBitRows;
    private ReadingBitRow[] statusLedRows;
    private ReadingBitRow[] statusTextRows;
    ResultPanel[] resultPanelList;

    public E1Analyzer() {
        super(E1MeasurementSettings.instance());
    }

    protected ResultPanel[] getResultPanels() {
        return this.resultPanelList;
    }

    private ResultPanel createPrimaryTestPatternPanel() {
        return ResultPanel.createPrimaryResultPanel(9, Text.Pattern, Text.Test_Pattern, new ReadingField[]{ComponentFactory.createPrimaryReadingField(this, Text.Bit_Errors, 68), ComponentFactory.createPrimaryDoubleReadingField(this, Text.Bit_Error_Rate, 69, 6), ComponentFactory.createPrimaryReadingField(this, Text.Bit_Errd_Secs, 70), ComponentFactory.createPrimaryReadingField(this, Text.Pattern_Sync_Loss_Secs, 71), ComponentFactory.createPrimaryReadingField(this, Text.Test_Data_Rate, "Mbits/s", 73, 1000.0, 4)});
    }

    private ResultPanel createPrimaryClockSlips() {
        return ResultPanel.createPrimaryResultPanel(8, Text.Clock, Text.Clock_and_Frame_Slips, Text.ClockandSymbolFrame_Slips, new ReadingField[]{ComponentFactory.createPrimaryReadingField(this, Text.Clock_Slips, 62), ComponentFactory.createPrimaryDoubleReadingField(this, Text.Slip_Rate, 63, 6), ComponentFactory.createPrimaryReadingField(this, Text.Peak_PLUS_Wander, 64), ComponentFactory.createPrimaryReadingField(this, Text.Peak_NEGATIVE_Wander, 65), ComponentFactory.createPrimaryReadingField(this, Text.PLUS_Frame_Slips, 66), ComponentFactory.createPrimaryReadingField(this, Text.MINUS_Frame_Slips, 67)});
    }

    protected void initResultPanels() {
        super.initResultPanels();
        this.frameELabels = new ELabel[2];
        TwoReadingRow[] twoReadingRowArray = new TwoReadingRow[]{new TwoReadingRow(this.primaryRecieverLevelDbdsx, this.primaryReceiverLevelVpp)};
        LEDResultPanel lEDResultPanel = new LEDResultPanel(0, Text.Pri_Summary, Text.Primary_Summary, Text.Primary_Summary, this.primaryErrorSummaryBitRows, this.primaryFrequencyFields, twoReadingRowArray, 14);
        this.frameELabels[0] = lEDResultPanel.getELabel(Text.Frame_Slip);
        LEDResultPanel lEDResultPanel2 = new LEDResultPanel(1, Text.Pri_Error, Text.Primary, Text.Error_Summary, this.primaryErrorSummaryBitRows, 14);
        this.frameELabels[1] = lEDResultPanel2.getELabel(Text.Frame_Slip);
        this.resultPanelList = new ResultPanel[]{lEDResultPanel, ResultPanel.createPrimaryResultPanel(2, Text.Lev_slash_Freq, Text.Level_Frequency, Text.Level_slash_Freq_slash_Time, this.primaryFrequencyFields, twoReadingRowArray), lEDResultPanel2, new LEDResultPanel(13, Text.Sec_Error, Text.Secondary, Text.Error_Summary, this.secondaryErrorSummaryBitRows, 14), this.createPrimaryBpfFasPanel(), this.createSecondaryBpfFasPanel(), this.createPrimaryEbitCrc4Panel(), this.createSecondaryEbitCrc4Panel(), this.createPrimaryAlarmSecondsPanel(), this.createSecondaryAlarmSecondsPanel(), this.createPrimaryPerformancePanel(), this.createSecondaryPerformancePanel(), this.createPrimaryClockSlips(), this.createPrimaryTestPatternPanel()};
    }

    private ResultPanel createSecondaryPerformancePanel() {
        return new PerformanceResultsPanel(17, Text.Sec + " " + Text.Perform, Text.Secondary, Text.Performance, new PerformanceRow[]{ComponentFactory.createSecondaryPerformanceRow(this, Text.Error_Free_Secs, 56, 80), ComponentFactory.createSecondaryPerformanceRow(this, Text.Errored_Seconds, 57, 81), ComponentFactory.createSecondaryPerformanceRow(this, Text.Sever_Errd_Secs, 58, 82), ComponentFactory.createSecondaryPerformanceRow(this, Text.Available_Secs, 59, 83), ComponentFactory.createSecondaryPerformanceRow(this, Text.UnAvail_Secs, 60, 84), ComponentFactory.createSecondaryPerformanceRow(this, Text.Degraded_Mins, 61, 85)});
    }

    private ResultPanel createPrimaryPerformancePanel() {
        return new PerformanceResultsPanel(7, Text.Pri + " " + Text.Perform, Text.Primary, Text.Performance, new PerformanceRow[]{ComponentFactory.createPrimaryPerformanceRow(this, Text.Error_Free_Secs, 50, 74), ComponentFactory.createPrimaryPerformanceRow(this, Text.Errored_Seconds, 51, 75), ComponentFactory.createPrimaryPerformanceRow(this, Text.Sever_Errd_Secs, 52, 76), ComponentFactory.createPrimaryPerformanceRow(this, Text.Available_Secs, 53, 77), ComponentFactory.createPrimaryPerformanceRow(this, Text.UnAvail_Secs, 54, 78), ComponentFactory.createPrimaryPerformanceRow(this, Text.Degraded_Mins, 55, 79)});
    }

    private ResultPanel createPrimaryAlarmSecondsPanel() {
        return ResultPanel.createPrimaryResultPanel(6, Text.Alarm, Text.Alarm_Seconds, new ReadingField[]{ComponentFactory.createPrimaryReadingField(this, Text.Signal_Loss_Secs, 38), ComponentFactory.createPrimaryReadingField(this, Text.Frame_Sync_Loss_Secs, 39), ComponentFactory.createPrimaryReadingField(this, Text.AIS_Secs, 40), ComponentFactory.createPrimaryReadingField(this, Text.TS16_AIS_Secs, 43), ComponentFactory.createPrimaryReadingField(this, Text.FAS_Distant_Secs, 41), ComponentFactory.createPrimaryReadingField(this, Text.MFAS_Distant_Secs, 42)});
    }

    private ResultPanel createSecondaryAlarmSecondsPanel() {
        return ResultPanel.createSecondaryResultPanel(16, Text.Alarm, Text.Alarm_Seconds, new ReadingField[]{ComponentFactory.createSecondaryReadingField(this, Text.Signal_Loss_Secs, 44), ComponentFactory.createSecondaryReadingField(this, Text.Frame_Sync_Loss_Secs, 45), ComponentFactory.createSecondaryReadingField(this, Text.AIS_Secs, 46), ComponentFactory.createSecondaryReadingField(this, Text.TS16_AIS_Secs, 49), ComponentFactory.createSecondaryReadingField(this, Text.FAS_Distant_Secs, 47), ComponentFactory.createSecondaryReadingField(this, Text.MFAS_Distant_Secs, 48)});
    }

    private ResultPanel createSecondaryEbitCrc4Panel() {
        return ResultPanel.createSecondaryResultPanel(15, Text.CRC4_slash_EBit, Text.CRC4_andSymbol_EBit, new ReadingField[]{ComponentFactory.createSecondaryReadingField(this, Text.CRC4_Errors, 29), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Secondary, Text.CRC4_Error_Rate, 30, 6), ComponentFactory.createSecondaryReadingField(this, Text.CRC4_Errd_Secs, 31), ComponentFactory.createSecondaryReadingField(this, Text.EBIT_Errors, 35), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Secondary, Text.EBIT_Error_Rate, 36, 6), ComponentFactory.createSecondaryReadingField(this, Text.EBIT_Errd_Secs, 37)});
    }

    private ResultPanel createPrimaryEbitCrc4Panel() {
        return ResultPanel.createPrimaryResultPanel(5, Text.CRC4_slash_EBit, Text.CRC4_andSymbol_EBit, new ReadingField[]{ComponentFactory.createPrimaryReadingField(this, Text.CRC4_Errors, 26), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.CRC4_Error_Rate, 27, 6), ComponentFactory.createPrimaryReadingField(this, Text.CRC4_Errd_Secs, 28), ComponentFactory.createPrimaryReadingField(this, Text.EBIT_Errors, 32), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.EBIT_Error_Rate, 33, 6), ComponentFactory.createPrimaryReadingField(this, Text.EBIT_Errd_Secs, 34)});
    }

    private ResultPanel createSecondaryBpfFasPanel() {
        return ResultPanel.createSecondaryResultPanel(14, Text.BPV_slash_FAS_Err, Text.BPV_andSymbol_FAS, new ReadingField[]{ComponentFactory.createSecondaryReadingField(this, Text.BPV_Errors, 11), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Secondary, Text.BPV_Error_Rate, 12, 6), ComponentFactory.createSecondaryReadingField(this, Text.BPV_Errd_Secs, 13), ComponentFactory.createSecondaryReadingField(this, Text.FAS_Errors, 17), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Secondary, Text.FAS_Error_Rate, 18, 6), ComponentFactory.createSecondaryReadingField(this, Text.FAS_Errd_Secs, 19), ComponentFactory.createSecondaryReadingField(this, Text.MFAS_Errors, 23), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Secondary, Text.MFAS_Error_Rate, 24, 6), ComponentFactory.createSecondaryReadingField(this, Text.MFAS_Errd_Secs, 25)});
    }

    private ResultPanel createPrimaryBpfFasPanel() {
        return ResultPanel.createPrimaryResultPanel(3, Text.BPV_slash_FAS_Err, Text.BPV_andSymbol_FAS, new ReadingField[]{ComponentFactory.createPrimaryReadingField(this, Text.BPV_Errors, 8), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.BPV_Error_Rate, 9, 6), ComponentFactory.createPrimaryReadingField(this, Text.BPV_Errd_Secs, 10), ComponentFactory.createPrimaryReadingField(this, Text.FAS_Errors, 14), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.FAS_Error_Rate, 15, 6), ComponentFactory.createPrimaryReadingField(this, Text.FAS_Errd_Secs, 16), ComponentFactory.createPrimaryReadingField(this, Text.MFAS_Errors, 20), ComponentFactory.createDoubleReadingFieldUsingScientificNotation(this, Text.Primary, Text.MFAS_Error_Rate, 21, 6), ComponentFactory.createPrimaryReadingField(this, Text.MFAS_Errd_Secs, 22)});
    }

    protected CommonBackhaulMeasurementSettings getCommonSettings() {
        return E1MeasurementSettings.instance();
    }

    public AlarmsPanel getPrimaryAlarmsPanel() {
        return this.primaryAlarmsPanel;
    }

    public AlarmsPanel getSecondaryAlarmsPanel() {
        return this.secondaryAlarmsPanel;
    }

    protected Component getResultSubPanelComponent(ResultPanel resultPanel) {
        if (resultPanel.getPanelName().endsWith(Text.ClockandSymbolFrame_Slips) && E1MeasurementSettings.instance().isSlipRefNone()) {
            return new ErrorPanel(Text.SLIP_REF_ERROR_MESSAGE);
        }
        return resultPanel.createComponent();
    }

    protected void initReadingFields() {
        this.delayUnitIntervals = ComponentFactory.createDelayReadingField(this, Text.Unit_Intervals, 86);
        this.delayMicroseconds = ComponentFactory.createDelayDoubleReadingField(this, Text.Microseconds, 87, 1);
        this.delayKiloFeet = ComponentFactory.createDelayDoubleReadingField(this, Text.Kilofeet, 88, 1);
        this.delayMiles = ComponentFactory.createDelayDoubleReadingField(this, Text.Miles, 89, 1);
        this.delayKilometers = ComponentFactory.createDelayDoubleReadingField(this, Text.Kilometers, 120, 2);
        this.primaryRecieverLevelDbdsx = ComponentFactory.createPrimaryReadingField(this, Text.Recv_Level, Text.dBdsx, 5, 1000.0, 1);
        this.primaryReceiverLevelVpp = ComponentFactory.createPrimaryReadingField(this, Text.Recv_Level, Text.VPP, 4, 1000.0, 1);
        this.primaryFrequency = ComponentFactory.createPrimaryReadingField(this, Text.Frequency, Text.MHz, 6, 1000000.0, 6);
        this.primaryElapsedTime = ComponentFactory.createPrimaryTimeReadingField(this, Text.Elapsed_Time, 7);
    }

    protected void initBitRows() {
        BackhaulBitRow backhaulBitRow = new BackhaulBitRow(this, Text.Frame_Slip, 3, 11, Text.Detected, Text.OK){

            protected boolean getValue(int n) {
                if (E1Analyzer.this.settings.isSlipRefNone()) {
                    return false;
                }
                return super.getValue(n);
            }
        };
        backhaulBitRow.setLongLabel(Text.Primary + " " + backhaulBitRow.getLabel());
        this.primaryErrorSummaryBitRows = new ReadingBitRow[]{new E1ErrorBitRow(Text.Primary, Text.Code_BPV, 0, 16, this), new E1ErrorBitRow(Text.Primary, Text.FAS, 1, 17, this), new E1ErrorBitRow(Text.Primary, Text.MFAS, 2, 18, this), new E1ErrorBitRow(Text.Primary, Text.CRC_4, 3, 19, this), new E1ErrorBitRow(Text.Primary, Text.E_BIT, 4, 20, this), new E1ErrorBitRow(Text.Primary, Text.Pattern, 5, 21, this), backhaulBitRow};
        this.secondaryErrorSummaryBitRows = new E1ErrorBitRow[]{new E1ErrorBitRow(Text.Secondary, Text.BPV, 8, 24, this), new E1ErrorBitRow(Text.Secondary, Text.FAS, 9, 25, this), new E1ErrorBitRow(Text.Secondary, Text.MFAS, 10, 26, this), new E1ErrorBitRow(Text.Secondary, Text.CRC_4, 11, 27, this), new E1ErrorBitRow(Text.Secondary, Text.E_BIT, 12, 28, this)};
        BackhaulBitRow backhaulBitRow2 = new BackhaulBitRow(this, Text.Pattern_Sync, 3, 0, Text.Present, Text.OK){

            public String toTabDelimitedString() {
                if (E1MeasurementSettings.instance().getStatus().getSelectedValue().intValue() == 1) {
                    return "";
                }
                return super.toTabDelimitedString();
            }
        };
        backhaulBitRow2.setLongLabel(Text.Primary + " " + Text.Pattern_Sync);
        this.statusLedRows = new ReadingBitRow[]{new StatusRow(Text.E1_Pulses, 0, 8, this), new StatusRow(Text.HDB3, 1, 9, this), new StatusRow(Text.FAS_Sync, 2, 10, this), new StatusRow(Text.MFAS_SYNC, 3, 11, this), new StatusRow(Text.CRC4_SYNC, 4, 12, this), backhaulBitRow2};
        this.statusTextRows = new ReadingBitRow[]{new StatusRow(Text.Alarms, 5, 21, this), new StatusRow(Text.Alarms, 13, 29, this), new StatusRow(Text.Errors, 6, 22, this), new StatusRow(Text.Errors, 14, 30, this)};
    }

    protected void initAlarmsPanels() {
        BackhaulBitRow backhaulBitRow = new BackhaulBitRow(this, Text.Pattern_Inv, 3, 3, 7, Text.Detected, Text.OK);
        backhaulBitRow.setLongLabel(Text.Primary + " " + backhaulBitRow.getLabel());
        this.primaryAlarmsPanel = new AlarmsPanel(Text.Alarms, Text.Primary, new ReadingBitRow[]{new E1AlarmBitRow(Text.Primary, Text.Signal_Loss, 0, 16, this), new E1AlarmBitRow(Text.Primary, Text.Frame_Loss, 1, 17, this), new E1AlarmBitRow(Text.Primary, Text.AIS, 4, 20, this), new E1AlarmBitRow(Text.Primary, Text.TS_16_AIS, 5, 21, this), new E1AlarmBitRow(Text.Primary, Text.FAS_Distant, 2, 18, this), new E1AlarmBitRow(Text.Primary, Text.MFAS_Distant, 3, 19, this), backhaulBitRow}, 14);
        this.secondaryAlarmsPanel = new AlarmsPanel(Text.Alarms, Text.Secondary, new ReadingBitRow[]{new E1AlarmBitRow(Text.Secondary, Text.Signal_Loss, 8, 24, this), new E1AlarmBitRow(Text.Secondary, Text.Frame_Loss, 9, 25, this), new E1AlarmBitRow(Text.Secondary, Text.AIS, 12, 28, this), new E1AlarmBitRow(Text.Secondary, Text.TS_16_AIS, 13, 29, this), new E1AlarmBitRow(Text.Secondary, Text.FAS_Distant, 10, 26, this), new E1AlarmBitRow(Text.Secondary, Text.MFAS_Distant, 11, 27, this)}, 14);
    }

    protected ReadingBitRow[] getStatusTextRows() {
        return this.statusTextRows;
    }

    protected StatusPanel createStatusPanel(boolean bl, boolean bl2) {
        return new StatusPanel(bl, bl2, this.getStatusTextRows(), this.getStatusLedRows(), 14);
    }

    protected JPanel getModeTitle() {
        return new ModeTitle(E1MeasurementSettings.instance());
    }

    protected ReadingBitRow[] getStatusLedRows() {
        return this.statusLedRows;
    }

    public Measurement getMeasurement() {
        return this.e1Measurement;
    }

    public void measurementReceived(Measurement measurement) {
        final E1Measurement e1Measurement = (E1Measurement)measurement;
        if (this.delayModePanel != null) {
            this.delayModePanel.measurementReceived(e1Measurement);
        }
        EventDispatchThread.invokeLater(new Runnable(){

            public void run() {
                E1Measurement e1Measurement2 = E1Analyzer.this.e1Measurement;
                if (e1Measurement2 != null) {
                    e1Measurement2.recycle();
                }
                E1Analyzer.this.e1Measurement = e1Measurement;
                E1Analyzer.this.showMainPanel();
                E1Analyzer.this.paintImmediately(0, 0, E1Analyzer.this.getWidth(), E1Analyzer.this.getHeight());
            }
        }, "E1Analyzer.measurementReceived");
    }

    public void dispose() {
        super.dispose();
    }

    public void saveData(PrintWriter printWriter) {
        if (E1MeasurementSettings.instance().isDelayMode()) {
            SaveData.saveData(this.createDelayModeReadingFields(), printWriter, this.getMeasurement().getMeasurementTitle());
        } else {
            SaveData.saveData(this.getSavableFields(), printWriter, this.getMeasurement().getMeasurementTitle());
        }
    }

    public Container getPatternInvertPanel() {
        return null;
    }

    private class StatusRow
    extends BackhaulBitRow {
        public StatusRow(String string, int n, int n2, BackhaulAnalyzer backhaulAnalyzer) {
            super(backhaulAnalyzer, string, 1, n, n2, Text.Present, Text.Absent);
        }

        public String toTabDelimitedString() {
            String string = E1MeasurementSettings.instance().getStatus().intValue() == 0 ? this.makePrimaryStatusString() : (E1MeasurementSettings.instance().getStatus().intValue() == 1 ? this.makeSecondaryStatusString() : this.makePrimaryStatusString() + "\n" + this.makeSecondaryStatusString());
            return string;
        }

        private String makePrimaryStatusString() {
            return Text.Primary + " " + this.getLabel() + "\t" + this.getTextForCurrentBit();
        }

        private String makeSecondaryStatusString() {
            return Text.Secondary + " " + this.getLabel() + "\t" + this.getTextForHistoryBit();
        }
    }

    class E1ErrorBitRow
    extends BackhaulBitRow {
        public E1ErrorBitRow(String string, String string2, int n, int n2, BackhaulAnalyzer backhaulAnalyzer) {
            super(backhaulAnalyzer, string2, 2, n, n2, Text.Detected, Text.OK);
            this.setLongLabel(string + " " + string2 + " " + Text.Error);
        }
    }

    class E1AlarmBitRow
    extends BackhaulBitRow {
        public E1AlarmBitRow(String string, String string2, int n, int n2, BackhaulAnalyzer backhaulAnalyzer) {
            super(backhaulAnalyzer, string2, 0, n, n2, Text.Detected, Text.OK);
            this.setLongLabel(string + " " + string2 + " " + Text.Alarm);
        }
    }
}

