/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.util.Text;
import elgato.measurement.backhaul.CommonBackhaulScreen;
import elgato.measurement.backhaul.ControlMenuAbstractFactory;
import elgato.measurement.backhaul.E1MeasurementSettings;
import elgato.measurement.backhaul.SetupScreen;

public class E1ControlMenuFactory
extends ControlMenuAbstractFactory {
    public E1ControlMenuFactory(CommonBackhaulScreen commonBackhaulScreen) {
        super(commonBackhaulScreen, E1MeasurementSettings.instance());
    }

    protected void configureInjectButton() {
        if (this.isAlarmType()) {
            if (this.isUnframedAndNotAISorLOS() || this.isPCM31orPCM31plusCRC4AndMFASDistantAlarm() || this.isPCM31orPCM31plusCRC4AndTS16Alarm()) {
                this.alarmInjectButton.setEnabled(false);
            } else {
                this.alarmInjectButton.setEnabled(true);
            }
            this.alarmInjectButton.setBodyText(this.getInjectStateText());
            this.setButtonInPosition4(this.alarmInjectButton);
        } else {
            if (this.isUnframedAndNotBPV() || this.isPCMandFEBorCRC() || this.isPCM31AndMFASError() || this.isPCM31plusCRC4andMFASError()) {
                this.errorInjectButton.setEnabled(false);
            } else {
                this.errorInjectButton.setEnabled(true);
            }
            this.errorInjectButton.setBodyText(this.getInjectStateText());
            this.setButtonInPosition4(this.errorInjectButton);
        }
    }

    private boolean isUnframedAndNotAISorLOS() {
        return E1MeasurementSettings.instance().isUnframed() && !E1MeasurementSettings.instance().isAISInjectType() && !E1MeasurementSettings.instance().isLOSAlarm();
    }

    private boolean isPCM31plusCRC4andMFASError() {
        return E1MeasurementSettings.instance().isPCM31plusCRC4Framed() && E1MeasurementSettings.instance().isMFASErrorInjectType();
    }

    private boolean isPCM31AndMFASError() {
        return E1MeasurementSettings.instance().isPCM31Framed() && E1MeasurementSettings.instance().isMFASErrorInjectType();
    }

    private boolean isPCM31orPCM31plusCRC4AndMFASDistantAlarm() {
        return (E1MeasurementSettings.instance().isPCM31Framed() || E1MeasurementSettings.instance().isPCM31plusCRC4Framed()) && E1MeasurementSettings.instance().isMFASDistantAlarmInjectType();
    }

    private boolean isPCM31orPCM31plusCRC4AndTS16Alarm() {
        return (E1MeasurementSettings.instance().isPCM31Framed() || E1MeasurementSettings.instance().isPCM31plusCRC4Framed()) && E1MeasurementSettings.instance().isTS16InjectType();
    }

    private boolean isPCMandFEBorCRC() {
        return !(!E1MeasurementSettings.instance().isPCM30Framed() && !E1MeasurementSettings.instance().isPCM31Framed() || !E1MeasurementSettings.instance().isFEBErrorInjectType() && !E1MeasurementSettings.instance().isCRC4ErrorInjectType());
    }

    private boolean isUnframedAndNotBPV() {
        return E1MeasurementSettings.instance().isUnframed() && !E1MeasurementSettings.instance().isBPVErrorInjectType();
    }

    protected Menu[] createControlMenus() {
        return new Menu[]{this.createControlHardLoopMenu(), this.createControlChannelMenu(), this.createControlChannelToneMenu(), this.createMonitorFullMenu(), this.createMonitorChannelMenu(), this.createMonitorChannelToneMenu(), this.createControlChannelMenu(), this.createControlChannelToneMenu(), this.createBlankControlMenu()};
    }

    private Menu createMonitorChannelToneMenu() {
        return new Menu(Text.Control, new MenuItem[]{null, this.createChannelButton(), null, null, null});
    }

    private Menu createControlChannelToneMenu() {
        return new Menu(Text.Control, new MenuItem[]{null, this.createChannelButton(), this.createFillDataButton(), null, null});
    }

    protected MenuItem createChannelButton() {
        return this.createChannelButton(E1MeasurementSettings.instance().getTimeslot());
    }

    protected MenuItem createChannelButton(LongActuator longActuator) {
        return new ActuatorEditor(longActuator, SetupScreen.getContextString("timeslot"), "E1Control.chanButton");
    }
}

