/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.readings.BitFieldReading;
import elgato.infrastructure.readings.DoubleReading;
import elgato.infrastructure.readings.FloatReading;
import elgato.infrastructure.readings.IntegerReading;
import elgato.infrastructure.readings.Reading;
import elgato.infrastructure.util.Queue;
import elgato.infrastructure.util.Text;
import elgato.measurement.backhaul.BackhaulMeasurement;
import java.io.DataInput;
import java.io.IOException;

public class E1Measurement
extends BackhaulMeasurement {
    private static final Queue pool = new Queue(3);
    private static int NUM_COMPUTED_READINGS = 1;
    public static final int CURRENT_ALARM_INDICATORS = 0;
    public static final int CURRENT_STATUS_INDICATORS = 1;
    public static final int CURRENT_ERROR_INDICATORS = 2;
    public static final int CURRENT_MISC_INDICATORS = 3;
    public static final int RECEIVED_LEVEL_VPP = 4;
    public static final int RECEIVED_LEVEL_DBDSX = 5;
    public static final int RECEIVED_FREQUENCY = 6;
    public static final int ELAPSED_TIME = 7;
    public static final int PRIMARY_BPV_ERROR_COUNT = 8;
    public static final int PRIMARY_BPV_ERROR_RATE = 9;
    public static final int PRIMARY_BPV_ERROR_SECONDS = 10;
    public static final int SECONDARY_BPV_ERROR_COUNT = 11;
    public static final int SECONDARY_BPV_ERROR_RATE = 12;
    public static final int SECONDARY_BPV_ERROR_SECONDS = 13;
    public static final int PRIMARY_FAS_ERROR_COUNT = 14;
    public static final int PRIMARY_FAS_ERROR_RATE = 15;
    public static final int PRIMARY_FAS_ERROR_SECONDS = 16;
    public static final int SECONDARY_FAS_ERROR_COUNT = 17;
    public static final int SECONDARY_FAS_ERROR_RATE = 18;
    public static final int SECONDARY_FAS_ERROR_SECONDS = 19;
    public static final int PRIMARY_MFAS_ERROR_COUNT = 20;
    public static final int PRIMARY_MFAS_ERROR_RATE = 21;
    public static final int PRIMARY_MFAS_ERROR_SECONDS = 22;
    public static final int SECONDARY_MFAS_ERROR_COUNT = 23;
    public static final int SECONDARY_MFAS_ERROR_RATE = 24;
    public static final int SECONDARY_MFAS_ERROR_SECONDS = 25;
    public static final int PRIMARY_CRC4_ERROR_COUNT = 26;
    public static final int PRIMARY_CRC4_ERROR_RATE = 27;
    public static final int PRIMARY_CRC4_ERROR_SECONDS = 28;
    public static final int SECONDARY_CRC4_ERROR_COUNT = 29;
    public static final int SECONDARY_CRC4_ERROR_RATE = 30;
    public static final int SECONDARY_CRC4_ERROR_SECONDS = 31;
    public static final int PRIMARY_EBIT_ERROR_COUNT = 32;
    public static final int PRIMARY_EBIT_ERROR_RATE = 33;
    public static final int PRIMARY_EBIT_ERROR_SECONDS = 34;
    public static final int SECONDARY_EBIT_ERROR_COUNT = 35;
    public static final int SECONDARY_EBIT_ERROR_RATE = 36;
    public static final int SECONDARY_EBIT_ERROR_SECONDS = 37;
    public static final int PRIMARY_SIGNAL_LOSS = 38;
    public static final int PRIMARY_FRAME_SYNC_LOSS = 39;
    public static final int PRIMARY_AIS = 40;
    public static final int PRIMARY_FAS = 41;
    public static final int PRIMARY_MFAS = 42;
    public static final int PRIMARY_TS16AIS = 43;
    public static final int SECONDARY_SIGNAL_LOSS = 44;
    public static final int SECONDARY_FRAME_SYNC_LOSS = 45;
    public static final int SECONDARY_AIS = 46;
    public static final int SECONDARY_FAS = 47;
    public static final int SECONDARY_MFAS = 48;
    public static final int SECONDARY_TS16AIS = 49;
    public static final int PRIMARY_ERROR_FREE = 50;
    public static final int PRIMARY_ERRORED = 51;
    public static final int PRIMARY_SEVERELY_ERRORED = 52;
    public static final int PRIMARY_AVAILABLE = 53;
    public static final int PRIMARY_UNAVAILABLE = 54;
    public static final int PRIMARY_DEGRADED_MINIMUM = 55;
    public static final int SECONDARY_ERROR_FREE = 56;
    public static final int SECONDARY_ERRORED = 57;
    public static final int SECONDARY_SEVERELY_ERRORED = 58;
    public static final int SECONDARY_AVAILABLE = 59;
    public static final int SECONDARY_UNAVAILABLE = 60;
    public static final int SECONDARY_DEGRADED_MINIMUM = 61;
    public static final int CLOCK_SLIPS = 62;
    public static final int CLOCK_SLIP_RATE = 63;
    public static final int PEAK_POSITIVE_WANDER = 64;
    public static final int PEAK_NEGATIVE_WANDER = 65;
    public static final int POSITIVE_FRAME_SLIPS = 66;
    public static final int NEGATIVE_FRAME_SLIPS = 67;
    public static final int BIT_ERRORS = 68;
    public static final int BIT_ERROR_RATE = 69;
    public static final int BIT_ERRORED_SECONDS = 70;
    public static final int PATTERN_SYNC_LOSS = 71;
    public static final int TEST_PATTERN = 72;
    public static final int TEST_DATA_RATE = 73;
    public static final int PRIMARY_PERCENT_ERROR_FREE_SECONDS = 74;
    public static final int PRIMARY_PERCENT_ERRORED_SECONDS = 75;
    public static final int PRIMARY_PERCENT_SEVERELY_ERRORED_SECONDS = 76;
    public static final int PRIMARY_PERCENT_AVAILABLE_SECONDS = 77;
    public static final int PRIMARY_PERCENT_UNAVAILABLE_SECONDS = 78;
    public static final int PRIMARY_PERCENT_DEGRADED_MINUTES = 79;
    public static final int SECONDARY_PERCENT_ERROR_FREE_SECONDS = 80;
    public static final int SECONDARY_PERCENT_ERRORED_SECONDS = 81;
    public static final int SECONDARY_PERCENT_SEVERELY_ERRORED_SECONDS = 82;
    public static final int SECONDARY_PERCENT_AVAILABLE_SECONDS = 83;
    public static final int SECONDARY_PERCENT_UNAVAILABLE_SECONDS = 84;
    public static final int SECONDARY_PERCENT_DEGRADED_MINUTES = 85;
    public static final int DELAY_UNIT_INTERVALS = 86;
    public static final int DELAY_MICRO_SECONDS = 87;
    public static final int DELAY_KILO_FEET = 88;
    public static final int DELAY_MILES = 89;
    public static final int SIG_BITS_START = 90;
    public static final int SIG_BITS_COUNT = 30;
    public static final int DELAY_KILOMETERS = 120;
    public BitFieldReading currentAlarmIndicators = new BitFieldReading();
    public BitFieldReading currentStatusIndicators = new BitFieldReading();
    public BitFieldReading currentErrorIndicators = new BitFieldReading();
    public BitFieldReading currentMiscellaneousIndicators = new BitFieldReading();
    public IntegerReading receivedLevelPeakToPeak = new IntegerReading();
    public IntegerReading receivedLevelDbdsx = new IntegerReading();
    public IntegerReading receivedFrequency = new IntegerReading();
    public IntegerReading elapsedTime = new IntegerReading();
    public IntegerReading primaryBpvErrorCount = new IntegerReading();
    public DoubleReading primaryBpvErrorRate = new DoubleReading();
    public IntegerReading primaryBpvErrorSeconds = new IntegerReading();
    public IntegerReading secondaryBpvErrorCount = new IntegerReading();
    public DoubleReading secondaryBpvErrorRate = new DoubleReading();
    public IntegerReading secondaryBpvErrorSeconds = new IntegerReading();
    public IntegerReading primaryFasErrorCount = new IntegerReading();
    public DoubleReading primaryFasError = new DoubleReading();
    public IntegerReading primaryFasErrorSeconds = new IntegerReading();
    public IntegerReading secondaryFasErrorCount = new IntegerReading();
    public DoubleReading secondaryFasError = new DoubleReading();
    public IntegerReading secondaryFasErrorSeconds = new IntegerReading();
    public IntegerReading primaryMfasErrorCount = new IntegerReading();
    public DoubleReading primaryMfasError = new DoubleReading();
    public IntegerReading primaryMfasErrorSeconds = new IntegerReading();
    public IntegerReading secondaryMfasErrorCount = new IntegerReading();
    public DoubleReading secondaryMfasError = new DoubleReading();
    public IntegerReading secondaryMfasErrorSeconds = new IntegerReading();
    public IntegerReading primaryCrc4ErrorCount = new IntegerReading();
    public DoubleReading primaryCrc4Error = new DoubleReading();
    public IntegerReading primaryCrc4ErrorSeconds = new IntegerReading();
    public IntegerReading secondaryCrc4ErrorCount = new IntegerReading();
    public DoubleReading secondaryCrc4Error = new DoubleReading();
    public IntegerReading secondaryCrc4ErrorSeconds = new IntegerReading();
    public IntegerReading primaryEbitErrorCount = new IntegerReading();
    public DoubleReading primaryEbitError = new DoubleReading();
    public IntegerReading primaryEbitErrorSeconds = new IntegerReading();
    public IntegerReading secondaryEbitErrorCount = new IntegerReading();
    public DoubleReading secondaryEbitError = new DoubleReading();
    public IntegerReading secondaryEbitErrorSeconds = new IntegerReading();
    public IntegerReading primarySignalLoss = new IntegerReading();
    public IntegerReading primaryFrameSyncLoss = new IntegerReading();
    public IntegerReading primaryAIS = new IntegerReading();
    public IntegerReading primaryFas = new IntegerReading();
    public IntegerReading primaryMfas = new IntegerReading();
    public IntegerReading primaryTs16Ais = new IntegerReading();
    public IntegerReading secondarySignalLoss = new IntegerReading();
    public IntegerReading secondaryFrameSyncLoss = new IntegerReading();
    public IntegerReading secondaryAIS = new IntegerReading();
    public IntegerReading secondaryFas = new IntegerReading();
    public IntegerReading secondaryMfas = new IntegerReading();
    public IntegerReading secondaryTs16Ais = new IntegerReading();
    public IntegerReading primaryErrorFree = new IntegerReading();
    public IntegerReading primaryErrored = new IntegerReading();
    public IntegerReading primarySeverelyErrored = new IntegerReading();
    public IntegerReading primaryAvailable = new IntegerReading();
    public IntegerReading primaryUnavailable = new IntegerReading();
    public IntegerReading primaryDegradedMinimum = new IntegerReading();
    public IntegerReading secondaryErrorFree = new IntegerReading();
    public IntegerReading secondaryErrored = new IntegerReading();
    public IntegerReading secondarySeverelyErrored = new IntegerReading();
    public IntegerReading secondaryAvailable = new IntegerReading();
    public IntegerReading secondaryUnavailable = new IntegerReading();
    public IntegerReading secondaryDegradedMinimum = new IntegerReading();
    public IntegerReading clockSlips = new IntegerReading();
    public DoubleReading clockSlipRate = new DoubleReading();
    public IntegerReading peakPositiveWander = new IntegerReading();
    public IntegerReading peakNegativeWander = new IntegerReading();
    public IntegerReading positiveFrameSlips = new IntegerReading();
    public IntegerReading negativeFrameSlips = new IntegerReading();
    public IntegerReading bitErrors = new IntegerReading();
    public DoubleReading bitError = new DoubleReading();
    public IntegerReading bitErroredSeconds = new IntegerReading();
    public IntegerReading patternSyncLoss = new IntegerReading();
    public IntegerReading testPattern = new IntegerReading();
    public IntegerReading testDataRate = new IntegerReading();
    public FloatReading primaryPercentErrorFreeSeconds = new FloatReading();
    public FloatReading primaryPercentErroredSeconds = new FloatReading();
    public FloatReading primaryPercentSeverelyErroredSeconds = new FloatReading();
    public FloatReading primaryPercentAvailableSeconds = new FloatReading();
    public FloatReading primaryPercentUnavailableSeconds = new FloatReading();
    public FloatReading primaryPercentDegradedMinutes = new FloatReading();
    public FloatReading secondaryPercentErrorFreeSeconds = new FloatReading();
    public FloatReading secondaryPercentErroredSeconds = new FloatReading();
    public FloatReading secondaryPercentSeverelyErroredSeconds = new FloatReading();
    public FloatReading secondaryPercentAvailableSeconds = new FloatReading();
    public FloatReading secondaryPercentUnavailableSeconds = new FloatReading();
    public FloatReading secondaryPercentDegradedMinutes = new FloatReading();
    public IntegerReading delayUnitIntervals = new IntegerReading();
    public IntegerReading delayMicroseconds = new IntegerReading();
    public IntegerReading delayKiloFeet = new IntegerReading();
    private FloatReading delayMiles = new FloatReading();
    private BitFieldReading[] sigBits = new BitFieldReading[30];
    private DoubleReading delayKilometers;
    private Reading[] readings;
    public static final int ALARM_LINE1_LOSS_OF_SIGNAL = 0;
    public static final int ALARM_LINE1_LOSS_OF_FRAME = 1;
    public static final int ALARM_LINE1_FAS_DISTANT = 2;
    public static final int ALARM_LINE1_MFAS_DISTANT = 3;
    public static final int ALARM_LINE1_AIS = 4;
    public static final int ALARM_LINE1_TS16_AIS = 5;
    public static final int ALARM_LINE2_LOSS_OF_SIGNAL = 8;
    public static final int ALARM_LINE2_LOSS_OF_FRAME = 9;
    public static final int ALARM_LINE2_FAS_DISTANT = 10;
    public static final int ALARM_LINE2_MFAS_DISTANT = 11;
    public static final int ALARM_LINE2_AIS = 12;
    public static final int ALARM_LINE2_TS16_AIS = 13;
    public static final int ALARM_LINE1_LOSS_OF_SIGNAL_HISTORY = 16;
    public static final int ALARM_LINE1_LOSS_OF_FRAME_HISTORY = 17;
    public static final int ALARM_LINE1_FAS_DISTANT_HISTORY = 18;
    public static final int ALARM_LINE1_MFAS_DISTANT_HISTORY = 19;
    public static final int ALARM_LINE1_AIS_HISTORY = 20;
    public static final int ALARM_LINE1_TS16_AIS_HISTORY = 21;
    public static final int ALARM_LINE2_LOSS_OF_SIGNAL_HISTORY = 24;
    public static final int ALARM_LINE2_LOSS_OF_FRAME_HISTORY = 25;
    public static final int ALARM_LINE2_FAS_DISTANT_HISTORY = 26;
    public static final int ALARM_LINE2_MFAS_DISTANT_HISTORY = 27;
    public static final int ALARM_LINE2_AIS_HISTORY = 28;
    public static final int ALARM_LINE2_TS16_AIS_HISTORY = 29;
    public static final int STATUS_LINE1_PULSES = 0;
    public static final int STATUS_LINE1_HDB3 = 1;
    public static final int STATUS_LINE1_FAS_SYNC = 2;
    public static final int STATUS_LINE1_MFAS_SYNC = 3;
    public static final int STATUS_LINE1_CRC4_SYNC = 4;
    public static final int STATUS_LINE1_ALARMS = 5;
    public static final int STATUS_LINE1_ERRORS = 6;
    public static final int STATUS_LINE1_AIS = 7;
    public static final int STATUS_LINE2_PULSES = 8;
    public static final int STATUS_LINE2_HDB3 = 9;
    public static final int STATUS_LINE2_FAS_SYNC = 10;
    public static final int STATUS_LINE2_MFAS_SYNC = 11;
    public static final int STATUS_LINE2_CRC4_SYNC = 12;
    public static final int STATUS_LINE2_ALARMS = 13;
    public static final int STATUS_LINE2_ERRORS = 14;
    public static final int STATUS_LINE2_AIS = 15;
    public static final int STATUS_LINE1_PULSES_HISTORY = 16;
    public static final int STATUS_LINE1_HDB3_HISTORY = 17;
    public static final int STATUS_LINE1_FAS_SYNC_HISTORY = 18;
    public static final int STATUS_LINE1_MFAS_SYNC_HISTORY = 19;
    public static final int STATUS_LINE1_CRC4_SYNC_HISTORY = 20;
    public static final int STATUS_LINE1_ALARMS_HISTORY = 21;
    public static final int STATUS_LINE1_ERRORS_HISTORY = 22;
    public static final int STATUS_LINE1_AIS_HISTORY = 23;
    public static final int STATUS_LINE2_PULSES_HISTORY = 24;
    public static final int STATUS_LINE2_HDB3_HISTORY = 25;
    public static final int STATUS_LINE2_FAS_SYNC_HISTORY = 26;
    public static final int STATUS_LINE2_MFAS_SYNC_HISTORY = 27;
    public static final int STATUS_LINE2_CRC4_SYNC_HISTORY = 28;
    public static final int STATUS_LINE2_ALARMS_HISTORY = 29;
    public static final int STATUS_LINE2_ERRORS_HISTORY = 30;
    public static final int STATUS_LINE2_AIS_HISTORY = 31;
    public static final int ERROR_LINE1_BPV = 0;
    public static final int ERROR_LINE1_FAS = 1;
    public static final int ERROR_LINE1_MFAS = 2;
    public static final int ERROR_LINE1_CRC4 = 3;
    public static final int ERROR_LINE1_EBIT = 4;
    public static final int ERROR_LINE1_PATTERN_ERRORS = 5;
    public static final int ERROR_LINE2_BPV = 8;
    public static final int ERROR_LINE2_FAS = 9;
    public static final int ERROR_LINE2_MFAS = 10;
    public static final int ERROR_LINE2_CRC4 = 11;
    public static final int ERROR_LINE2_EBIT = 12;
    public static final int ERROR_LINE2_PATTERN_ERRORS = 13;
    public static final int ERROR_LINE1_BPV_HISTORY = 16;
    public static final int ERROR_LINE1_FAS_HISTORY = 17;
    public static final int ERROR_LINE1_MFAS_HISTORY = 18;
    public static final int ERROR_LINE1_CRC4_HISTORY = 19;
    public static final int ERROR_LINE1_EBIT_HISTORY = 20;
    public static final int ERROR_LINE1_PATTERN_ERRORS_HISTORY = 21;
    public static final int ERROR_LINE2_BPV_HISTORY = 24;
    public static final int ERROR_LINE2_FAS_HISTORY = 25;
    public static final int ERROR_LINE2_MFAS_HISTORY = 26;
    public static final int ERROR_LINE2_CRC4_HISTORY = 27;
    public static final int ERROR_LINE2_EBIT_HISTORY = 28;
    public static final int ERROR_LINE2_PATTERN_ERRORS_HISTORY = 29;
    public static final int MISC_PATTERN_SYNC = 0;
    public static final int MISC_PATTERN_ERRORS_LED_BASED = 1;
    public static final int MISC_ALARM_ERROR_INJECTION = 2;
    public static final int MISC_PATTERN_INVERTED = 3;
    public static final int MISC_RUNNING = 4;
    public static final int MISC_PATTERN_SYNC_HISTORY = 5;
    public static final int MISC_PATTERN_ERRORS_HISTORY = 6;
    public static final int MISC_PATTERN_INVERTED_HISTORY = 7;
    public static final int MISC_HISTORY_MEMORY_FULL = 8;
    public static final int MISC_LOOPBACK_INDICATOR = 9;
    public static final int MISC_PATTERN_ERRORS = 10;
    public static final int MISC_CLOCK_FRAME_SLIPS = 11;
    public static final int MISC_LINE_ONE_ERRORS = 12;
    public static final int MISC_LINE_ONE_ALARMS = 13;
    public static final int MISC_LINE_TWO_ERRORS = 14;
    public static final int MISC_LINE_TWO_ALARMS = 15;
    public static final int MISC_LINE_COMMAND_ERROR = 16;
    public static final int MISC_POWER_UP_SELF_TEST_FAILED = 17;
    public static final int MISC_ROM_TEST_FAIL = 18;
    public static final int MISC_RAM_TEST_FAIL = 19;
    public static final int MISC_SELF_TEST_FAIL = 20;

    public E1Measurement() {
        for (int i = 0; i < this.sigBits.length; ++i) {
            this.sigBits[i] = new BitFieldReading();
        }
        this.delayKilometers = new DoubleReading();
        this.readings = new Reading[]{this.currentAlarmIndicators, this.currentStatusIndicators, this.currentErrorIndicators, this.currentMiscellaneousIndicators, this.receivedLevelPeakToPeak, this.receivedLevelDbdsx, this.receivedFrequency, this.elapsedTime, this.primaryBpvErrorCount, this.primaryBpvErrorRate, this.primaryBpvErrorSeconds, this.secondaryBpvErrorCount, this.secondaryBpvErrorRate, this.secondaryBpvErrorSeconds, this.primaryFasErrorCount, this.primaryFasError, this.primaryFasErrorSeconds, this.secondaryFasErrorCount, this.secondaryFasError, this.secondaryFasErrorSeconds, this.primaryMfasErrorCount, this.primaryMfasError, this.primaryMfasErrorSeconds, this.secondaryMfasErrorCount, this.secondaryMfasError, this.secondaryMfasErrorSeconds, this.primaryCrc4ErrorCount, this.primaryCrc4Error, this.primaryCrc4ErrorSeconds, this.secondaryCrc4ErrorCount, this.secondaryCrc4Error, this.secondaryCrc4ErrorSeconds, this.primaryEbitErrorCount, this.primaryEbitError, this.primaryEbitErrorSeconds, this.secondaryEbitErrorCount, this.secondaryEbitError, this.secondaryEbitErrorSeconds, this.primarySignalLoss, this.primaryFrameSyncLoss, this.primaryAIS, this.primaryFas, this.primaryMfas, this.primaryTs16Ais, this.secondarySignalLoss, this.secondaryFrameSyncLoss, this.secondaryAIS, this.secondaryFas, this.secondaryMfas, this.secondaryTs16Ais, this.primaryErrorFree, this.primaryErrored, this.primarySeverelyErrored, this.primaryAvailable, this.primaryUnavailable, this.primaryDegradedMinimum, this.secondaryErrorFree, this.secondaryErrored, this.secondarySeverelyErrored, this.secondaryAvailable, this.secondaryUnavailable, this.secondaryDegradedMinimum, this.clockSlips, this.clockSlipRate, this.peakPositiveWander, this.peakNegativeWander, this.positiveFrameSlips, this.negativeFrameSlips, this.bitErrors, this.bitError, this.bitErroredSeconds, this.patternSyncLoss, this.testPattern, this.testDataRate, this.primaryPercentErrorFreeSeconds, this.primaryPercentErroredSeconds, this.primaryPercentSeverelyErroredSeconds, this.primaryPercentAvailableSeconds, this.primaryPercentUnavailableSeconds, this.primaryPercentDegradedMinutes, this.secondaryPercentErrorFreeSeconds, this.secondaryPercentErroredSeconds, this.secondaryPercentSeverelyErroredSeconds, this.secondaryPercentAvailableSeconds, this.secondaryPercentUnavailableSeconds, this.secondaryPercentDegradedMinutes, this.delayUnitIntervals, this.delayMicroseconds, this.delayKiloFeet, this.delayMiles, this.sigBits[0], this.sigBits[1], this.sigBits[2], this.sigBits[3], this.sigBits[4], this.sigBits[5], this.sigBits[6], this.sigBits[7], this.sigBits[8], this.sigBits[9], this.sigBits[10], this.sigBits[11], this.sigBits[12], this.sigBits[13], this.sigBits[14], this.sigBits[15], this.sigBits[16], this.sigBits[17], this.sigBits[18], this.sigBits[19], this.sigBits[20], this.sigBits[21], this.sigBits[22], this.sigBits[23], this.sigBits[24], this.sigBits[25], this.sigBits[26], this.sigBits[27], this.sigBits[28], this.sigBits[29], this.delayKilometers};
    }

    public Reading[] getReadings() {
        return this.readings;
    }

    public static E1Measurement unpack(DataInput dataInput) throws IOException {
        E1Measurement e1Measurement = E1Measurement.create();
        Reading[] readingArray = e1Measurement.getReadings();
        for (int i = 0; i < readingArray.length - NUM_COMPUTED_READINGS; ++i) {
            readingArray[i].unpack(dataInput);
        }
        e1Measurement.setDelayKilometers();
        return e1Measurement;
    }

    void setDelayKilometers() {
        double d = 1.0E-5;
        double d2 = this.delayMiles.floatValue() - -1.0f;
        double d3 = -1.0;
        if (Math.abs(d2) > d) {
            d3 = E1Measurement.convertMilesToKilometers(this.delayMiles.floatValue());
        }
        this.delayKilometers.setValue(d3);
    }

    private static double convertMilesToKilometers(float f) {
        return (double)f * 1.61;
    }

    static E1Measurement create() {
        E1Measurement e1Measurement = (E1Measurement)pool.dequeue();
        if (e1Measurement == null) {
            return new E1Measurement();
        }
        return e1Measurement;
    }

    public String getMeasurementTitle() {
        return Text.E1;
    }

    public void recycle() {
        pool.enqueue(this);
    }

    int getCurrentAlarmIndicators() {
        return this.currentAlarmIndicators.intValue();
    }

    public void setCurrentAlarmIndicator(int n, boolean bl) {
        this.currentAlarmIndicators.setBitValue(n, bl);
    }

    void setCurrentAlarmIndicators(int n) {
        this.currentAlarmIndicators.setValue(n);
    }

    int getCurrentStatusIndicators() {
        return this.currentStatusIndicators.intValue();
    }

    void setCurrentStatusIndicators(int n) {
        this.currentStatusIndicators.setValue(n);
    }

    int getCurrentErrorIndicators() {
        return this.currentErrorIndicators.intValue();
    }

    void setCurrentErrorIndicators(int n) {
        this.currentErrorIndicators.setValue(n);
    }

    int getMiscellaneousIndicatorsAsInteger() {
        return this.currentMiscellaneousIndicators.intValue();
    }

    BitFieldReading getMiscellaneousIndicators() {
        return this.currentMiscellaneousIndicators;
    }

    void setMiscellaneousIndicators(int n) {
        this.currentMiscellaneousIndicators.setValue(n);
    }

    public int getTestPattern() {
        return this.testPattern.intValue();
    }

    public boolean getCurrentStatusIndicator(int n) {
        return this.currentStatusIndicators.bitValue(n);
    }

    protected int getRomTestBit() {
        return 18;
    }

    protected int getRamTestBit() {
        return 19;
    }

    protected int getSelfTestBit() {
        return 20;
    }
}

