/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.commChannel.Command;
import elgato.infrastructure.measurement.Measurement;
import elgato.infrastructure.measurement.RangeValidator;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.RuntimeConfiguration;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.E1Measurement;

public class E1MeasurementSettings
extends CommonBackhaulMeasurementSettings {
    private static E1MeasurementSettings instance;
    private static final Logger _logger;
    public static final String TOPIC = "e1Analyzer";
    public static final String TOPIC_DISPLAY = "display.e1Analyzer";
    private static final String KEY_INVERTED_PATTERN = "invertPattern";
    private static final String KEY_TS_NUM = "tsNum";
    private static final String KEY_MONITOR_SOURCE = "monSrc";
    public static final String KEY_STATE = "e1State";
    public static final int VALUE_END_TO_END_FULL_E1 = 0;
    public static final int VALUE_END_TO_END_CHANNEL = 1;
    public static final int VALUE_END_TO_END_CHANNEL_TONE = 2;
    public static final int VALUE_MONITOR_FULL_E1 = 3;
    public static final int VALUE_MONITOR_CHANNEL = 4;
    public static final int VALUE_MONITOR_CHANNEL_TONE = 5;
    public static final int VALUE_DROP_AND_INSERT_CHANNEL = 6;
    public static final int VALUE_DROP_AND_INSERT_CHANNEL_TONE = 7;
    public static final int VALUE_DELAY = 8;
    public static final int VALUE_LINE_CODE_NA = 2;
    public static final int VALUE_LINE_CODE_HDB3 = 1;
    public static final int VALUE_LINE_CODE_AMI = 0;
    public static int VALUE_E1_LOSS_OF_SIGNAL;
    public static int VALUE_E1_LOSS_OF_FRAME;
    public static int VALUE_E1_FAS_DISTANT_ALARM;
    public static int VALUE_E1_MFAS_DISTANT_ALARM;
    public static int VALUE_E1_AIS_ALARM;
    public static int VALUE_E1_TS_16_AIS_ALARM;
    public static int VALUE_E1_BPV_ERROR;
    public static int VALUE_E1_FAS_ERROR;
    public static int VALUE_E1_MFAS_ERROR;
    public static int VALUE_E1_CRC4_ERROR;
    public static int VALUE_E1_FEB_ERROR;
    public static int VALUE_E1_PATTERN_ERROR;
    private static final int VALUE_INVERT_NO = 0;
    private static final int VALUE_INVERT_YES = 1;
    private ListActuator invertedPattern;
    private LongActuator timeslot;
    private ListActuator monitorSource;
    public static final int VALUE_FRAMING_UNFRAMED = 0;
    public static final int VALUE_FRAMING_PCM30 = 1;
    public static final int VALUE_FRAMING_PCM30_AND_CRC4 = 2;
    public static final int VALUE_FRAMING_PCM31 = 3;
    public static final int VALUE_FRAMING_PCM31_AND_CRC4 = 4;
    public static final int VALUE_TEST_PATTERN_2E61 = 0;
    public static final int VALUE_TEST_PATTERN_2E91 = 1;
    public static final int VALUE_TEST_PATTERN_2E111 = 2;
    public static final int VALUE_TEST_PATTERN_2E151 = 3;
    public static final int VALUE_TEST_PATTERN_2E201 = 4;
    public static final int VALUE_TEST_PATTERN_QRSS = 5;
    public static final int VALUE_TEST_PATTERN_2E231 = 6;
    public static final int VALUE_TEST_PATTERN_ALL0S = 7;
    public static final int VALUE_TEST_PATTERN_1_7 = 8;
    public static final int VALUE_TEST_PATTERN_1_3 = 9;
    public static final int VALUE_TEST_PATTERN_1_1 = 10;
    public static final int VALUE_TEST_PATTERN_ALL1S = 11;
    public static final int VALUE_TEST_PATTERN_UNKNOWN = 12;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_SUMMARY = 0;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_ERROR_SUMMARY = 1;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_LEVEL_FREQUENCY = 2;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_BPV_FAS_ERRORS = 3;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_MFAS_ERRORS = 4;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_CRC_EBITS = 5;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_ALARM_SECONDS = 6;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_PERFORMANCE = 7;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_CLOCK_FRAME_SLIPS = 8;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_TEST_PATTERN = 9;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_VF_CHANNEL_ACCESS = 10;
    public static final int VALUE_DISPLAYED_RESULTS_PRIMARY_30_CHANNEL_SIGNALING = 11;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_SUMMARY = 12;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_ERROR_SUMMARY = 13;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_BPV_FRAME_ERRORS = 14;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_CRC_ERRORS = 15;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_ALARM_SECONDS = 16;
    public static final int VALUE_DISPLAYED_RESULTS_SECONDARY_PERFORMANCE = 17;
    static /* synthetic */ Class class$elgato$measurement$backhaul$E1MeasurementSettings;

    public E1MeasurementSettings() {
        super(TOPIC);
    }

    protected void addAdditionalActuators() {
        this.createActuators();
        this.add(this.controlMode);
        this.add(this.lineCode);
        this.add(this.framing);
        this.add(this.invertedPattern);
        this.add(this.testPattern);
        this.add(this.injectType);
        this.add(this.monitorSource);
        this.add(this.timeslot);
    }

    protected Value[] getResultValues() {
        return new Value[]{Value.createValue(Text.Pri_Summary, Text.Primary_Summary, 0), Value.createValue(Text.Pri + " " + Text.Lev_slash_Freq, Text.Primary + " " + Text.Level_Frequency, 2), Value.createValue(Text.Pri_Error, Text.Primary_Error_Summary, 1), Value.createValue(Text.Sec_Error, Text.Secondary + " " + Text.Error_Summary, 13), Value.createValue(Text.BPV_andSymbol_FAS, Text.Primary + " " + Text.BPV_andSymbol_FAS, 3), Value.createValue(Text.BPV_slash_FAS_Err, Text.Secondary + " " + Text.BPV_andSymbol_FAS, 14), Value.createValue(Text.CRC4_andSymbol_EBit, Text.Primary + " " + Text.CRC4_andSymbol_EBit, 5), Value.createValue(Text.CRC4_andSymbol_EBit, Text.Secondary + " " + Text.CRC4_andSymbol_EBit, 15), Value.createValue(Text.Pri + " " + Text.Alarm, Text.Primary + " " + Text.Alarm_Seconds, 6), Value.createValue(Text.Sec + " " + Text.Alarm, Text.Secondary + " " + Text.Alarm_Seconds, 16), Value.createValue(Text.Pri + " " + Text.Perform, Text.Primary + " " + Text.Performance, 7), Value.createValue(Text.Sec + " " + Text.Perform, Text.Secondary + " " + Text.Performance, 17), Value.createValue(Text.Pri + " " + Text.Clock, Text.Primary + " " + Text.Clock_and_Frame_Slips, 8), Value.createValue(Text.Pri + " " + Text.Pattern, Text.Primary + " " + Text.Test_Pattern, 9)};
    }

    public boolean isMonitorMode() {
        int n = this.controlMode.intValue();
        return n == 4 || n == 5 || n == 3;
    }

    public boolean isAlarmType(int n) {
        return n == VALUE_E1_LOSS_OF_SIGNAL || n == VALUE_E1_LOSS_OF_FRAME || n == VALUE_E1_FAS_DISTANT_ALARM || n == VALUE_E1_MFAS_DISTANT_ALARM || n == VALUE_E1_AIS_ALARM || n == VALUE_E1_TS_16_AIS_ALARM;
    }

    public boolean isChannelMode() {
        return this.controlMode.intValue() == 6 || this.controlMode.intValue() == 7 || this.controlMode.intValue() == 4 || this.controlMode.intValue() == 5 || this.controlMode.intValue() == 1 || this.controlMode.intValue() == 2;
    }

    public boolean isDelayMode() {
        return this.controlMode.intValue() == 8;
    }

    public boolean isLoopbackMode() {
        return false;
    }

    public boolean isEmulateMode() {
        return false;
    }

    private void createActuators() {
        this.monitorSource = new ListActuator(TOPIC, KEY_MONITOR_SOURCE, Text.Monitor, new Value[]{Value.createValue(Text.Primary, 0), Value.createValue(Text.Secondary, 1), Value.createValue(Text.Both, 2)});
        this.controlMode = new ListActuator(this.getTopic(), "mode", Text.Control, new Value[]{Value.createValue(Text.Full_E1_n_BERT, 0), Value.createValue(Text.Hard_Loop_slash_End_End_Channel_BERT, 1), Value.createValue(Text.Hard_Loop_slash_End_End_Channel_Tone, 2), Value.createValue(Text.Monitor_n_Full_E1, 3), Value.createValue(Text.Monitor_Channel, 4), Value.createValue(Text.Monitor_Channel_Tone, 5), Value.createValue(Text.Drop_and_Insert_Channel, 6), Value.createValue(Text.Drop_and_Insert_Channel_Tone, 7), Value.createValue(Text.Delay, 8)});
        this.lineCode = new ListActuator(TOPIC, "lineCoding", Text.Line_Code, new Value[]{Value.createValue(Text.AMI, 0), Value.createValue(Text.HDB3, 1), Value.createValue(Text.NA, 2)});
        this.framing = new ListActuator(TOPIC, "frameFormat", Text.Framing, new Value[]{Value.createValue(Text.Unframed, 0), Value.createValue(Text.PCM30, 1), Value.createValue(Text.PCM30_n_plus_CRC4, 2), Value.createValue(Text.PCM31, 3), Value.createValue(Text.PCM31_n_plus_CRC4, 4)});
        this.testPattern = new ListActuator(TOPIC, "testPattern", Text.Pattern, new Value[]{Value.createValue(Text._2E6_1, 0), Value.createValue(Text._2E9_1, 1), Value.createValue(Text._2E11_1, 2), Value.createValue(Text._2E15_1, 3), Value.createValue(Text._2E20_1, 4), Value.createValue(Text.QRSS, 5), Value.createValue(Text._2E23_1, 6), Value.createValue(Text.All_0s, 7), Value.createValue(Text._1_colon_7, 8), Value.createValue(Text._1_colon_3, 9), Value.createValue(Text._1_colon_1, 10), Value.createValue(Text.All_1s, 11), Value.createValue(Text.Unknown_Pattern_live, 12)});
        this.invertedPattern = new ListActuator(TOPIC, KEY_INVERTED_PATTERN, Text.TX_Pattern, new Value[]{Value.createValue(Text.Normal, 0), Value.createValue("Invert", 1)});
        this.timeslot = new LongActuator(TOPIC, KEY_TS_NUM, Text.Timeslot);
        this.timeslot.setValidator(new RangeValidator(0L, 31L));
        this.injectType = new ListActuator(TOPIC, "injectType", Text.Alarm_slash_Error, new Value[]{Value.createValue(Text.Loss_of_Signal, Text.Loss_of_Signal_Alarm, VALUE_E1_LOSS_OF_SIGNAL), Value.createValue(Text.Loss_of_Frame, Text.Loss_of_Frame_Alarm, VALUE_E1_LOSS_OF_FRAME), Value.createValue(Text.FAS_Distant, Text.FAS_Distant_Alarm, VALUE_E1_FAS_DISTANT_ALARM), Value.createValue(Text.MFAS_Distant, Text.MFAS_Distant_Alarm, VALUE_E1_MFAS_DISTANT_ALARM), Value.createValue(Text.AIS, Text.AIS_Alarm, VALUE_E1_AIS_ALARM), Value.createValue(Text.TS_16_AIS, Text.TS_16_AIS_Alarm, VALUE_E1_TS_16_AIS_ALARM), Value.createValue(Text.Code_BPV, Text.BPV_Error, VALUE_E1_BPV_ERROR), Value.createValue(Text.FAS, Text.FAS_Error, VALUE_E1_FAS_ERROR), Value.createValue(Text.MFAS, Text.MFAS_Error, VALUE_E1_MFAS_ERROR), Value.createValue(Text.CRC_4, Text.CRC_4_Error, VALUE_E1_CRC4_ERROR), Value.createValue(Text.FEB_E_Bit, Text.FEB_E_Bit_Error, VALUE_E1_FEB_ERROR), Value.createValue(Text.Pattern, Text.Pattern_Error, VALUE_E1_PATTERN_ERROR)});
    }

    public void measurementReceived(Measurement measurement) {
        _logger.debug("E1Measurement received.");
        if (RuntimeConfiguration.runningInStubMode()) {
            return;
        }
        E1Measurement e1Measurement = (E1Measurement)measurement;
        this.setPulses(e1Measurement.getCurrentStatusIndicator(0));
        if (e1Measurement.getTestPattern() == 12) {
            this.testPattern.send();
        }
    }

    public void commandReceived(Command command) {
        int n = this.testPattern.getSelectedValue().intValue();
        int n2 = this.lineCode.getSelectedValue().intValue();
        super.commandReceived(command);
        if (this.newTestPatternUnknown(command)) {
            this.testPattern.send(n);
            if (!this.newLineCodeHDB3(command)) {
                this.lineCode.send(n2);
            }
        } else if (this.newLineCodeNA(command, 2)) {
            this.lineCode.send(n2);
        }
    }

    private boolean newLineCodeHDB3(Command command) {
        String string;
        return command.propertyExists(this.lineCode.getPropertyName()) && (string = command.getProperty(this.lineCode.getPropertyName())) != null && Integer.parseInt(command.getProperty(this.lineCode.getPropertyName())) == 1;
    }

    private boolean newTestPatternUnknown(Command command) {
        String string;
        return command.propertyExists(this.testPattern.getPropertyName()) && (string = command.getProperty(this.testPattern.getPropertyName())) != null && Integer.parseInt(string) == 12;
    }

    public static E1MeasurementSettings instance() {
        if (instance == null) {
            instance = new E1MeasurementSettings();
        }
        return instance;
    }

    public static void setInstance(E1MeasurementSettings e1MeasurementSettings) {
        instance = e1MeasurementSettings;
    }

    public ListActuator getInvertedPattern() {
        return this.invertedPattern;
    }

    public LongActuator getTimeslot() {
        return this.timeslot;
    }

    public ListActuator getInjectType() {
        return this.injectType;
    }

    public ListActuator getMonitorSource() {
        return this.monitorSource;
    }

    public boolean isUnframed() {
        return this.framing.intValue() == 0;
    }

    public boolean isPCM30Framed() {
        return this.framing.intValue() == 1;
    }

    public boolean isPCM31Framed() {
        return this.framing.intValue() == 3;
    }

    public boolean isPCM31plusCRC4Framed() {
        return this.framing.intValue() == 4;
    }

    public boolean isBPVErrorInjectType() {
        return this.injectType.intValue() == VALUE_E1_BPV_ERROR;
    }

    public boolean isFEBErrorInjectType() {
        return this.injectType.intValue() == VALUE_E1_FEB_ERROR;
    }

    public boolean isCRC4ErrorInjectType() {
        return this.injectType.intValue() == VALUE_E1_CRC4_ERROR;
    }

    public boolean isMFASErrorInjectType() {
        return this.injectType.intValue() == VALUE_E1_MFAS_ERROR;
    }

    public boolean isMFASDistantAlarmInjectType() {
        return this.injectType.intValue() == VALUE_E1_MFAS_DISTANT_ALARM;
    }

    public boolean isAISInjectType() {
        return this.injectType.intValue() == VALUE_E1_AIS_ALARM;
    }

    public boolean isTS16InjectType() {
        return this.injectType.intValue() == VALUE_E1_TS_16_AIS_ALARM;
    }

    public boolean isLOSAlarm() {
        return this.injectType.intValue() == VALUE_E1_LOSS_OF_SIGNAL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogManager.getLogger(class$elgato$measurement$backhaul$E1MeasurementSettings == null ? (class$elgato$measurement$backhaul$E1MeasurementSettings = E1MeasurementSettings.class$("elgato.measurement.backhaul.E1MeasurementSettings")) : class$elgato$measurement$backhaul$E1MeasurementSettings);
        VALUE_E1_LOSS_OF_SIGNAL = 1;
        VALUE_E1_LOSS_OF_FRAME = 2;
        VALUE_E1_FAS_DISTANT_ALARM = 3;
        VALUE_E1_MFAS_DISTANT_ALARM = 4;
        VALUE_E1_AIS_ALARM = 5;
        VALUE_E1_TS_16_AIS_ALARM = 6;
        VALUE_E1_BPV_ERROR = 7;
        VALUE_E1_FAS_ERROR = 8;
        VALUE_E1_MFAS_ERROR = 9;
        VALUE_E1_CRC4_ERROR = 10;
        VALUE_E1_FEB_ERROR = 11;
        VALUE_E1_PATTERN_ERROR = 12;
    }
}

