/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.menu.DynamicMenuButton;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.SimpleMenuButton;
import elgato.infrastructure.menu.SubMenuButton;
import elgato.infrastructure.util.Text;
import elgato.measurement.backhaul.CommonBackhaulMenuMgr;
import elgato.measurement.backhaul.E1Analyzer;
import elgato.measurement.backhaul.E1ControlMenuFactory;
import elgato.measurement.backhaul.E1MeasurementSettings;
import elgato.measurement.backhaul.E1Screen;

public class E1MenuMgr
extends CommonBackhaulMenuMgr {
    public E1MenuMgr(E1Screen e1Screen, E1MeasurementSettings e1MeasurementSettings, E1Analyzer e1Analyzer) {
        super(e1Screen, e1MeasurementSettings, e1Analyzer);
    }

    public Menu buildLeftMenu() {
        this.menuFactory = new E1ControlMenuFactory((E1Screen)this.scn);
        this.controlMenuButton = this.menuFactory.createControlMenuButton();
        return new Menu(this.getLeftMenuName(), new MenuItem[]{this.createTestModeMenuButton(), this.getAutoConfigButton(), this.createSetupButton(), this.createDisplayButton(), this.controlMenuButton, this.createTestsButton(), this.createRestartButton()});
    }

    public MenuItem createTestModeMenuButton() {
        SimpleMenuButton simpleMenuButton = new SimpleMenuButton(Text.Get_Started_slash_n_Test_Mode, this.getContextString("test.mode"), new Menu(Text.Test_Mode, new MenuItem[]{this.createGetStartedButton("E1ModeDisplayMain.html"), this.createEndToEndManLoopModeButton(), this.createMonitorModeButton(), this.createDelayModeButton(), null, null, null}));
        simpleMenuButton.addActionListener(this.createLoadBackhaulAnalyzerActionListener());
        return simpleMenuButton;
    }

    protected SubMenuButton createDelayModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Delay, this.getContextString("test.mode"), "E1ModeDelay.html", new Menu(Text.Delay, new MenuItem[]{this.createModeActionButton(Text.Full_E1, "delay.full", 8), null, null, null, null, null, null}));
    }

    protected SubMenuButton createEndToEndManLoopModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Hard_Loop_n_End_End, this.getContextString("test.mode"), "E1ModeEndToEndManLoop.html", new Menu(Text.Hard_Loop, new MenuItem[]{this.createModeActionButton(Text.Full_E1_n_BERT, "full.backhaul.bert", 0), this.createModeActionButton(Text.Channel_n_Bert, "channel.bert", 1), null, null, null, null, null}));
    }

    protected SubMenuButton createMonitorModeButton() {
        return new CommonBackhaulMenuMgr.SubMenuButtonWithDisplay(Text.Monitor, this.getContextString("test.mode"), "E1ModeMonitor.html", new Menu(Text.Monitor, new MenuItem[]{this.createModeActionButton(Text.Monitor_n_Full_E1, "monitor.full.backhaul.bert", 3), this.createModeActionButton(Text.Monitor_n_Channel, "monitor.channel.bert", 4), null, null, null, null, null}));
    }

    protected Menu[] createDisplayMenus() {
        Menu[] menuArray = new Menu[]{new Menu(Text.Display, new MenuItem[]{this.statusButton, this.alarmsButton, this.createResultsButton(), null, null, this.soundButton, this.volumeButton}), new Menu(Text.Display, new MenuItem[0])};
        return menuArray;
    }

    protected DynamicMenuButton.MenuSelector createMap() {
        return new DynamicMenuButton.MenuSelector(){

            public int getCurrentMenuIndex() {
                return E1MenuMgr.this.settings.isDelayMode() ? 1 : 0;
            }
        };
    }

    protected String getMeasurementName() {
        return "e1Analyzer";
    }

    protected String getLeftMenuName() {
        return Text.E1_Analyzer;
    }
}

