/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.LogManager;
import elgato.infrastructure.util.Logger;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.LED;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.ReadingBitRow;
import elgato.measurement.backhaul.ResultPanel;
import elgato.measurement.backhaul.StatusProvider;
import elgato.measurement.backhaul.TwoReadingRow;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JPanel;

public class LEDResultPanel
extends ResultPanel {
    Logger logger = LogManager.getLogger(class$elgato$measurement$backhaul$LEDResultPanel == null ? (class$elgato$measurement$backhaul$LEDResultPanel = LEDResultPanel.class$("elgato.measurement.backhaul.LEDResultPanel")) : class$elgato$measurement$backhaul$LEDResultPanel);
    private int rowHeight = 0;
    private ReadingBitRow[] rows;
    private ReadingField[] readingFields = new ReadingField[0];
    private ELabel[] rowELabels;
    static /* synthetic */ Class class$elgato$measurement$backhaul$LEDResultPanel;

    public LEDResultPanel(int n, String string, String string2, String string3, ReadingBitRow[] readingBitRowArray, int n2) {
        super(n, string, string2 + " " + string3, string2 + ": " + string3);
        this.rows = readingBitRowArray;
        this.rowHeight = n2;
        this.initELabels();
    }

    public LEDResultPanel(int n, String string, String string2, String string3, ReadingBitRow[] readingBitRowArray, ReadingField[] readingFieldArray, TwoReadingRow[] twoReadingRowArray, int n2) {
        super(n, string, string2, string3, readingFieldArray, twoReadingRowArray);
        this.readingFields = readingFieldArray;
        this.rows = readingBitRowArray;
        this.rowHeight = n2;
        this.initELabels();
    }

    public LEDResultPanel(int n, String string, String string2, ReadingBitRow[] readingBitRowArray, int n2) {
        super(n, string, string2);
        this.rows = readingBitRowArray;
        this.rowHeight = n2;
        this.initELabels();
    }

    private void initELabels() {
        this.rowELabels = new ELabel[this.rows.length];
        for (int i = 0; i < this.rows.length; ++i) {
            this.rowELabels[i] = this.createLabel(this.rows[i].getLabel());
        }
    }

    protected Component createResultsSubPanel() {
        return this.createLEDTableWithHistory(100.0f);
    }

    ReadingBitRow[] getRows() {
        return this.rows;
    }

    TabDelimitable[] getTabDelimitedFields() {
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[this.rows.length + this.twoReadingRows.length + this.readingFields.length];
        System.arraycopy(this.rows, 0, tabDelimitableArray, 0, this.rows.length);
        System.arraycopy(this.twoReadingRows, 0, tabDelimitableArray, this.rows.length, this.twoReadingRows.length);
        System.arraycopy(this.readingFields, 0, tabDelimitableArray, this.rows.length + this.twoReadingRows.length, this.readingFields.length);
        return tabDelimitableArray;
    }

    protected Component createLEDTableWithHistory(float f) {
        StatusProvider[] statusProviderArray;
        int n;
        float f2 = 25.0f;
        float[][] fArrayArray = new float[][]{{f, 13.0f, 32.0f, 13.0f, 32.0f, f2, -1.0f, -2.0f}, new float[0]};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        ((Component)jPanel).setBackground(null);
        int n2 = -1;
        ELabel eLabel = new ELabel(Text.History, Color.yellow, PanelProperties.HISTORY_FONT);
        eLabel.setHAlignment(2);
        tableLayout.insertRow(++n2, -2.0f);
        jPanel.add((Component)eLabel, TableLayoutConstraints.newSpan(1, n2, 3, n2));
        for (n = 0; n < this.rows.length; ++n) {
            tableLayout.insertRow(++n2, this.rowHeight);
            jPanel.add((Component)this.rowELabels[n], TableLayoutConstraints.newCell(0, n2));
            statusProviderArray = this.rows[n].getStatusProviders();
            for (int i = 0; i < statusProviderArray.length; ++i) {
                jPanel.add((Component)new LED(LED.Type.red, statusProviderArray[i]), TableLayoutConstraints.newCell(i + 1, n2));
            }
        }
        tableLayout.insertRow(++n2, 2.0f);
        for (n = 0; n < this.twoReadingRows.length; ++n) {
            statusProviderArray = this.twoReadingRows[n];
            tableLayout.insertRow(++n2, this.rowHeight);
            this.addResultField(jPanel, Color.white, PanelProperties.TITLE_FONT, n2, (TwoReadingRow)statusProviderArray, new TableLayoutConstraints[]{TableLayoutConstraints.newCell(0, n2), TableLayoutConstraints.newSpan(1, n2, 3, n2), TableLayoutConstraints.newSpan(4, n2, 5, n2), TableLayoutConstraints.newCell(6, n2), TableLayoutConstraints.newCell(7, n2)});
        }
        for (n = 0; n < this.readingFields.length; ++n) {
            tableLayout.insertRow(++n2, this.rowHeight);
            this.addResultField(jPanel, Color.white, PanelProperties.TITLE_FONT, n2, this.readingFields[n], TableLayoutConstraints.newSpan(1, n2, 6, n2), TableLayoutConstraints.newCell(7, n2));
        }
        tableLayout.insertRow(++n2, -1.0f);
        return jPanel;
    }

    private ELabel createLabel(String string) {
        return new ELabel(string, PanelProperties.TEXT_COLOR, PanelProperties.TITLE_FONT, 3, 2);
    }

    public ELabel getELabel(String string) {
        for (int i = 0; i < this.rowELabels.length; ++i) {
            ELabel eLabel = this.rowELabels[i];
            if (!eLabel.getText().equals(string)) continue;
            return eLabel;
        }
        this.logger.error("Could not find ELabel with name: " + string);
        return new ELabel(4);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

