/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.util.UIHelper;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.E1MeasurementSettings;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.T1MeasurementSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ModeTitle
extends JPanel
implements ValueListener {
    static final String TEST_MODE_TITLE_KEY_PREFIX = "TestMode.title.";
    private final ELabel titleLabel;
    private final ELabel configLabel;
    private CommonBackhaulMeasurementSettings measurementSettings;
    private JLabel loopStatusLabel;
    ValueListener loopStateListener;
    private boolean doingT1 = false;
    private final String listenerName = "ModeTitleListener";

    public ModeTitle(CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        super(new BorderLayout());
        if (commonBackhaulMeasurementSettings instanceof T1MeasurementSettings) {
            this.doingT1 = true;
        }
        this.measurementSettings = commonBackhaulMeasurementSettings;
        this.setBackground(PanelProperties.TEST_MODE_BORDER.getBackgroundColor());
        float[][] fArrayArray = new float[][]{{-2.0f, -1.0f, 0.5f}, {-2.0f, -2.0f}};
        JPanel jPanel = new JPanel(new TableLayout(fArrayArray));
        jPanel.add((Component)new ELabel(Text.Test_Mode_colon, Color.yellow, PanelProperties.TEST_MODE_FONT), "0,0");
        this.titleLabel = new ELabel(this.getCurrentModeText(), Color.yellow, PanelProperties.TEST_MODE_FONT);
        jPanel.add((Component)this.titleLabel, "1,0,2,0");
        this.configLabel = new ELabel(this.getCurrentConfigText(), Color.yellow, PanelProperties.TEST_MODE_CONFIG_FONT);
        String string = this.doingT1 ? "0,1,1,1" : "0,1,2,1";
        jPanel.add((Component)this.configLabel, string);
        if (this.doingT1) {
            this.setupLoopingForT1(jPanel);
        }
        this.add((Component)new BorderWrapper(jPanel, PanelProperties.TEST_MODE_BORDER, true), "North");
    }

    private void setupLoopingForT1(JPanel jPanel) {
        this.loopStatusLabel = new JLabel("", 4);
        this.loopStatusLabel.setFont(PanelProperties.TEST_MODE_CONFIG_FONT);
        this.loopStatusLabel.setForeground(Color.yellow);
        this.updateLoopStateLabel((T1MeasurementSettings)this.measurementSettings);
        jPanel.add((Component)this.loopStatusLabel, "2,1,1,1");
        this.loopStateListener = new ValueListener(){
            private final String loopListenerName = "ModeTitle.loopStateListener";

            public String getListenerName() {
                return "ModeTitle.loopStateListener";
            }

            public void valueChanged(ValueInterface valueInterface) {
                ModeTitle.this.updateLoopStateLabel((T1MeasurementSettings)ModeTitle.this.measurementSettings);
            }
        };
    }

    public void addNotify() {
        this.measurementSettings.getRxInput().addValueListener(this);
        this.measurementSettings.getLineCode().addValueListener(this);
        this.measurementSettings.getTestPattern().addValueListener(this);
        this.measurementSettings.getFraming().addValueListener(this);
        this.measurementSettings.getControlMode().addValueListener(this);
        if (this.doingT1) {
            this.addValueListenersForT1((T1MeasurementSettings)this.measurementSettings);
        } else {
            ((E1MeasurementSettings)this.measurementSettings).getTimeslot().addValueListener(this);
        }
        this.updateConfigLabel();
        super.addNotify();
    }

    private void addValueListenersForT1(T1MeasurementSettings t1MeasurementSettings) {
        t1MeasurementSettings.getLoopState().addValueListener(this.loopStateListener);
        t1MeasurementSettings.getLoopbackLoopState().addValueListener(this.loopStateListener);
        t1MeasurementSettings.getChannel().addValueListener(this);
        t1MeasurementSettings.getEsfCode().addValueListener(this);
    }

    public void removeNotify() {
        this.measurementSettings.getRxInput().removeValueListener(this);
        this.measurementSettings.getLineCode().removeValueListener(this);
        this.measurementSettings.getTestPattern().removeValueListener(this);
        this.measurementSettings.getFraming().removeValueListener(this);
        this.measurementSettings.getControlMode().removeValueListener(this);
        if (this.doingT1) {
            this.removeValueListenersForT1((T1MeasurementSettings)this.measurementSettings);
        } else {
            ((E1MeasurementSettings)this.measurementSettings).getTimeslot().removeValueListener(this);
        }
        super.removeNotify();
    }

    private void removeValueListenersForT1(T1MeasurementSettings t1MeasurementSettings) {
        t1MeasurementSettings.getLoopState().removeValueListener(this.loopStateListener);
        t1MeasurementSettings.getLoopbackLoopState().removeValueListener(this.loopStateListener);
        t1MeasurementSettings.getChannel().removeValueListener(this);
        t1MeasurementSettings.getEsfCode().removeValueListener(this);
    }

    private void updateLoopStateLabel(T1MeasurementSettings t1MeasurementSettings) {
        if (t1MeasurementSettings.isEmulateMode()) {
            this.loopStatusLabel.setText(t1MeasurementSettings.getLoopState().toString());
        } else if (t1MeasurementSettings.isLoopbackMode()) {
            this.loopStatusLabel.setText(t1MeasurementSettings.getLoopbackLoopState().toString());
        } else {
            this.loopStatusLabel.setText("");
        }
    }

    private void updateConfigLabel() {
        this.titleLabel.setChunk(0, this.getCurrentModeText());
        this.configLabel.setChunk(0, this.getCurrentConfigText());
        if (this.doingT1) {
            this.updateLoopStateLabel((T1MeasurementSettings)this.measurementSettings);
        }
    }

    String getCurrentConfigText() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.measurementSettings.getRxInput().getSelectedValue().getLabel());
        if (!this.measurementSettings.isDelayMode()) {
            stringBuffer.append(", ");
            stringBuffer.append(UIHelper.stripNewlines(this.measurementSettings.getLineCode().toString()));
            stringBuffer.append(", ");
            stringBuffer.append(UIHelper.stripNewlines(this.measurementSettings.getFraming().toString()));
            stringBuffer.append(", ");
            stringBuffer.append(UIHelper.stripNewlines(this.measurementSettings.getTestPattern().getValueList()[this.measurementSettings.getTestPattern().getSelectedValueIndex()].getLongLabel()));
            if (this.doingT1) {
                this.addT1String(stringBuffer, (T1MeasurementSettings)this.measurementSettings);
            } else {
                this.addE1String(stringBuffer, (E1MeasurementSettings)this.measurementSettings);
            }
        }
        return stringBuffer.toString();
    }

    private void addE1String(StringBuffer stringBuffer, E1MeasurementSettings e1MeasurementSettings) {
        stringBuffer.append(", ");
        if (e1MeasurementSettings.isChannelMode()) {
            stringBuffer.append(Text.Timeslot + ":");
            stringBuffer.append(e1MeasurementSettings.getTimeslot().toString());
            stringBuffer.append(", ");
        }
        stringBuffer.append(Text.TX_Pattern + ":");
        stringBuffer.append(e1MeasurementSettings.getInvertedPattern().toString());
    }

    private void addT1String(StringBuffer stringBuffer, T1MeasurementSettings t1MeasurementSettings) {
        if (t1MeasurementSettings.isLoopbackMode() || t1MeasurementSettings.isEmulateMode()) {
            stringBuffer.append(", ");
            stringBuffer.append(UIHelper.stripNewlines(t1MeasurementSettings.getEsfCode().toString()));
        }
        if (t1MeasurementSettings.isChannelMode()) {
            stringBuffer.append(", ");
            stringBuffer.append(Text.Chan + ":");
            stringBuffer.append(UIHelper.stripNewlines(t1MeasurementSettings.getChannel().toString()));
        }
    }

    public String getListenerName() {
        return "ModeTitleListener";
    }

    public void valueChanged(ValueInterface valueInterface) {
        this.updateConfigLabel();
    }

    public String getCurrentModeText() {
        return Text.get(this.getPrefix() + TEST_MODE_TITLE_KEY_PREFIX + this.measurementSettings.getControlMode().intValue());
    }

    private String getPrefix() {
        return this.doingT1 ? "T1." : "E1.";
    }

    protected String getModeTitle(int n) {
        return Text.get(this.getPrefix() + TEST_MODE_TITLE_KEY_PREFIX + n);
    }

    ELabel getTitleLabel() {
        return this.titleLabel;
    }

    JLabel getLoopStatusLabel() {
        return this.loopStatusLabel;
    }
}

