/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.widgets.ELabel;
import elgato.measurement.backhaul.PerformanceRow;
import elgato.measurement.backhaul.ResultPanel;
import elgato.measurement.backhaul.TwoFieldRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

public class PerformanceResultsPanel
extends ResultPanel {
    private PerformanceRow[] rows;
    private TabDelimitable[] tabDelimitables;

    public PerformanceResultsPanel(int n, String string, String string2, String string3, PerformanceRow[] performanceRowArray) {
        super(n, string, string2 + " " + string3, string2 + ": " + string3);
        this.rows = performanceRowArray;
        this.tabDelimitables = performanceRowArray;
    }

    TabDelimitable[] getTabDelimitedFields() {
        return this.tabDelimitables;
    }

    protected Component createResultsSubPanel() {
        float[] fArray = new float[this.rows.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = -2.0f;
        }
        float[][] fArrayArray = new float[][]{{0.4f, 2.0f, 0.3f, 2.0f, 0.3f, 2.0f, -2.0f}, fArray};
        JPanel jPanel = new JPanel(new TableLayout(fArrayArray));
        ((Component)jPanel).setBackground(null);
        Font font = new Font("SansSerif", 0, 12);
        Color color = Color.white;
        for (int i = 0; i < this.rows.length; ++i) {
            this.addRow(jPanel, color, font, i, this.rows[i]);
        }
        return jPanel;
    }

    public TwoFieldRow[] getRows() {
        return this.rows;
    }

    private void addRow(Container container, Color color, Font font, int n, final TwoFieldRow twoFieldRow) {
        ColumnValue columnValue = new ColumnValue(){

            public String getValue() {
                return twoFieldRow.getColumn1Value();
            }
        };
        ColumnValue columnValue2 = new ColumnValue(){

            public String getValue() {
                return twoFieldRow.getColumn2Value();
            }
        };
        ELabel eLabel = this.createDynamicLabel(columnValue, color, font);
        eLabel.setHAlignment(4);
        ELabel eLabel2 = this.createDynamicLabel(columnValue2, color, font);
        eLabel2.setHAlignment(4);
        container.add((Component)new ELabel(twoFieldRow.getLabel(), color, font), "0," + n);
        container.add((Component)eLabel, "2," + n);
        container.add((Component)eLabel2, "4," + n);
        container.add((Component)new ELabel(twoFieldRow.getColumn2Units(), color, font), "6," + n);
    }

    protected ELabel createDynamicLabel(final ColumnValue columnValue, Color color, Font font) {
        return new ELabel(columnValue.getValue(), color, font){

            public void paint(Graphics graphics) {
                this.setTextNoRepaint(columnValue.getValue());
                super.paint(graphics);
            }
        };
    }

    private static interface ColumnValue {
        public String getValue();
    }
}

