/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.analyzer.Analyzer;
import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.measurement.backhaul.TwoFieldRow;
import java.text.NumberFormat;

class PerformanceRow
implements TwoFieldRow,
TabDelimitable {
    private String label;
    private int column1Reading;
    private int column2Reading;
    private NumberFormat percentFormat = NumberFormat.getNumberInstance();
    private Analyzer analyzer;
    private String longLabel;

    public PerformanceRow(Analyzer analyzer, String string, String string2, int n, int n2) {
        this.analyzer = analyzer;
        this.label = string;
        this.longLabel = string2;
        this.column1Reading = n;
        this.column2Reading = n2;
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
    }

    public String getLabel() {
        return this.label;
    }

    public String getColumn1Value() {
        if (this.analyzer.getMeasurement() == null) {
            return "";
        }
        return String.valueOf(this.analyzer.getMeasurement().getIntegerReadingValue(this.column1Reading));
    }

    public String getColumn1Units() {
        return "";
    }

    public String getColumn2Value() {
        if (this.analyzer.getMeasurement() == null) {
            return "";
        }
        return this.percentFormat.format(this.analyzer.getMeasurement().getFloatReadingValue(this.column2Reading));
    }

    public String getColumn2Units() {
        return "%";
    }

    public String toTabDelimitedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.longLabel).append('\t').append(this.getColumn1Value()).append('\t').append(this.getColumn2Value());
        return stringBuffer.toString();
    }
}

