/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.mainScreens.TabDelimitable;
import elgato.infrastructure.readings.ReadingField;
import elgato.infrastructure.tablelayout.TableLayout;
import elgato.infrastructure.tablelayout.TableLayoutConstraints;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.ELabel;
import elgato.infrastructure.widgets.Glue;
import elgato.infrastructure.widgets.HydroBorderPainterConfig;
import elgato.measurement.backhaul.PanelProperties;
import elgato.measurement.backhaul.TwoReadingRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

public class ResultPanel {
    private final String buttonName;
    private final String listName;
    private final String panelName;
    private final ReadingField[] readingFields;
    protected TwoReadingRow[] twoReadingRows = new TwoReadingRow[0];
    private final int resultKey;

    protected ResultPanel(int n, String string, String string2, String string3) {
        this(n, string, string2, string3, new ReadingField[0]);
    }

    protected ResultPanel(int n, String string, String string2) {
        this(n, string, string2, string2, new ReadingField[0]);
    }

    public ResultPanel(int n, String string, String string2, ReadingField[] readingFieldArray) {
        this(n, string, string2, string2, readingFieldArray);
    }

    public ResultPanel(int n, String string, String string2, String string3, ReadingField[] readingFieldArray) {
        this.buttonName = string;
        this.listName = string2;
        this.panelName = string3;
        this.readingFields = readingFieldArray;
        this.resultKey = n;
    }

    public ResultPanel(int n, String string, String string2, String string3, ReadingField[] readingFieldArray, TwoReadingRow[] twoReadingRowArray) {
        this.buttonName = string;
        this.listName = string2;
        this.panelName = string3;
        this.readingFields = readingFieldArray;
        this.resultKey = n;
        this.twoReadingRows = twoReadingRowArray;
    }

    public String getButtonName() {
        return this.buttonName;
    }

    public String getListName() {
        return this.listName;
    }

    public String getPanelName() {
        return this.panelName;
    }

    public String toString() {
        return this.buttonName;
    }

    TabDelimitable[] getTabDelimitedFields() {
        TabDelimitable[] tabDelimitableArray = new TabDelimitable[this.readingFields.length + this.twoReadingRows.length];
        System.arraycopy(this.readingFields, 0, tabDelimitableArray, 0, this.readingFields.length);
        System.arraycopy(this.twoReadingRows, 0, tabDelimitableArray, this.readingFields.length, this.twoReadingRows.length);
        return tabDelimitableArray;
    }

    ReadingField[] getReadingFields() {
        return this.readingFields;
    }

    public Container createComponent() {
        return this.createComponent(Text.Results, -1.0f);
    }

    protected Container createComponent(String string, float f) {
        float[][] fArrayArray = new float[][]{{f}, {-2.0f, -1.0f}};
        JPanel jPanel = new JPanel(new TableLayout(fArrayArray));
        jPanel.add(this.createPanelTitleTab(string), "0,0");
        jPanel.add(this.createResultsSubPanel(), "0,1");
        return this.borderizePanel(jPanel, PanelProperties.MEASUREMENT_PANEL_BORDER, true);
    }

    private Component createPanelTitleTab(String string) {
        float[][] fArrayArray = new float[][]{{-2.0f, 6.0f, -1.0f}, {-2.0f, PanelProperties.RULE_SIZE, 5.0f}};
        JPanel jPanel = new JPanel(new TableLayout(fArrayArray));
        ((Component)jPanel).setBackground(null);
        ELabel eLabel = new ELabel(string, PanelProperties.TEXT_COLOR, PanelProperties.TITLE_FONT, 3, 2);
        ELabel eLabel2 = new ELabel(this.getPanelName(), PanelProperties.MEASUREMENT_PANEL_TAB_COLOR, PanelProperties.TITLE_FONT, 3, 2);
        jPanel.add((Component)eLabel, "0,0");
        jPanel.add((Component)new BorderWrapper(eLabel2, PanelProperties.MEASUREMENT_PANEL_TAB_BORDER, false), "2,0");
        jPanel.add((Component)new Glue(1, PanelProperties.RULE_SIZE, PanelProperties.RULE_COLOR), "0,1,2,1");
        return jPanel;
    }

    protected Component createResultsSubPanel() {
        int n;
        float f = 40.0f;
        float[] fArray = new float[this.readingFields.length + this.twoReadingRows.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = -2.0f;
        }
        float[][] fArrayArray = new float[][]{{140.0f, 40.0f, f, -1.0f, -2.0f}, fArray};
        TableLayout tableLayout = new TableLayout(fArrayArray);
        JPanel jPanel = new JPanel(tableLayout);
        ((Component)jPanel).setBackground(null);
        Font font = new Font("SansSerif", 0, 12);
        Color color = Color.white;
        int n2 = -1;
        for (n = 0; n < this.twoReadingRows.length; ++n) {
            this.addResultField(jPanel, color, font, n2, this.twoReadingRows[n], new TableLayoutConstraints[]{TableLayoutConstraints.newCell(0, ++n2), TableLayoutConstraints.newCell(1, n2), TableLayoutConstraints.newCell(2, n2), TableLayoutConstraints.newCell(3, n2), TableLayoutConstraints.newCell(4, n2)});
        }
        for (n = 0; n < this.readingFields.length; ++n) {
            ReadingField readingField = this.readingFields[n];
            this.addResultField(jPanel, color, font, ++n2, readingField, TableLayoutConstraints.newSpan(1, n2, 3, n2), TableLayoutConstraints.newCell(4, n2));
        }
        return jPanel;
    }

    protected void addResultField(Container container, Color color, Font font, int n, final TwoReadingRow twoReadingRow, TableLayoutConstraints[] tableLayoutConstraintsArray) {
        if (tableLayoutConstraintsArray.length != 5) {
            throw new IllegalArgumentException("Must provide 5 constraints to add a two reading row");
        }
        container.add((Component)new ELabel(twoReadingRow.getLabel(), color, font), tableLayoutConstraintsArray[0]);
        ELabel eLabel = new ELabel(twoReadingRow.getColumn1Value(), color, font){

            public void paint(Graphics graphics) {
                this.setTextNoRepaint(twoReadingRow.getColumn1Value());
                super.paint(graphics);
            }
        };
        ELabel eLabel2 = new ELabel(twoReadingRow.getColumn2Value(), color, font){

            public void paint(Graphics graphics) {
                this.setTextNoRepaint(twoReadingRow.getColumn2Value());
                super.paint(graphics);
            }
        };
        container.add((Component)eLabel, tableLayoutConstraintsArray[1]);
        container.add((Component)new ELabel(twoReadingRow.getColumn1Units(), color, font), tableLayoutConstraintsArray[2]);
        container.add((Component)eLabel2, tableLayoutConstraintsArray[3]);
        container.add((Component)new ELabel(twoReadingRow.getColumn2Units(), color, font), tableLayoutConstraintsArray[4]);
    }

    protected void addResultField(Container container, Color color, Font font, int n, ReadingField readingField, TableLayoutConstraints tableLayoutConstraints, TableLayoutConstraints tableLayoutConstraints2) {
        container.add((Component)new ELabel(readingField.getLabel(), color, font), TableLayoutConstraints.newCell(0, n));
        container.add((Component)readingField.createDynamicLabel(Color.white, font), tableLayoutConstraints);
        container.add((Component)new ELabel(readingField.getUnits(), color, font), tableLayoutConstraints2);
    }

    protected BorderWrapper borderizePanel(Container container, HydroBorderPainterConfig hydroBorderPainterConfig, boolean bl) {
        return new BorderWrapper(container, hydroBorderPainterConfig, bl, 5, 1);
    }

    public static ResultPanel createPrimaryResultPanel(int n, String string, String string2, ReadingField[] readingFieldArray) {
        return new ResultPanel(n, Text.Pri + " " + string, Text.Primary + " " + string2, Text.Primary + ": " + string2, readingFieldArray);
    }

    public static ResultPanel createPrimaryResultPanel(int n, String string, String string2, String string3, ReadingField[] readingFieldArray) {
        return new ResultPanel(n, Text.Pri + " " + string, Text.Primary + " " + string2, Text.Primary + ": " + string3, readingFieldArray);
    }

    public static ResultPanel createPrimaryResultPanel(int n, String string, String string2, String string3, ReadingField[] readingFieldArray, TwoReadingRow[] twoReadingRowArray) {
        return new ResultPanel(n, Text.Pri + " " + string, Text.Primary + " " + string2, Text.Primary + ": " + string3, readingFieldArray, twoReadingRowArray);
    }

    public static ResultPanel createSecondaryResultPanel(int n, String string, String string2, ReadingField[] readingFieldArray) {
        return new ResultPanel(n, Text.Sec + " " + string, Text.Secondary + " " + string2, Text.Secondary + ": " + string2, readingFieldArray);
    }

    public static ResultPanel createSecondaryResultPanel(int n, String string, String string2, String string3, ReadingField[] readingFieldArray) {
        return new ResultPanel(n, Text.Sec + " " + string, Text.Secondary + " " + string2, Text.Secondary + ": " + string3, readingFieldArray);
    }

    public int getResultKey() {
        return this.resultKey;
    }
}

