/*
 * Decompiled with CFR 0.152.
 */
package elgato.measurement.backhaul;

import elgato.infrastructure.actuators.ActuatorEditor;
import elgato.infrastructure.actuators.ActuatorSubMenuButton;
import elgato.infrastructure.actuators.ListActuator;
import elgato.infrastructure.actuators.ListActuatorButton;
import elgato.infrastructure.actuators.LongActuator;
import elgato.infrastructure.mainScreens.ScreenManager;
import elgato.infrastructure.mainScreens.SetupPanel;
import elgato.infrastructure.menu.Menu;
import elgato.infrastructure.menu.MenuItem;
import elgato.infrastructure.menu.PushButton;
import elgato.infrastructure.util.Resources;
import elgato.infrastructure.util.Text;
import elgato.infrastructure.valueobject.Value;
import elgato.infrastructure.valueobject.ValueInterface;
import elgato.infrastructure.valueobject.ValueListInterface;
import elgato.infrastructure.valueobject.ValueListener;
import elgato.infrastructure.widgets.BorderWrapper;
import elgato.infrastructure.widgets.DefaultEListModel;
import elgato.measurement.backhaul.CommonBackhaulMeasurementSettings;
import elgato.measurement.backhaul.ModeTitle;
import elgato.measurement.backhaul.SetupScreen;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;

public abstract class SetupMenuMgr {
    private SetupPanel setupPanel;
    private BorderWrapper border;
    protected Menu firstSetupMenu;
    private ScreenManager screenManager;
    protected CommonBackhaulMeasurementSettings settings;
    protected SetupScreen scn;
    private static SetupScreen scnStatic;
    protected String listenerBaseName;
    protected ValueListener valueListener = new ValueListener(){
        private String listenerName = ".valueListener";
        private String backhaulClass = null;

        public String getListenerName() {
            if (this.backhaulClass == null) {
                this.backhaulClass = SetupMenuMgr.this.getListenerBaseName();
                this.listenerName = this.backhaulClass + this.listenerName;
            }
            return this.listenerName;
        }

        public void valueChanged(ValueInterface valueInterface) {
            SetupMenuMgr.this.getSetupPanel().repaint();
        }
    };
    static /* synthetic */ Class class$elgato$measurement$backhaul$T1Screen;

    public SetupMenuMgr(SetupScreen setupScreen, CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings) {
        this.scn = setupScreen;
        this.settings = commonBackhaulMeasurementSettings;
        scnStatic = setupScreen;
    }

    public void prolog() {
        this.screenManager = this.scn.getScreenManager();
        this.setupPanel = new SetupPanel();
        this.border = new BorderWrapper(this.setupPanel, Resources.getResources((class$elgato$measurement$backhaul$T1Screen == null ? (class$elgato$measurement$backhaul$T1Screen = SetupMenuMgr.class$("elgato.measurement.backhaul.T1Screen")) : class$elgato$measurement$backhaul$T1Screen).getName()).getBorderConfig("border"), true);
        this.firstSetupMenu = this.createFirstSetupMenu();
        this.firstSetupMenu.setMenuItem(this.createMoreButton(this.createSecondSetupMenu(), Text.More_n_1_of_2), 6);
        this.screenManager.installRightMenu(this.firstSetupMenu);
        this.screenManager.installDisplay(this.createDisplay());
        this.addValueListeners();
    }

    public void cleanup() {
        this.removeValueListeners();
    }

    public String getListenerBaseName() {
        if (this.listenerBaseName == null) {
            this.listenerBaseName = this.getClass().getName();
            int n = this.listenerBaseName.lastIndexOf(".");
            if (n > -1) {
                try {
                    this.listenerBaseName = this.listenerBaseName.substring(n + 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.listenerBaseName;
    }

    private void addValueListeners() {
        this.settings.getLineCode().addValueListener(this.valueListener);
        this.settings.getTestPattern().addValueListener(this.valueListener);
        this.settings.getRxInput().addValueListener(this.valueListener);
        this.settings.getFraming().addValueListener(this.valueListener);
        this.settings.getTxClock().addValueListener(this.valueListener);
        this.settings.getFillData().addValueListener(this.valueListener);
        this.settings.getSlipRef().addValueListener(this.valueListener);
        this.settings.getSecondaryTx().addValueListener(this.valueListener);
        this.addAdditionalValueListeners();
    }

    protected void removeValueListeners() {
        this.settings.getLineCode().removeValueListener(this.valueListener);
        this.settings.getTestPattern().removeValueListener(this.valueListener);
        this.settings.getRxInput().removeValueListener(this.valueListener);
        this.settings.getFraming().removeValueListener(this.valueListener);
        this.settings.getTxClock().removeValueListener(this.valueListener);
        this.settings.getFillData().removeValueListener(this.valueListener);
        this.settings.getSlipRef().removeValueListener(this.valueListener);
        this.settings.getSecondaryTx().removeValueListener(this.valueListener);
        this.removeAdditionalValueListeners();
    }

    SetupPanel getSetupPanel() {
        return this.setupPanel;
    }

    public Component createDisplay() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new ModeTitle(this.settings), "North");
        jPanel.add((Component)this.border, "Center");
        return jPanel;
    }

    protected PushButton createMoreButton(final Menu menu, String string) {
        return new PushButton(string, "", new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetupMenuMgr.this.scn.getScreenManager().installRightMenu(menu);
            }
        });
    }

    protected MenuItem createRxInputButton() {
        return this.createSetupButton(this.settings.getRxInput(), SetupScreen.getContextString("rxinput"));
    }

    protected MenuItem createFramingButton() {
        return this.createSetupButton(this.settings.getFraming(), SetupScreen.getContextString("framing"));
    }

    protected MenuItem createSetupButton(LongActuator longActuator, String string) {
        ActuatorEditor actuatorEditor = new ActuatorEditor(longActuator, string, this.getListenerBaseName() + ".longSetupButton");
        return this.addToSetupPanel(actuatorEditor);
    }

    protected MenuItem createSetupButton(ListActuator listActuator, String string) {
        ActuatorSubMenuButton actuatorSubMenuButton = new ActuatorSubMenuButton(listActuator, string, true, this.getListenerBaseName() + ".listSetupButton");
        return this.addToSetupPanel(actuatorSubMenuButton);
    }

    protected MenuItem createLineCodeButton() {
        ActuatorSubMenuButton actuatorSubMenuButton = new ActuatorSubMenuButton(this.settings.getLineCode(), SetupScreen.getContextString("linecode"), true, this.getListenerBaseName() + ".lineCodeButton"){

            protected ValueInterface[] getButtonValues(ValueListInterface valueListInterface) {
                return SetupMenuMgr.getArrayWithoutLastOne(valueListInterface);
            }
        };
        this.addToSetupPanel(actuatorSubMenuButton);
        return actuatorSubMenuButton;
    }

    private MenuItem addToSetupPanel(MenuItem menuItem) {
        this.setupPanel.addItem(menuItem);
        return menuItem;
    }

    protected MenuItem createFillDataButton() {
        MenuItem menuItem = this.createSetupButton(this.settings.getFillData(), SetupScreen.getContextString("filldata"));
        menuItem.setEnabled(this.settings.isChannelMode());
        return menuItem;
    }

    protected MenuItem createSlipRefButton() {
        MenuItem menuItem = this.createSetupButton(this.settings.getSlipRef(), SetupScreen.getContextString("slipref"));
        menuItem.setEnabled(!this.settings.isDelayMode() && !this.settings.isEmulateMode());
        return menuItem;
    }

    protected MenuItem createSecondTxButton() {
        MenuItem menuItem = this.createSetupButton(this.settings.getSecondaryTx(), SetupScreen.getContextString("secondtx"));
        menuItem.setEnabled(!this.settings.isDelayMode() && !this.settings.isEmulateMode());
        return menuItem;
    }

    protected MenuItem createPatternSetupButton() {
        MenuItem menuItem = SetupMenuMgr.createPatternButton(this.settings, this.getListenerBaseName());
        this.addToSetupPanel(menuItem);
        return menuItem;
    }

    public static MenuItem createPatternButton(CommonBackhaulMeasurementSettings commonBackhaulMeasurementSettings, String string) {
        return new ListActuatorButton(commonBackhaulMeasurementSettings.getTestPattern(), SetupScreen.getContextString("pattern"), string + ".patternButton"){

            protected DefaultEListModel createListModel(ListActuator listActuator) {
                return new DefaultEListModel(SetupMenuMgr.getArrayWithoutLastOne(listActuator));
            }
        };
    }

    private static Value[] getArrayWithoutLastOne(ValueListInterface valueListInterface) {
        ValueInterface[] valueInterfaceArray = valueListInterface.getValueList();
        Value[] valueArray = new Value[valueInterfaceArray.length - 1];
        System.arraycopy(valueInterfaceArray, 0, valueArray, 0, valueArray.length);
        return valueArray;
    }

    protected abstract Menu createFirstSetupMenu();

    protected abstract Menu createSecondSetupMenu();

    protected abstract void addAdditionalValueListeners();

    protected abstract void removeAdditionalValueListeners();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

